package org.faktorips.tutorial.model.hausrat;

import org.faktorips.runtime.model.annotation.IpsProductCmptType;
import org.faktorips.runtime.model.annotation.IpsAttributes;
import org.faktorips.runtime.model.annotation.IpsConfigures;
import org.faktorips.runtime.model.annotation.IpsFormulas;
import org.faktorips.runtime.model.annotation.IpsDocumented;
import org.faktorips.runtime.internal.ProductComponent;
import org.faktorips.runtime.model.annotation.IpsAllowedValues;
import org.faktorips.valueset.ValueSet;
import org.faktorips.valueset.UnrestrictedValueSet;
import org.faktorips.runtime.model.annotation.IpsDefaultValue;
import org.faktorips.values.Decimal;
import org.faktorips.values.Money;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.model.annotation.IpsAttribute;
import org.faktorips.runtime.model.type.AttributeKind;
import org.faktorips.runtime.model.type.ValueSetKind;
import org.faktorips.runtime.model.annotation.IpsAttributeSetter;
import org.faktorips.runtime.IllegalRepositoryModificationException;
import org.faktorips.runtime.model.annotation.IpsFormula;
import org.faktorips.runtime.FormulaExecutionException;
import org.w3c.dom.Element;
import java.util.Map;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.faktorips.runtime.IModifiableRuntimeRepository;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.annotation.IpsGenerated;

/**
 * Implementierung von HausratZusatzdeckungstyp.
 *
 * @generated
 */
@IpsProductCmptType(name = "hausrat.HausratZusatzdeckungstyp")
@IpsAttributes({ "bezeichnung", "versSummenFaktor", "maximaleVersSumme" })
@IpsConfigures(HausratZusatzdeckung.class)
@IpsFormulas({ "jahresbasisbeitrag" })
@IpsDocumented(bundleName = "org.faktorips.tutorial.model.model-label-and-descriptions", defaultLocale = "de")
public class HausratZusatzdeckungstyp extends ProductComponent {

    /**
     * Diese Konstante enthält den Namen der Eigenschaft bezeichnung.
     *
     * @generated
     */
    public static final String PROPERTY_BEZEICHNUNG = "bezeichnung";
    /**
     * Die maximal erlaubten Werte fuer die Eigenschaft bezeichnung.
     *
     * @generated
     */
    @IpsAllowedValues("bezeichnung")
    public static final ValueSet<String> MAX_ALLOWED_VALUES_FOR_BEZEICHNUNG = new UnrestrictedValueSet<>(true);
    /**
     * Der Vorgabewert des Attributs bezeichnung.
     *
     * @generated
     */
    @IpsDefaultValue("bezeichnung")
    public static final String DEFAULT_VALUE_FOR_BEZEICHNUNG = null;
    /**
     * Diese Konstante enthält den Namen der Eigenschaft versSummenFaktor.
     *
     * @generated
     */
    public static final String PROPERTY_VERSSUMMENFAKTOR = "versSummenFaktor";
    /**
     * Die maximal erlaubten Werte fuer die Eigenschaft versSummenFaktor.
     *
     * @generated
     */
    @IpsAllowedValues("versSummenFaktor")
    public static final ValueSet<Decimal> MAX_ALLOWED_VALUES_FOR_VERS_SUMMEN_FAKTOR = new UnrestrictedValueSet<>(true);
    /**
     * Der Vorgabewert des Attributs versSummenFaktor.
     *
     * @generated
     */
    @IpsDefaultValue("versSummenFaktor")
    public static final Decimal DEFAULT_VALUE_FOR_VERS_SUMMEN_FAKTOR = Decimal.NULL;
    /**
     * Diese Konstante enthält den Namen der Eigenschaft maximaleVersSumme.
     *
     * @generated
     */
    public static final String PROPERTY_MAXIMALEVERSSUMME = "maximaleVersSumme";
    /**
     * Die maximal erlaubten Werte fuer die Eigenschaft maximaleVersSumme.
     *
     * @generated
     */
    @IpsAllowedValues("maximaleVersSumme")
    public static final ValueSet<Money> MAX_ALLOWED_VALUES_FOR_MAXIMALE_VERS_SUMME = new UnrestrictedValueSet<>(true);
    /**
     * Der Vorgabewert des Attributs maximaleVersSumme.
     *
     * @generated
     */
    @IpsDefaultValue("maximaleVersSumme")
    public static final Money DEFAULT_VALUE_FOR_MAXIMALE_VERS_SUMME = Money.NULL;

    /**
     * Membervariable für die Produkteigenschaft Bezeichnung.
     *
     * @generated
     */
    private String bezeichnung = DEFAULT_VALUE_FOR_BEZEICHNUNG;
    /**
     * Membervariable für die Produkteigenschaft VersSummenFaktor.
     *
     * @generated
     */
    private Decimal versSummenFaktor = DEFAULT_VALUE_FOR_VERS_SUMMEN_FAKTOR;
    /**
     * Membervariable für die Produkteigenschaft MaximaleVersSumme.
     *
     * @generated
     */
    private Money maximaleVersSumme = DEFAULT_VALUE_FOR_MAXIMALE_VERS_SUMME;

    /**
     * Erzeugt eine neue Instanz von HausratZusatzdeckungstyp.
     *
     * @generated
     */
    @IpsGenerated
    public HausratZusatzdeckungstyp(IRuntimeRepository repository, String id, String kindId, String versionId) {
        super(repository, id, kindId, versionId);
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public boolean isChangingOverTime() {
        return false;
    }

    /**
     * Gibt den Wert der Eigenschaft bezeichnung zurück.
     *
     * @generated
     */
    @IpsAttribute(name = "bezeichnung", kind = AttributeKind.CONSTANT, valueSetKind = ValueSetKind.AllValues)
    @IpsGenerated
    public String getBezeichnung() {
        return bezeichnung;
    }

    /**
     * Setzt den Wert der Eigenschaft bezeichnung.
     *
     * @generated
     */
    @IpsAttributeSetter("bezeichnung")
    @IpsGenerated
    public void setBezeichnung(String newValue) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        setBezeichnungInternal(newValue);
    }

    /**
     * Setzt den Wert der Eigenschaft bezeichnung.
     *
     * @generated
     */
    @IpsGenerated
    protected final void setBezeichnungInternal(String newValue) {
        this.bezeichnung = newValue;
    }

    /**
     * Gibt den Wert der Eigenschaft versSummenFaktor zurück.
     *
     * @generated
     */
    @IpsAttribute(name = "versSummenFaktor", kind = AttributeKind.CONSTANT, valueSetKind = ValueSetKind.AllValues)
    @IpsGenerated
    public Decimal getVersSummenFaktor() {
        return versSummenFaktor;
    }

    /**
     * Setzt den Wert der Eigenschaft versSummenFaktor.
     *
     * @generated
     */
    @IpsAttributeSetter("versSummenFaktor")
    @IpsGenerated
    public void setVersSummenFaktor(Decimal newValue) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        setVersSummenFaktorInternal(newValue);
    }

    /**
     * Setzt den Wert der Eigenschaft versSummenFaktor.
     *
     * @generated
     */
    @IpsGenerated
    protected final void setVersSummenFaktorInternal(Decimal newValue) {
        this.versSummenFaktor = newValue;
    }

    /**
     * Gibt den Wert der Eigenschaft maximaleVersSumme zurück.
     *
     * @generated
     */
    @IpsAttribute(name = "maximaleVersSumme", kind = AttributeKind.CONSTANT, valueSetKind = ValueSetKind.AllValues)
    @IpsGenerated
    public Money getMaximaleVersSumme() {
        return maximaleVersSumme;
    }

    /**
     * Setzt den Wert der Eigenschaft maximaleVersSumme.
     *
     * @generated
     */
    @IpsAttributeSetter("maximaleVersSumme")
    @IpsGenerated
    public void setMaximaleVersSumme(Money newValue) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        setMaximaleVersSummeInternal(newValue);
    }

    /**
     * Setzt den Wert der Eigenschaft maximaleVersSumme.
     *
     * @generated
     */
    @IpsGenerated
    protected final void setMaximaleVersSummeInternal(Money newValue) {
        this.maximaleVersSumme = newValue;
    }

    /**
     *
     *
     * @generated
     */
    @IpsFormula(name = "jahresbasisbeitrag", required = true)
    @IpsGenerated
    public Money berechneJahresbasisbeitrag(HausratVertrag vertrag, HausratZusatzdeckung deckung)
            throws FormulaExecutionException {
        return (Money)getFormulaEvaluator().evaluate("berechneJahresbasisbeitrag", vertrag, deckung);
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    protected void doInitPropertiesFromXml(Map<String, Element> configMap) {
        super.doInitPropertiesFromXml(configMap);
        doInitBezeichnung(configMap);
        doInitVersSummenFaktor(configMap);
        doInitMaximaleVersSumme(configMap);
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitBezeichnung(Map<String, Element> configMap) {
        Element configElement = configMap.get(PROPERTY_BEZEICHNUNG);
        if (configElement != null) {
            String value = ValueToXmlHelper.getValueFromElement(configElement, ValueToXmlHelper.XML_TAG_VALUE);
            this.bezeichnung = value;
        }
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitVersSummenFaktor(Map<String, Element> configMap) {
        Element configElement = configMap.get(PROPERTY_VERSSUMMENFAKTOR);
        if (configElement != null) {
            String value = ValueToXmlHelper.getValueFromElement(configElement, ValueToXmlHelper.XML_TAG_VALUE);
            this.versSummenFaktor = Decimal.valueOf(value);
        }
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitMaximaleVersSumme(Map<String, Element> configMap) {
        Element configElement = configMap.get(PROPERTY_MAXIMALEVERSSUMME);
        if (configElement != null) {
            String value = ValueToXmlHelper.getValueFromElement(configElement, ValueToXmlHelper.XML_TAG_VALUE);
            this.maximaleVersSumme = Money.valueOf(value);
        }
    }

    /**
     * Erzeugt eine neue Instanz von HausratZusatzdeckung, die durch diesen Produktbaustein
     * konfiguriert wird.
     *
     * @generated
     */
    @IpsGenerated
    public HausratZusatzdeckung createHausratZusatzdeckung() {
        HausratZusatzdeckung policy = new HausratZusatzdeckung(this);
        policy.initialize();
        return policy;
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public HausratZusatzdeckung createPolicyComponent() {
        return createHausratZusatzdeckung();
    }

    /**
     * Erzeugt ein neues HausratZusatzdeckungstypBuilder um dieses Produkt zu bearbeiten.
     *
     * @generated
     */
    @IpsGenerated
    public HausratZusatzdeckungstypBuilder modify() {
        return HausratZusatzdeckungstypBuilder.from(this, (IModifiableRuntimeRepository)this.getRepository());
    }

    /**
     * Erzeugt eine neue Instanz von HausratZusatzdeckungstyp mit einem
     * {@link IModifiableRuntimeRepository}, ID, kindID und versionID. Das Wirksamkeitsdatum der
     * neuen Instanz wird auf 1900/1/1 gesetzt.
     *
     * @generated
     */
    @IpsGenerated
    public static HausratZusatzdeckungstypBuilder builder(IModifiableRuntimeRepository runtimeRepository,
            String id,
            String kindId,
            String versionId) {
        HausratZusatzdeckungstyp product = new HausratZusatzdeckungstyp(runtimeRepository, id, kindId, versionId);
        product.setValidFrom(new DateTime(1900, 1, 1));
        runtimeRepository.putProductComponent(product);

        return new HausratZusatzdeckungstypBuilder(product, runtimeRepository);
    }

    /**
     * Erzeugt eine neue Instanz von HausratZusatzdeckungstyp mit einem
     * {@link IModifiableRuntimeRepository}, ID, kindID und versionID.
     *
     * @generated
     */
    @IpsGenerated
    public static HausratZusatzdeckungstypBuilder builder(IModifiableRuntimeRepository runtimeRepository,
            String id,
            String kindId,
            String versionId,
            DateTime validFrom) {
        HausratZusatzdeckungstyp product = new HausratZusatzdeckungstyp(runtimeRepository, id, kindId, versionId);
        product.setValidFrom(validFrom);
        runtimeRepository.putProductComponent(product);

        return new HausratZusatzdeckungstypBuilder(product, runtimeRepository);
    }

    /**
     * Erzeugt eine neue Instanz von HausratZusatzdeckungstyp mit dem ID von einem existierenden
     * Produktbaustein.
     *
     * @generated
     */
    @IpsGenerated
    public static HausratZusatzdeckungstypBuilder builder(IModifiableRuntimeRepository runtimeRepository,
            String prodCmptId) {
        HausratZusatzdeckungstyp product = (HausratZusatzdeckungstyp)runtimeRepository.getProductComponent(prodCmptId);

        if (product == null) {
            throw new RuntimeException("Keinen Produktbaustein mit der gegebenden ID gefunden!");
        } else {
            return HausratZusatzdeckungstypBuilder.from(product, runtimeRepository);
        }
    }
}
