package org.faktorips.tutorial.model.hausrat;

import java.util.Map;

import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.IllegalRepositoryModificationException;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.internal.ProductComponent;
import org.faktorips.runtime.model.annotation.IpsAllowedValues;
import org.faktorips.valueset.ValueSet;
import org.faktorips.valueset.UnrestrictedValueSet;
import org.faktorips.runtime.model.annotation.IpsDefaultValue;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.faktorips.runtime.IModifiableRuntimeRepository;
import org.faktorips.runtime.model.annotation.IpsAttribute;
import org.faktorips.runtime.model.annotation.IpsAttributeSetter;
import org.faktorips.runtime.model.annotation.IpsAttributes;
import org.faktorips.runtime.model.annotation.IpsConfigures;
import org.faktorips.runtime.model.annotation.IpsDocumented;
import org.faktorips.runtime.model.annotation.IpsProductCmptType;
import org.faktorips.runtime.model.annotation.IpsTableUsage;
import org.faktorips.runtime.model.annotation.IpsTableUsages;
import org.faktorips.runtime.model.type.AttributeKind;
import org.faktorips.runtime.model.type.ValueSetKind;
import org.w3c.dom.Element;
import org.faktorips.runtime.annotation.IpsGenerated;

/**
 * Implementierung von HausratGrunddeckungstyp.
 *
 * @generated
 */
@IpsProductCmptType(name = "hausrat.HausratGrunddeckungstyp")
@IpsAttributes({ "bezeichnung" })
@IpsConfigures(HausratGrunddeckung.class)
@IpsTableUsages({ "tariftabelle" })
@IpsDocumented(bundleName = "org.faktorips.tutorial.model.model-label-and-descriptions", defaultLocale = "de")
public class HausratGrunddeckungstyp extends ProductComponent {

    /**
     * Diese Konstante enthält den Namen der Eigenschaft bezeichnung.
     *
     * @generated
     */
    public static final String PROPERTY_BEZEICHNUNG = "bezeichnung";
    /**
     * Die maximal erlaubten Werte fuer die Eigenschaft bezeichnung.
     *
     * @generated
     */
    @IpsAllowedValues("bezeichnung")
    public static final ValueSet<String> MAX_ALLOWED_VALUES_FOR_BEZEICHNUNG = new UnrestrictedValueSet<>(true);
    /**
     * Der Vorgabewert des Attributs bezeichnung.
     *
     * @generated
     */
    @IpsDefaultValue("bezeichnung")
    public static final String DEFAULT_VALUE_FOR_BEZEICHNUNG = null;
    /**
     * Membervariable für die Produkteigenschaft Bezeichnung.
     *
     * @generated
     */
    private String bezeichnung = DEFAULT_VALUE_FOR_BEZEICHNUNG;

    /**
     * Der Name der Property von der Tabelle tariftabelle.
     *
     * @generated
     */
    public static final String TABLE_TARIFTABELLE = "tariftabelle";
    /**
     * Membervariable fuer die Tabelle tariftabelle.
     *
     * @generated
     */
    private String tariftabelleName = null;

    /**
     * Erzeugt eine neue Instanz von HausratGrunddeckungstyp.
     *
     * @generated
     */
    @IpsGenerated
    public HausratGrunddeckungstyp(IRuntimeRepository repository, String id, String kindId, String versionId) {
        super(repository, id, kindId, versionId);
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public boolean isChangingOverTime() {
        return false;
    }

    /**
     * Gibt den Wert der Eigenschaft bezeichnung zurück.
     *
     * @generated
     */
    @IpsAttribute(name = "bezeichnung", kind = AttributeKind.CONSTANT, valueSetKind = ValueSetKind.AllValues)
    @IpsGenerated
    public String getBezeichnung() {
        return bezeichnung;
    }

    /**
     * Setzt den Wert der Eigenschaft bezeichnung.
     *
     * @generated
     */
    @IpsAttributeSetter("bezeichnung")
    @IpsGenerated
    public void setBezeichnung(String newValue) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        setBezeichnungInternal(newValue);
    }

    /**
     * Setzt den Wert der Eigenschaft bezeichnung.
     *
     * @generated
     */
    @IpsGenerated
    protected final void setBezeichnungInternal(String newValue) {
        this.bezeichnung = newValue;
    }

    /**
     * Gibt den Namen der als tariftabelle verwendeten Tabelle zurueck.
     *
     * @generated
     */
    @IpsGenerated
    public String getTariftabelleName() {
        return tariftabelleName;
    }

    /**
     * Gibt die als tariftabelle verwendete Tabelle zurueck.
     *
     * @generated
     */
    @IpsTableUsage(name = "tariftabelle", required = true, tableClasses = TariftabelleHausrat.class)
    @IpsGenerated
    public TariftabelleHausrat getTariftabelle() {
        if (tariftabelleName == null) {
            return null;
        }
        return (TariftabelleHausrat)getRepository().getTable(tariftabelleName);
    }

    /**
     * Setzt den Namen der als TariftabelleName verwendeten Tabelle.
     *
     * @generated
     */
    @IpsGenerated
    public void setTariftabelleName(String tableName) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        this.tariftabelleName = tableName;
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    protected void doInitPropertiesFromXml(Map<String, Element> configMap) {
        super.doInitPropertiesFromXml(configMap);
        doInitBezeichnung(configMap);
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitBezeichnung(Map<String, Element> configMap) {
        Element configElement = configMap.get(PROPERTY_BEZEICHNUNG);
        if (configElement != null) {
            String value = ValueToXmlHelper.getValueFromElement(configElement, ValueToXmlHelper.XML_TAG_VALUE);
            this.bezeichnung = value;
        }
    }

    /**
     * @generated
     */
    @Override
    @IpsGenerated
    protected void doInitTableUsagesFromXml(Map<String, Element> tableUsageMap) {
        super.doInitTableUsagesFromXml(tableUsageMap);
        doInitTariftabelle(tableUsageMap);
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitTariftabelle(Map<String, Element> tableUsageMap) {
        Element element = tableUsageMap.get(TABLE_TARIFTABELLE);
        if (element != null) {
            tariftabelleName = ValueToXmlHelper.getValueFromElement(element,
                    ValueToXmlHelper.XML_TAG_TABLE_CONTENT_NAME);
        }
    }

    /**
     * Erzeugt eine neue Instanz von HausratGrunddeckung, die durch diesen Produktbaustein
     * konfiguriert wird.
     *
     * @generated
     */
    @IpsGenerated
    public HausratGrunddeckung createHausratGrunddeckung() {
        HausratGrunddeckung policy = new HausratGrunddeckung(this);
        policy.initialize();
        return policy;
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public HausratGrunddeckung createPolicyComponent() {
        return createHausratGrunddeckung();
    }

    /**
     * Erzeugt ein neues HausratGrunddeckungstypBuilder um dieses Produkt zu bearbeiten.
     *
     * @generated
     */
    @IpsGenerated
    public HausratGrunddeckungstypBuilder modify() {
        return HausratGrunddeckungstypBuilder.from(this, (IModifiableRuntimeRepository)this.getRepository());
    }

    /**
     * Erzeugt eine neue Instanz von HausratGrunddeckungstyp mit einem
     * {@link IModifiableRuntimeRepository}, ID, kindID und versionID. Das Wirksamkeitsdatum der
     * neuen Instanz wird auf 1900/1/1 gesetzt.
     *
     * @generated
     */
    @IpsGenerated
    public static HausratGrunddeckungstypBuilder builder(IModifiableRuntimeRepository runtimeRepository,
            String id,
            String kindId,
            String versionId) {
        HausratGrunddeckungstyp product = new HausratGrunddeckungstyp(runtimeRepository, id, kindId, versionId);
        product.setValidFrom(new DateTime(1900, 1, 1));
        runtimeRepository.putProductComponent(product);

        return new HausratGrunddeckungstypBuilder(product, runtimeRepository);
    }

    /**
     * Erzeugt eine neue Instanz von HausratGrunddeckungstyp mit einem
     * {@link IModifiableRuntimeRepository}, ID, kindID und versionID.
     *
     * @generated
     */
    @IpsGenerated
    public static HausratGrunddeckungstypBuilder builder(IModifiableRuntimeRepository runtimeRepository,
            String id,
            String kindId,
            String versionId,
            DateTime validFrom) {
        HausratGrunddeckungstyp product = new HausratGrunddeckungstyp(runtimeRepository, id, kindId, versionId);
        product.setValidFrom(validFrom);
        runtimeRepository.putProductComponent(product);

        return new HausratGrunddeckungstypBuilder(product, runtimeRepository);
    }

    /**
     * Erzeugt eine neue Instanz von HausratGrunddeckungstyp mit dem ID von einem existierenden
     * Produktbaustein.
     *
     * @generated
     */
    @IpsGenerated
    public static HausratGrunddeckungstypBuilder builder(IModifiableRuntimeRepository runtimeRepository,
            String prodCmptId) {
        HausratGrunddeckungstyp product = (HausratGrunddeckungstyp)runtimeRepository.getProductComponent(prodCmptId);

        if (product == null) {
            throw new RuntimeException("Keinen Produktbaustein mit der gegebenden ID gefunden!");
        } else {
            return HausratGrunddeckungstypBuilder.from(product, runtimeRepository);
        }
    }
}
