package org.faktorips.tutorial.model.test;

import java.util.Map;

import javax.xml.parsers.ParserConfigurationException;

import org.faktorips.runtime.DefaultObjectReferenceStore;
import org.faktorips.runtime.DefaultReferenceResolver;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IObjectReferenceStore;
import org.faktorips.runtime.annotation.IpsGenerated;
import org.faktorips.runtime.internal.XmlCallback;
import org.faktorips.runtime.internal.XmlUtil;
import org.faktorips.runtime.test.IpsTestCase2;
import org.faktorips.runtime.test.IpsTestResult;
import org.faktorips.tutorial.model.home.HomeContract;
import org.w3c.dom.Element;

/**
 * Instances of this class are business test cases. Testing of business logic is done by means of
 * the method executeAsserts(). The data for the test cases are provided by the FaktorIPS-Testcases
 * which are associated with the test case type upon which this class is generated.
 *
 * @generated
 */
public class RatingDistrictTest extends IpsTestCase2 {

    /**
     * @generated
     */
    public static final String TESTATTR_HOME_CONTRACT_EXPECTED_DISTRICT = "expectedDistrict";
    /**
     * @generated
     */
    private HomeContract inputHomeContract;
    /**
     * @generated
     */
    private HomeContract expectedHomeContract;

    /**
     * Creates a new test case.
     * 
     * @restrainedmodifiable
     */
    @IpsGenerated
    public RatingDistrictTest(String qualifiedName) throws ParserConfigurationException {
        super(qualifiedName);
        // begin-user-code
        // end-user-code
    }

    /**
     * Executes the business logic under test.
     *
     * @restrainedmodifiable
     */
    @Override
    @IpsGenerated
    public void executeBusinessLogic() {
        // begin-user-code
        // nothing to do (the logic to be tested is run by calling the getter)
        // end-user-code
    }

    /**
     * Executes the asserts that compare actual with expected result.
     * <p>
     * Asserts are programmed as in JUnit via calling assert(..) methods. E.g.
     * assert(expectedPolicy.getPremium(), inputPolicy.getPremium(), result);
     * 
     * To identify the test object, the name of the test object and the name of the attribute could
     * be specified, thus if the test case is running as Faktor-Ips test case then failures are
     * marked in the test case editor on the corresponding edit field. The name of the test object
     * and the name of the test attribute must be the same as specified in the test case type. If
     * the test object is a child object then the complete path to the object must be given, the
     * path elements must be separated by ".". If the test contains several instances with the same
     * name then an index (starting with 0) must be added to the testObject string separated by "#".
     * E.g. assertEquals(expectedPolicy.getPremium(), inputPolicy.getPremium(), result,
     * "RootObject#0.Policy#0", "premium");
     *
     * @restrainedmodifiable
     */
    @Override
    @IpsGenerated

    /**
     */
    public void executeAsserts(IpsTestResult result) {
        // begin-user-code
        String expectedDistrict = (String)getExtensionAttributeValue(
                expectedHomeContract, TESTATTR_HOME_CONTRACT_EXPECTED_DISTRICT);
        String computedDistrict = inputHomeContract.getRatingDistrict();
        assertEquals(expectedDistrict, computedDistrict, result,
                "HomeContract#0", TESTATTR_HOME_CONTRACT_EXPECTED_DISTRICT);
        // end-user-code
    }

    /**
     * Initializes the test case's input with the data from the xml.
     *
     * @restrainedmodifiable
     */
    @Override
    @IpsGenerated

    /**
     */
    public void initInputFromXml(Element element) {
        // begin-user-code
        // end-user-code
        IObjectReferenceStore objectReferenceStore = new DefaultObjectReferenceStore();
        Element childElement = null;
        HomeContractXmlCallback homeContractXmlCallback = new HomeContractXmlCallback(
                true);
        childElement = XmlUtil.getFirstElement(element, "HomeContract");
        if (childElement != null) {
            try {
                String className = childElement.getAttribute("class");
                inputHomeContract = (HomeContract)Class.forName(className, true, HomeContract.class.getClassLoader())
                        .getConstructor().newInstance();
                inputHomeContract.initFromXml(childElement, true, getRepository(), objectReferenceStore,
                        homeContractXmlCallback);
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            new DefaultReferenceResolver().resolve(objectReferenceStore);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Initializes the test case's expected result with the data from the xml.
     *
     * @restrainedmodifiable
     */
    @Override
    @IpsGenerated

    /**
     */
    public void initExpectedResultFromXml(Element element) {
        // begin-user-code
        // end-user-code
        IObjectReferenceStore objectReferenceStore = new DefaultObjectReferenceStore();
        Element childElement = null;
        HomeContractXmlCallback homeContractXmlCallback = new HomeContractXmlCallback(
                false);
        childElement = XmlUtil.getFirstElement(element, "HomeContract");
        if (childElement != null) {
            try {
                String className = childElement.getAttribute("class");
                expectedHomeContract = (HomeContract)Class.forName(className, true, HomeContract.class.getClassLoader())
                        .getConstructor().newInstance();
                expectedHomeContract.initFromXml(childElement, true, getRepository(), objectReferenceStore,
                        homeContractXmlCallback);
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            new DefaultReferenceResolver().resolve(objectReferenceStore);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * XMLCallback class for the test parameter HomeContract.
     *
     * @generated
     */
    private class HomeContractXmlCallback implements XmlCallback {
        /**
         * Indicates if the class is used for the input (<code>true</code>) or for the expected
         * result test content (<code>false</code>)
         *
         * @generated
         */
        private boolean input;

        /**
         * Creates a new XMLCallback class for the test parameter HomeContract.
         *
         * @generated
         */
        @IpsGenerated
        public HomeContractXmlCallback(boolean input) {
            this.input = input;
        }

        /**
         * {@inheritDoc}
         *
         * @generated
         */
        @Override
        @IpsGenerated
        public void initProperties(String pathFromAggregateRoot,
                IModelObject modelObject,
                Map<String, String> propMap) {
            if (pathFromAggregateRoot.equals("/HomeContract")) {
                String value = null;
                if (!input) {
                    value = propMap.get(TESTATTR_HOME_CONTRACT_EXPECTED_DISTRICT);
                    addExtensionAttribute(modelObject, TESTATTR_HOME_CONTRACT_EXPECTED_DISTRICT, value);
                }
            }
        }

    }

}
