package org.faktorips.tutorial.model.home;

import org.faktorips.runtime.model.table.TableStructureKind;
import org.faktorips.runtime.model.annotation.IpsTableStructure;
import org.faktorips.runtime.model.annotation.IpsDocumented;
import org.faktorips.runtime.internal.Table;
import org.faktorips.runtime.internal.tableindex.UniqueResultStructure;
import org.faktorips.runtime.internal.tableindex.TwoColumnRangeStructure;
import java.util.ArrayList;
import java.util.List;
import org.faktorips.runtime.IRuntimeRepository;
import java.util.NoSuchElementException;
import org.faktorips.runtime.annotation.IpsGenerated;

/**
 * This class represents a read-only in memory table. Data can be accessed by the find-methods of
 * this table.
 *
 * @since 1.0
 *
 * @generated
 */
@IpsTableStructure(name = "home.RatingDistrictTable", type = TableStructureKind.SINGLE_CONTENT, columns = {
        "zipcodeFrom", "zipcodeTo", "ratingDistrict" })
@IpsDocumented(bundleName = "org.faktorips.tutorial.model.model-label-and-descriptions", defaultLocale = "en")
public final class RatingDistrictTable extends Table<RatingDistrictTableRow> {

    /**
     * Member variable for key to table row mapping.
     *
     * @since 1.0
     *
     * @generated
     */
    private TwoColumnRangeStructure<String, UniqueResultStructure<RatingDistrictTableRow>, RatingDistrictTableRow> key0SearchStructure;

    /**
     * Creates an empty table.
     *
     * @generated
     */
    @IpsGenerated
    public RatingDistrictTable() {
        super();
        rows = new ArrayList<>();
        init();
    }

    /**
     * Creates a new table based on the indicated rows. The given row list is copied, so modifying
     * it afterwards does not change the created table. This constructor can be used in unit tests
     * to define arbitrary table contents.
     *
     * @generated
     */
    @IpsGenerated
    public RatingDistrictTable(List<RatingDistrictTableRow> content) {
        super();
        rows = new ArrayList<>(content);
        init();
    }

    /**
     * Creates a new table based on the indicated rows. The given row list is copied, so modifying
     * it afterwards does not change the created table. This constructor can be used in unit tests
     * or with modifiable repositories to define arbitrary table contents.
     *
     * @param qualifiedTableName the name of this table instance as referenced by the
     *            {@link IRuntimeRepository}
     *
     * @generated
     */
    @IpsGenerated
    public RatingDistrictTable(List<RatingDistrictTableRow> content, String qualifiedTableName) {
        super(qualifiedTableName);
        rows = new ArrayList<>(content);
        init();
    }

    /**
     * Adds a new table row during the initialization phase.
     *
     * @generated
     */
    @Override
    @IpsGenerated
    protected void addRow(List<String> values, IRuntimeRepository productRepository) {
        String columnValue = values.get(0);
        String zipcodeFrom = columnValue;
        columnValue = values.get(1);
        String zipcodeTo = columnValue;
        columnValue = values.get(2);
        String ratingDistrict = columnValue;
        rows.add(new RatingDistrictTableRow(zipcodeFrom, zipcodeTo, ratingDistrict));
    }

    /**
     * Initializes the maps that are used by the finder methods of this table. This method is called
     * during the initialization phase.
     *
     * @generated
     */
    @Override
    @IpsGenerated
    protected final void initKeyMaps() {
        key0SearchStructure = TwoColumnRangeStructure
                .<String, UniqueResultStructure<RatingDistrictTableRow>, RatingDistrictTableRow> create();
        for (RatingDistrictTableRow row : rows) {
            key0SearchStructure.put(
                    row.getZipcodeFrom(),
                    row.getZipcodeTo(),
                    UniqueResultStructure.createWith(row));
        }
    }

    /**
     * Returns an instance of this table class.
     *
     * @generated
     */
    @IpsGenerated
    public static final RatingDistrictTable getInstance(IRuntimeRepository repository) {
        return repository.getTable(RatingDistrictTable.class);
    }

    /**
     * Returns an instance of this table class.
     *
     * @generated
     */
    @IpsGenerated
    public static final RatingDistrictTable getInstance(IRuntimeRepository repository, String qualifiedTableName) {
        return (RatingDistrictTable)repository.getTable(qualifiedTableName);
    }

    /**
     * Searches the content of this table for an entry that fits the specified parameters and
     * returns the according row object. If no entry could be found, null is returned.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public RatingDistrictTableRow findRow(String zipcode) {
        return key0SearchStructure
                .get(zipcode)
                .getUnique(null);
    }

    /**
     * Searches the content of this table for an entry that fits the specified parameters and
     * returns the according row object. If no entry could be found, a 'null' row is returned.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public RatingDistrictTableRow findRowNullRowReturnedForEmptyResult(String zipcode) {
        return key0SearchStructure
                .get(zipcode)
                .getUnique(RatingDistrictTableRow.NULL_ROW);
    }

    /**
     * Searches the content of this table for an entry that fits the specified parameters and
     * returns the according row object. If no entry could be found, an exception will be thrown.
     *
     * @return The row that fits the specified parameters.
     * @throws IllegalArgumentException If no row could be found.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public RatingDistrictTableRow findExistingRow(String zipcode) {
        try {
            return key0SearchStructure
                    .get(zipcode)
                    .getUnique();
        } catch (NoSuchElementException e) {
            throw new IllegalArgumentException("No row could be found in table " + getName()
                    + " for the following search parameters: zipcode = " + zipcode);
        }
    }

}
