package org.faktorips.tutorial.model.home;

import org.faktorips.runtime.model.table.TableStructureKind;
import org.faktorips.runtime.model.annotation.IpsTableStructure;
import org.faktorips.runtime.model.annotation.IpsDocumented;
import org.faktorips.runtime.internal.Table;
import org.faktorips.runtime.internal.tableindex.UniqueResultStructure;
import org.faktorips.runtime.internal.tableindex.KeyStructure;
import java.util.ArrayList;
import java.util.List;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.values.Decimal;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.faktorips.runtime.annotation.IpsGenerated;

/**
 * This class represents a read-only in memory table. Data can be accessed by the find-methods of
 * this table.
 *
 * @since 1.0
 *
 * @generated
 */
@IpsTableStructure(name = "home.RateTableHome", type = TableStructureKind.MULTIPLE_CONTENTS, columns = {
        "ratingDistrict", "premiumRate" })
@IpsDocumented(bundleName = "org.faktorips.tutorial.model.model-label-and-descriptions", defaultLocale = "en")
public final class RateTableHome extends Table<RateTableHomeRow> {

    /**
     * Member variable for key to table row mapping.
     *
     * @since 1.0
     *
     * @generated
     */
    private KeyStructure<Index0, UniqueResultStructure<RateTableHomeRow>, RateTableHomeRow> key0SearchStructure;

    /**
     * Creates an empty table.
     *
     * @generated
     */
    @IpsGenerated
    public RateTableHome() {
        super();
        rows = new ArrayList<>();
        init();
    }

    /**
     * Creates a new table based on the indicated rows. The given row list is copied, so modifying
     * it afterwards does not change the created table. This constructor can be used in unit tests
     * to define arbitrary table contents.
     *
     * @generated
     */
    @IpsGenerated
    public RateTableHome(List<RateTableHomeRow> content) {
        super();
        rows = new ArrayList<>(content);
        init();
    }

    /**
     * Creates a new table based on the indicated rows. The given row list is copied, so modifying
     * it afterwards does not change the created table. This constructor can be used in unit tests
     * or with modifiable repositories to define arbitrary table contents.
     *
     * @param qualifiedTableName the name of this table instance as referenced by the
     *            {@link IRuntimeRepository}
     *
     * @generated
     */
    @IpsGenerated
    public RateTableHome(List<RateTableHomeRow> content, String qualifiedTableName) {
        super(qualifiedTableName);
        rows = new ArrayList<>(content);
        init();
    }

    /**
     * Adds a new table row during the initialization phase.
     *
     * @generated
     */
    @Override
    @IpsGenerated
    protected void addRow(List<String> values, IRuntimeRepository productRepository) {
        String columnValue = values.get(0);
        String ratingDistrict = columnValue;
        columnValue = values.get(1);
        Decimal premiumRate = Decimal.valueOf(columnValue);
        rows.add(new RateTableHomeRow(ratingDistrict, premiumRate));
    }

    /**
     * Initializes the maps that are used by the finder methods of this table. This method is called
     * during the initialization phase.
     *
     * @generated
     */
    @Override
    @IpsGenerated
    protected final void initKeyMaps() {
        key0SearchStructure = KeyStructure.<Index0, UniqueResultStructure<RateTableHomeRow>, RateTableHomeRow> create();
        for (RateTableHomeRow row : rows) {
            key0SearchStructure.put(
                    new Index0(
                            row.getRatingDistrict()),
                    UniqueResultStructure.createWith(row));
        }
    }

    /**
     * Returns an instance of this table class.
     *
     * @generated
     */
    @IpsGenerated
    public static final RateTableHome getInstance(IRuntimeRepository repository, String qualifiedTableName) {
        return (RateTableHome)repository.getTable(qualifiedTableName);
    }

    /**
     * Searches the content of this table for an entry that fits the specified parameters and
     * returns the according row object. If no entry could be found, null is returned.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public RateTableHomeRow findRow(String ratingDistrict) {
        return key0SearchStructure
                .get(new Index0(ratingDistrict))
                .getUnique(null);
    }

    /**
     * Searches the content of this table for an entry that fits the specified parameters and
     * returns the according row object. If no entry could be found, a 'null' row is returned.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public RateTableHomeRow findRowNullRowReturnedForEmptyResult(String ratingDistrict) {
        return key0SearchStructure
                .get(new Index0(ratingDistrict))
                .getUnique(RateTableHomeRow.NULL_ROW);
    }

    /**
     * Searches the content of this table for an entry that fits the specified parameters and
     * returns the according row object. If no entry could be found, an exception will be thrown.
     *
     * @return The row that fits the specified parameters.
     * @throws IllegalArgumentException If no row could be found.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public RateTableHomeRow findExistingRow(String ratingDistrict) {
        try {
            return key0SearchStructure
                    .get(new Index0(ratingDistrict))
                    .getUnique();
        } catch (NoSuchElementException e) {
            throw new IllegalArgumentException("No row could be found in table " + getName()
                    + " for the following search parameters: ratingDistrict = " + ratingDistrict);
        }
    }

    /**
     * Instances of this class are used as a hash key. The key specific map of this table
     * representation is set up with instances of this class.
     *
     * @generated
     */
    private static final class Index0 {

        /**
         * @generated
         */
        private final String ratingDistrict;

        /**
         * Cached hashcode.
         *
         * @generated
         */
        private final int hashCode;

        /**
         * Creates a new key instance with the specified parameters.
         *
         * @generated
         */
        @IpsGenerated
        private Index0(String ratingDistrict) {
            this.ratingDistrict = ratingDistrict;
            hashCode = calculateHashCode();
        }

        /**
         * @generated
         */
        @IpsGenerated
        private int calculateHashCode() {
            int result = 17;
            result = 37 * result + ((ratingDistrict == null) ? 0 : ratingDistrict.hashCode());
            return result;
        }

        /**
         * Overrides the super class method and compares each instance variable for equality.
         *
         * @generated
         */
        @Override
        @IpsGenerated
        public boolean equals(Object o) {
            if (o instanceof Index0) {
                Index0 other = (Index0)o;
                return Objects.equals(ratingDistrict, other.ratingDistrict);
            }
            return false;
        }

        /**
         * Overrides the super class method and creates a hash code based on the values of the
         * instance variables.
         *
         * @generated
         */
        @Override
        @IpsGenerated
        public int hashCode() {
            return hashCode;
        }
    }

}
