package org.faktorips.tutorial.model.home;

import org.faktorips.runtime.IModifiableRuntimeRepository;
import org.faktorips.valueset.ValueSet;
import org.faktorips.runtime.CardinalityRange;
import org.faktorips.values.Money;
import org.faktorips.runtime.annotation.IpsGenerated;

/**
 * Implementation of HomeProductBuilder. A HomeProductBuilder provides all functionalities that are
 * needed to edit a HomeProduct. Note that this is only for testing purpose. All instances of
 * product have to be created in a new {@link IModifiableRuntimeRepository} as Product Component in
 * the runtime repository can not be edited.
 *
 * @since 1.0
 *
 * @generated
 */
public class HomeProductBuilder {
    /**
     * @generated
     */
    private final IModifiableRuntimeRepository runtimeRepository;

    /**
     * @generated
     */
    private final HomeProduct homeProduct;

    /**
     * Generates a new instance of HomeProductBuilder with a given product. The product must exist
     * in the given {@link IModifiableRuntimeRepository} that is not allowed to be null.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    protected HomeProductBuilder(HomeProduct product, IModifiableRuntimeRepository runtimeRepository) {
        if (product == null || runtimeRepository == null) {
            throw new RuntimeException("Product and repository can not be null!");
        } else {
            runtimeRepository.getExistingProductComponent(product.getId());

            this.runtimeRepository = runtimeRepository;
            this.homeProduct = product;
        }
    }

    /**
     * Sets the value of attribute productname.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeProductBuilder productname(String productname) {
        homeProduct.setProductname(productname);
        return this;
    }

    /**
     * Sets the value of attribute proposedSumInsuredPerSqm.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeProductBuilder proposedSumInsuredPerSqm(Money proposedSumInsuredPerSqm) {
        homeProduct.setProposedSumInsuredPerSqm(proposedSumInsuredPerSqm);
        return this;
    }

    /**
     * Sets the default value for paymentMode.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeProductBuilder paymentModeDefault(Integer paymentMode) {
        homeProduct.setDefaultValuePaymentMode(paymentMode);
        return this;
    }

    /**
     * Sets the set of allowed values for the property paymentMode.
     *
     * @throws ClassCastException if the type of value set does not match the property's
     *             configuration.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeProductBuilder paymentModeAllowedValues(ValueSet<Integer> paymentMode) {
        homeProduct.setAllowedValuesForPaymentMode(paymentMode);
        return this;
    }

    /**
     * Sets the default value for livingSpace.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeProductBuilder livingSpaceDefault(Integer livingSpace) {
        homeProduct.setDefaultValueLivingSpace(livingSpace);
        return this;
    }

    /**
     * Sets the set of allowed values for the property livingSpace.
     *
     * @throws ClassCastException if the type of value set does not match the property's
     *             configuration.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeProductBuilder livingSpaceAllowedValues(ValueSet<Integer> livingSpace) {
        homeProduct.setAllowedValuesForLivingSpace(livingSpace);
        return this;
    }

    /**
     * Sets the default value for sumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeProductBuilder sumInsuredDefault(Money sumInsured) {
        homeProduct.setDefaultValueSumInsured(sumInsured);
        return this;
    }

    /**
     * Sets the set of allowed values for the property sumInsured.
     *
     * @throws ClassCastException if the type of value set does not match the property's
     *             configuration.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeProductBuilder sumInsuredAllowedValues(ValueSet<Money> sumInsured) {
        homeProduct.setAllowedValuesForSumInsured(sumInsured);
        return this;
    }

    /**
     * @return {@link IModifiableRuntimeRepository} that is saved.
     *
     * @generated
     */
    @IpsGenerated
    public IModifiableRuntimeRepository getRepository() {
        return this.runtimeRepository;
    }

    /**
     * @return instance of HomeProduct that is built.
     *
     * @generated
     */
    @IpsGenerated
    public HomeProduct getResult() {
        return homeProduct;
    }

    /**
     * Interne Methode
     *
     * @generated
     */
    @IpsGenerated
    public static Class<?> getProductClass() {
        return HomeProduct.class;
    }

    /**
     * Creates a new HomeProductBuilder with a given HomeProduct and a runtime repository.
     *
     * @generated
     */
    @IpsGenerated
    public static HomeProductBuilder from(HomeProduct product, IModifiableRuntimeRepository runtimeRepository) {
        return new HomeProductBuilder(product, runtimeRepository);
    }

    /**
     * Returns an {@link AssociationBuilder} to build a target object and add directly to a
     * specified association. With the {@link AssociationBuilder} you get the builder of the target
     * object for further processing. Use the method {@link #add()} if you want to create multiple
     * target objects and always return to this builder instead of the target builder.
     *
     * @see #add()
     *
     * @generated
     */
    @IpsGenerated
    public AssociationBuilder associate() {
        return new AssociationBuilder(this);
    }

    /**
     * Returns an {@link AddAssociationBuilder} to build a target object and add directly to a
     * specified association. With the {@link AddAssociationBuilder} you always could return to this
     * builder for further processing. Use the method {@link #associate()} if you want to have the
     * builder of the target object.
     *
     * @see #associate()
     *
     * @generated
     */
    @IpsGenerated
    public AddAssociationBuilder add() {
        return new AddAssociationBuilder(this);
    }

    /**
     * This class wraps setter methods for associations. Methods in this class returns a builder for
     * the target class.
     *
     * @generated
     */
    public static class AssociationBuilder {

        /**
         * @generated
         */
        private HomeProductBuilder productBuilder;

        /**
         * @generated
         */
        @IpsGenerated
        protected AssociationBuilder(HomeProductBuilder productBuilder) {
            this.productBuilder = productBuilder;
        }

        /**
         * Gets a instance of a subclass of HomeExtraCoverageType with the ID of the product
         * component and sets it as HomeExtraCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public <T extends HomeExtraCoverageTypeBuilder> T homeExtraCoverageType(T targetBuilder) {
            getResult()
                    .addHomeExtraCoverageType(targetBuilder.getResult());
            return targetBuilder;
        }

        /**
         * Gets a instance of a subclass of HomeExtraCoverageType with the ID of the product
         * component and sets it as HomeExtraCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public <T extends HomeExtraCoverageTypeBuilder> T homeExtraCoverageType(T targetBuilder,
                CardinalityRange cardinality) {
            getResult()
                    .addHomeExtraCoverageType(targetBuilder.getResult(), cardinality);
            return targetBuilder;
        }

        /**
         * Gets a instance of HomeExtraCoverageType with the ID of the product component and sets it
         * as HomeExtraCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public HomeExtraCoverageTypeBuilder homeExtraCoverageType(String productCmptId) {
            HomeExtraCoverageTypeBuilder targetBuilder = HomeExtraCoverageType.builder(getRepository(), productCmptId);
            getResult()
                    .addHomeExtraCoverageType(targetBuilder.getResult());
            return targetBuilder;
        }

        /**
         * Generates a new Instance of HomeExtraCoverageType with the IDs and sets it as
         * HomeExtraCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public HomeExtraCoverageTypeBuilder homeExtraCoverageType(String id, String kindId, String versionId) {
            HomeExtraCoverageTypeBuilder targetBuilder = HomeExtraCoverageType.builder(getRepository(), id, kindId,
                    versionId);
            getResult()
                    .addHomeExtraCoverageType(targetBuilder.getResult());
            return targetBuilder;
        }

        /**
         * Gets a instance of HomeExtraCoverageType with the ID of the product component and sets it
         * as HomeExtraCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public HomeExtraCoverageTypeBuilder homeExtraCoverageType(String productCmptId, CardinalityRange cardinality) {
            HomeExtraCoverageTypeBuilder targetBuilder = HomeExtraCoverageType.builder(getRepository(), productCmptId);
            getResult()
                    .addHomeExtraCoverageType(targetBuilder.getResult(), cardinality);
            return targetBuilder;
        }

        /**
         * Generates a new Instance of HomeExtraCoverageType with the IDs and sets it as
         * HomeExtraCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public HomeExtraCoverageTypeBuilder homeExtraCoverageType(String id,
                String kindId,
                String versionId,
                CardinalityRange cardinality) {
            HomeExtraCoverageTypeBuilder targetBuilder = HomeExtraCoverageType.builder(getRepository(), id, kindId,
                    versionId);
            getResult()
                    .addHomeExtraCoverageType(targetBuilder.getResult(), cardinality);
            return targetBuilder;
        }

        /**
         * Gets a instance of a subclass of HomeBaseCoverageType with the ID of the product
         * component and sets it as HomeBaseCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public <T extends HomeBaseCoverageTypeBuilder> T homeBaseCoverageType(T targetBuilder) {
            getResult()
                    .setHomeBaseCoverageType(targetBuilder.getResult());
            return targetBuilder;
        }

        /**
         * Gets a instance of a subclass of HomeBaseCoverageType with the ID of the product
         * component and sets it as HomeBaseCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public <T extends HomeBaseCoverageTypeBuilder> T homeBaseCoverageType(T targetBuilder,
                CardinalityRange cardinality) {
            getResult()
                    .setHomeBaseCoverageType(targetBuilder.getResult(), cardinality);
            return targetBuilder;
        }

        /**
         * Gets a instance of HomeBaseCoverageType with the ID of the product component and sets it
         * as HomeBaseCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public HomeBaseCoverageTypeBuilder homeBaseCoverageType(String productCmptId) {
            HomeBaseCoverageTypeBuilder targetBuilder = HomeBaseCoverageType.builder(getRepository(), productCmptId);
            getResult()
                    .setHomeBaseCoverageType(targetBuilder.getResult());
            return targetBuilder;
        }

        /**
         * Generates a new Instance of HomeBaseCoverageType with the IDs and sets it as
         * HomeBaseCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public HomeBaseCoverageTypeBuilder homeBaseCoverageType(String id, String kindId, String versionId) {
            HomeBaseCoverageTypeBuilder targetBuilder = HomeBaseCoverageType.builder(getRepository(), id, kindId,
                    versionId);
            getResult()
                    .setHomeBaseCoverageType(targetBuilder.getResult());
            return targetBuilder;
        }

        /**
         * Gets a instance of HomeBaseCoverageType with the ID of the product component and sets it
         * as HomeBaseCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public HomeBaseCoverageTypeBuilder homeBaseCoverageType(String productCmptId, CardinalityRange cardinality) {
            HomeBaseCoverageTypeBuilder targetBuilder = HomeBaseCoverageType.builder(getRepository(), productCmptId);
            getResult()
                    .setHomeBaseCoverageType(targetBuilder.getResult(), cardinality);
            return targetBuilder;
        }

        /**
         * Generates a new Instance of HomeBaseCoverageType with the IDs and sets it as
         * HomeBaseCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public HomeBaseCoverageTypeBuilder homeBaseCoverageType(String id,
                String kindId,
                String versionId,
                CardinalityRange cardinality) {
            HomeBaseCoverageTypeBuilder targetBuilder = HomeBaseCoverageType.builder(getRepository(), id, kindId,
                    versionId);
            getResult()
                    .setHomeBaseCoverageType(targetBuilder.getResult(), cardinality);
            return targetBuilder;
        }

        /**
         * @generated
         */
        @IpsGenerated
        protected HomeProduct getResult() {
            return productBuilder.getResult();
        }

        /**
         * @generated
         */
        @IpsGenerated
        protected IModifiableRuntimeRepository getRepository() {
            return productBuilder.getRepository();
        }
    }

    /**
     * This class wraps setter methods for associations. Methods in this class return the original
     * HomeProductBuilder.
     *
     * @generated
     */
    public static class AddAssociationBuilder {

        /**
         * @generated
         */
        private HomeProductBuilder productBuilder;

        /**
         * @generated
         */
        @IpsGenerated
        protected AddAssociationBuilder(HomeProductBuilder productBuilder) {
            this.productBuilder = productBuilder;
        }

        /**
         * Sets a existing instance of HomeExtraCoverageType as the target of the association
         * HomeExtraCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public HomeProductBuilder homeExtraCoverageType(HomeExtraCoverageType targetProduct) {
            getResult()
                    .addHomeExtraCoverageType(targetProduct);
            return done();
        }

        /**
         * Sets a existing instance of HomeExtraCoverageType as the target of the association
         * HomeExtraCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public HomeProductBuilder homeExtraCoverageType(HomeExtraCoverageType targetProduct,
                CardinalityRange cardinality) {
            getResult()
                    .addHomeExtraCoverageType(targetProduct, cardinality);
            return done();
        }

        /**
         * Gets a instance of a subclass of HomeExtraCoverageType with the ID of the product
         * component and sets it as HomeExtraCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public HomeProductBuilder homeExtraCoverageType(HomeExtraCoverageTypeBuilder targetBuilder) {
            getResult()
                    .addHomeExtraCoverageType(targetBuilder.getResult());
            return done();
        }

        /**
         * Gets a instance of a subclass of HomeExtraCoverageType with the ID of the product
         * component and sets it as HomeExtraCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public HomeProductBuilder homeExtraCoverageType(HomeExtraCoverageTypeBuilder targetBuilder,
                CardinalityRange cardinality) {
            getResult()
                    .addHomeExtraCoverageType(targetBuilder.getResult(), cardinality);
            return done();
        }

        /**
         * Gets a instance of HomeExtraCoverageType with the ID of the product component and sets it
         * as HomeExtraCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public HomeProductBuilder homeExtraCoverageType(String productCmptId) {
            HomeExtraCoverageTypeBuilder targetBuilder = HomeExtraCoverageType.builder(getRepository(), productCmptId);
            getResult()
                    .addHomeExtraCoverageType(targetBuilder.getResult());
            return done();
        }

        /**
         * Generates a new Instance of HomeExtraCoverageType with the IDs and sets it as
         * HomeExtraCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public HomeProductBuilder homeExtraCoverageType(String id, String kindId, String versionId) {
            HomeExtraCoverageTypeBuilder targetBuilder = HomeExtraCoverageType.builder(getRepository(), id, kindId,
                    versionId);
            getResult()
                    .addHomeExtraCoverageType(targetBuilder.getResult());
            return done();
        }

        /**
         * Gets a instance of HomeExtraCoverageType with the ID of the product component and sets it
         * as HomeExtraCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public HomeProductBuilder homeExtraCoverageType(String productCmptId, CardinalityRange cardinality) {
            HomeExtraCoverageTypeBuilder targetBuilder = HomeExtraCoverageType.builder(getRepository(), productCmptId);
            getResult()
                    .addHomeExtraCoverageType(targetBuilder.getResult(), cardinality);
            return done();
        }

        /**
         * Generates a new Instance of HomeExtraCoverageType with the IDs and sets it as
         * HomeExtraCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public HomeProductBuilder homeExtraCoverageType(String id,
                String kindId,
                String versionId,
                CardinalityRange cardinality) {
            HomeExtraCoverageTypeBuilder targetBuilder = HomeExtraCoverageType.builder(getRepository(), id, kindId,
                    versionId);
            getResult()
                    .addHomeExtraCoverageType(targetBuilder.getResult(), cardinality);
            return done();
        }

        /**
         * Sets a existing instance of HomeBaseCoverageType as the target of the association
         * HomeBaseCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public HomeProductBuilder homeBaseCoverageType(HomeBaseCoverageType targetProduct) {
            getResult()
                    .setHomeBaseCoverageType(targetProduct);
            return done();
        }

        /**
         * Sets a existing instance of HomeBaseCoverageType as the target of the association
         * HomeBaseCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public HomeProductBuilder homeBaseCoverageType(HomeBaseCoverageType targetProduct,
                CardinalityRange cardinality) {
            getResult()
                    .setHomeBaseCoverageType(targetProduct, cardinality);
            return done();
        }

        /**
         * Gets a instance of a subclass of HomeBaseCoverageType with the ID of the product
         * component and sets it as HomeBaseCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public HomeProductBuilder homeBaseCoverageType(HomeBaseCoverageTypeBuilder targetBuilder) {
            getResult()
                    .setHomeBaseCoverageType(targetBuilder.getResult());
            return done();
        }

        /**
         * Gets a instance of a subclass of HomeBaseCoverageType with the ID of the product
         * component and sets it as HomeBaseCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public HomeProductBuilder homeBaseCoverageType(HomeBaseCoverageTypeBuilder targetBuilder,
                CardinalityRange cardinality) {
            getResult()
                    .setHomeBaseCoverageType(targetBuilder.getResult(), cardinality);
            return done();
        }

        /**
         * Gets a instance of HomeBaseCoverageType with the ID of the product component and sets it
         * as HomeBaseCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public HomeProductBuilder homeBaseCoverageType(String productCmptId) {
            HomeBaseCoverageTypeBuilder targetBuilder = HomeBaseCoverageType.builder(getRepository(), productCmptId);
            getResult()
                    .setHomeBaseCoverageType(targetBuilder.getResult());
            return done();
        }

        /**
         * Generates a new Instance of HomeBaseCoverageType with the IDs and sets it as
         * HomeBaseCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public HomeProductBuilder homeBaseCoverageType(String id, String kindId, String versionId) {
            HomeBaseCoverageTypeBuilder targetBuilder = HomeBaseCoverageType.builder(getRepository(), id, kindId,
                    versionId);
            getResult()
                    .setHomeBaseCoverageType(targetBuilder.getResult());
            return done();
        }

        /**
         * Gets a instance of HomeBaseCoverageType with the ID of the product component and sets it
         * as HomeBaseCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public HomeProductBuilder homeBaseCoverageType(String productCmptId, CardinalityRange cardinality) {
            HomeBaseCoverageTypeBuilder targetBuilder = HomeBaseCoverageType.builder(getRepository(), productCmptId);
            getResult()
                    .setHomeBaseCoverageType(targetBuilder.getResult(), cardinality);
            return done();
        }

        /**
         * Generates a new Instance of HomeBaseCoverageType with the IDs and sets it as
         * HomeBaseCoverageType.
         *
         * @generated
         */
        @IpsGenerated
        public HomeProductBuilder homeBaseCoverageType(String id,
                String kindId,
                String versionId,
                CardinalityRange cardinality) {
            HomeBaseCoverageTypeBuilder targetBuilder = HomeBaseCoverageType.builder(getRepository(), id, kindId,
                    versionId);
            getResult()
                    .setHomeBaseCoverageType(targetBuilder.getResult(), cardinality);
            return done();
        }

        /**
         * @generated
         */
        @IpsGenerated
        protected HomeProductBuilder done() {
            return productBuilder;
        }

        /**
         * @generated
         */
        @IpsGenerated
        protected HomeProduct getResult() {
            return productBuilder.getResult();
        }

        /**
         * @generated
         */
        @IpsGenerated
        protected IModifiableRuntimeRepository getRepository() {
            return productBuilder.getRepository();
        }
    }

}
