package org.faktorips.tutorial.model.home;

import org.faktorips.runtime.model.annotation.IpsProductCmptType;
import org.faktorips.runtime.model.annotation.IpsAttributes;
import org.faktorips.runtime.model.annotation.IpsAssociations;
import org.faktorips.runtime.model.annotation.IpsConfigures;
import org.faktorips.runtime.model.annotation.IpsDocumented;
import org.faktorips.runtime.internal.ProductComponent;
import org.faktorips.valueset.OrderedValueSet;
import org.faktorips.valueset.IntegerRange;
import org.faktorips.values.Money;
import org.faktorips.valueset.MoneyRange;
import org.faktorips.runtime.IProductComponentLink;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.model.annotation.IpsAttribute;
import org.faktorips.runtime.model.type.AttributeKind;
import org.faktorips.runtime.model.type.ValueSetKind;
import org.faktorips.runtime.model.annotation.IpsAttributeSetter;
import org.faktorips.runtime.IllegalRepositoryModificationException;
import org.faktorips.runtime.model.annotation.IpsDefaultValue;
import org.faktorips.runtime.model.annotation.IpsDefaultValueSetter;
import org.faktorips.runtime.model.annotation.IpsAllowedValues;
import org.faktorips.runtime.model.annotation.IpsAllowedValuesSetter;
import org.faktorips.valueset.ValueSet;
import org.faktorips.valueset.UnrestrictedValueSet;
import org.faktorips.runtime.model.annotation.IpsAssociation;
import org.faktorips.runtime.model.type.AssociationKind;
import org.faktorips.runtime.model.annotation.IpsMatchingAssociation;
import org.faktorips.runtime.model.annotation.IpsAssociationAdder;
import org.faktorips.runtime.internal.ProductComponentLink;
import org.faktorips.runtime.CardinalityRange;
import org.faktorips.runtime.model.annotation.IpsAssociationLinks;
import org.w3c.dom.Element;
import java.util.Map;
import java.util.LinkedHashMap;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.EnumValues;
import java.util.List;
import java.util.ArrayList;
import org.faktorips.runtime.util.ProductComponentLinks;
import org.faktorips.runtime.model.annotation.IpsAssociationRemover;
import java.util.Collection;
import java.util.Collections;
import org.faktorips.runtime.internal.Range;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IModifiableRuntimeRepository;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.annotation.IpsGenerated;

/**
 * Implementation for HomeProduct.
 *
 * @since 1.0
 *
 * @generated
 */
@IpsProductCmptType(name = "home.HomeProduct")
@IpsAttributes({ "productname", "proposedSumInsuredPerSqm" })
@IpsAssociations({ "HomeBaseCoverageType", "HomeExtraCoverageType" })
@IpsConfigures(HomeContract.class)
@IpsDocumented(bundleName = "org.faktorips.tutorial.model.model-label-and-descriptions", defaultLocale = "en")
public class HomeProduct extends ProductComponent {

    /**
     * The name of the XML tag for the association homeBaseCoverageType.
     *
     * @since 1.0
     *
     * @generated
     */
    private static final String XML_TAG_HOME_BASE_COVERAGE_TYPE = "HomeBaseCoverageType";
    /**
     * The name of the XML tag for the association homeExtraCoverageTypes.
     *
     * @since 1.0
     *
     * @generated
     */
    private static final String XML_TAG_HOME_EXTRA_COVERAGE_TYPES = "HomeExtraCoverageType";
    /**
     * The name of the property productname.
     *
     * @since 1.0
     *
     * @generated
     */
    public static final String PROPERTY_PRODUCTNAME = "productname";
    /**
     * Max allowed values for property productname.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("productname")
    public static final ValueSet<String> MAX_ALLOWED_VALUES_FOR_PRODUCTNAME = new UnrestrictedValueSet<>(true);
    /**
     * The default value for productname.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsDefaultValue("productname")
    public static final String DEFAULT_VALUE_FOR_PRODUCTNAME = null;
    /**
     * The name of the property proposedSumInsuredPerSqm.
     *
     * @since 1.0
     *
     * @generated
     */
    public static final String PROPERTY_PROPOSEDSUMINSUREDPERSQM = "proposedSumInsuredPerSqm";
    /**
     * Max allowed values for property proposedSumInsuredPerSqm.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("proposedSumInsuredPerSqm")
    public static final ValueSet<Money> MAX_ALLOWED_VALUES_FOR_PROPOSED_SUM_INSURED_PER_SQM = new UnrestrictedValueSet<>(
            true);
    /**
     * The default value for proposedSumInsuredPerSqm.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsDefaultValue("proposedSumInsuredPerSqm")
    public static final Money DEFAULT_VALUE_FOR_PROPOSED_SUM_INSURED_PER_SQM = Money.NULL;
    /**
     * The product component property Productname.
     *
     * @since 1.0
     *
     * @generated
     */
    private String productname = DEFAULT_VALUE_FOR_PRODUCTNAME;

    /**
     * The product component property ProposedSumInsuredPerSqm.
     *
     * @since 1.0
     *
     * @generated
     */
    private Money proposedSumInsuredPerSqm = DEFAULT_VALUE_FOR_PROPOSED_SUM_INSURED_PER_SQM;
    /**
     * The default value for paymentMode.
     *
     * @since 1.0
     *
     * @generated
     */
    private Integer defaultValuePaymentMode = null;
    /**
     * Allowed set of values for property paymentMode.
     *
     * @since 1.0
     *
     * @generated
     */
    private OrderedValueSet<Integer> allowedValuesForPaymentMode = HomeContract.MAX_ALLOWED_VALUES_FOR_PAYMENT_MODE;

    /**
     * The default value for livingSpace.
     *
     * @since 1.0
     *
     * @generated
     */
    private Integer defaultValueLivingSpace = null;
    /**
     * Range of allowed values for property livingSpace.
     *
     * @since 1.0
     *
     * @generated
     */
    private ValueSet<Integer> rangeForLivingSpace = HomeContract.MAX_ALLOWED_RANGE_FOR_LIVING_SPACE;

    /**
     * The default value for sumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    private Money defaultValueSumInsured = Money.NULL;
    /**
     * Range of allowed values for property sumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    private ValueSet<Money> rangeForSumInsured = HomeContract.MAX_ALLOWED_RANGE_FOR_SUM_INSURED;

    /**
     * Member variable for the association HomeBaseCoverageType.
     *
     * @since 1.0
     *
     * @generated
     */
    private IProductComponentLink<HomeBaseCoverageType> homeBaseCoverageType = null;

    /**
     * Member variable for the association HomeExtraCoverageTypes.
     *
     * @since 1.0
     *
     * @generated
     */
    private Map<String, IProductComponentLink<HomeExtraCoverageType>> homeExtraCoverageTypes = new LinkedHashMap<>(0);

    /**
     * Creates a new HomeProduct.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeProduct(IRuntimeRepository repository, String id, String kindId, String versionId) {
        super(repository, id, kindId, versionId);
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public boolean isChangingOverTime() {
        return false;
    }

    /**
     * Returns the value of productname.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAttribute(name = "productname", kind = AttributeKind.CONSTANT, valueSetKind = ValueSetKind.AllValues)
    @IpsGenerated
    public String getProductname() {
        return productname;
    }

    /**
     * Sets the value of attribute productname.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAttributeSetter("productname")
    @IpsGenerated
    public void setProductname(String newValue) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        setProductnameInternal(newValue);
    }

    /**
     * Sets the value of attribute productname.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    protected final void setProductnameInternal(String newValue) {
        this.productname = newValue;
    }

    /**
     * Returns the value of proposedSumInsuredPerSqm.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAttribute(name = "proposedSumInsuredPerSqm", kind = AttributeKind.CONSTANT, valueSetKind = ValueSetKind.AllValues)
    @IpsGenerated
    public Money getProposedSumInsuredPerSqm() {
        return proposedSumInsuredPerSqm;
    }

    /**
     * Sets the value of attribute proposedSumInsuredPerSqm.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAttributeSetter("proposedSumInsuredPerSqm")
    @IpsGenerated
    public void setProposedSumInsuredPerSqm(Money newValue) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        setProposedSumInsuredPerSqmInternal(newValue);
    }

    /**
     * Sets the value of attribute proposedSumInsuredPerSqm.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    protected final void setProposedSumInsuredPerSqmInternal(Money newValue) {
        this.proposedSumInsuredPerSqm = newValue;
    }

    /**
     * Returns the default value for paymentMode.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsDefaultValue("paymentMode")
    @IpsGenerated
    public Integer getDefaultValuePaymentMode() {
        return defaultValuePaymentMode;
    }

    /**
     * Sets the default value for paymentMode.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsDefaultValueSetter("paymentMode")
    @IpsGenerated
    public void setDefaultValuePaymentMode(Integer defaultValuePaymentMode) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        this.defaultValuePaymentMode = defaultValuePaymentMode;
    }

    /**
     * Returns the set of allowed values for the property paymentMode.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("paymentMode")
    @IpsGenerated
    public ValueSet<Integer> getAllowedValuesForPaymentMode() {
        return allowedValuesForPaymentMode;
    }

    /**
     * Sets the set of allowed values for the property paymentMode.
     *
     * @throws ClassCastException if the type of value set does not match the property's
     *             configuration.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValuesSetter("paymentMode")
    @IpsGenerated
    public void setAllowedValuesForPaymentMode(ValueSet<Integer> allowedValuesForPaymentMode) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        this.allowedValuesForPaymentMode = (OrderedValueSet<Integer>)allowedValuesForPaymentMode;
    }

    /**
     * Returns the default value for livingSpace.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsDefaultValue("livingSpace")
    @IpsGenerated
    public Integer getDefaultValueLivingSpace() {
        return defaultValueLivingSpace;
    }

    /**
     * Sets the default value for livingSpace.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsDefaultValueSetter("livingSpace")
    @IpsGenerated
    public void setDefaultValueLivingSpace(Integer defaultValueLivingSpace) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        this.defaultValueLivingSpace = defaultValueLivingSpace;
    }

    /**
     * Returns the range of allowed values for the property livingSpace.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("livingSpace")
    @IpsGenerated
    public ValueSet<Integer> getAllowedValuesForLivingSpace() {
        return rangeForLivingSpace;
    }

    /**
     * Sets the set of allowed values for the property livingSpace.
     *
     * @throws ClassCastException if the type of value set does not match the property's
     *             configuration.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValuesSetter("livingSpace")
    @IpsGenerated
    public void setAllowedValuesForLivingSpace(ValueSet<Integer> rangeForLivingSpace) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        if (rangeForLivingSpace != null
                && !(rangeForLivingSpace.isRange() || rangeForLivingSpace instanceof OrderedValueSet)) {
            throw new java.lang.ClassCastException(
                    rangeForLivingSpace + " is neither a range nor an ordered value set");
        }
        this.rangeForLivingSpace = rangeForLivingSpace;
    }

    /**
     * Returns the default value for sumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsDefaultValue("sumInsured")
    @IpsGenerated
    public Money getDefaultValueSumInsured() {
        return defaultValueSumInsured;
    }

    /**
     * Sets the default value for sumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsDefaultValueSetter("sumInsured")
    @IpsGenerated
    public void setDefaultValueSumInsured(Money defaultValueSumInsured) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        this.defaultValueSumInsured = defaultValueSumInsured;
    }

    /**
     * Returns the range of allowed values for the property sumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("sumInsured")
    @IpsGenerated
    public ValueSet<Money> getAllowedValuesForSumInsured() {
        return rangeForSumInsured;
    }

    /**
     * Sets the set of allowed values for the property sumInsured.
     *
     * @throws ClassCastException if the type of value set does not match the property's
     *             configuration.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValuesSetter("sumInsured")
    @IpsGenerated
    public void setAllowedValuesForSumInsured(ValueSet<Money> rangeForSumInsured) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        if (rangeForSumInsured != null
                && !(rangeForSumInsured.isRange() || rangeForSumInsured instanceof OrderedValueSet)) {
            throw new java.lang.ClassCastException(rangeForSumInsured + " is neither a range nor an ordered value set");
        }
        this.rangeForSumInsured = rangeForSumInsured;
    }

    /**
     * Returns the referenced HomeBaseCoverageType or <code>null</code> if there is no referenced
     * HomeBaseCoverageType.
     *
     * @throws org.faktorips.runtime.ProductCmptNotFoundException if a product component is
     *             referenced but can not be found.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAssociation(name = "HomeBaseCoverageType", pluralName = "HomeBaseCoverageTypes", kind = AssociationKind.Composition, targetClass = HomeBaseCoverageType.class, min = 1, max = 1)
    @IpsMatchingAssociation(source = HomeContract.class, name = "HomeBaseCoverage")
    @IpsGenerated
    public HomeBaseCoverageType getHomeBaseCoverageType() {
        if (homeBaseCoverageType != null && !homeBaseCoverageType.getCardinality().isEmpty()) {
            return homeBaseCoverageType.getTarget();
        }
        return null;
    }

    /**
     * Sets the new HomeBaseCoverageType.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAssociationAdder(association = "HomeBaseCoverageType")
    @IpsGenerated
    public void setHomeBaseCoverageType(HomeBaseCoverageType target) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        homeBaseCoverageType = (target == null ? null
                : new ProductComponentLink<>(this, target, "HomeBaseCoverageType"));
    }

    /**
     * Sets the new HomeBaseCoverageType with the given cardinality.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAssociationAdder(association = "HomeBaseCoverageType", withCardinality = true)
    @IpsGenerated
    public void setHomeBaseCoverageType(HomeBaseCoverageType target, CardinalityRange cardinality) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        homeBaseCoverageType = (target == null ? null
                : new ProductComponentLink<>(this, target, cardinality, "HomeBaseCoverageType"));
    }

    /**
     * Returns the <code>ILink</code> to the HomeBaseCoverageType or <code>null</code>, if no object
     * is referenced.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAssociationLinks(association = "HomeBaseCoverageType")
    @IpsGenerated
    public IProductComponentLink<HomeBaseCoverageType> getLinkForHomeBaseCoverageType() {
        return homeBaseCoverageType;
    }

    /**
     * Returns the <code>ILink</code> to the HomeBaseCoverageType at the indicated index.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public IProductComponentLink<HomeBaseCoverageType> getLinkForHomeBaseCoverageType(
            HomeBaseCoverageType productComponent) {
        return homeBaseCoverageType != null && homeBaseCoverageType.getTargetId().equals(productComponent.getId())
                ? homeBaseCoverageType
                : null;
    }

    /**
     * Returns the cardinality for the number of allowed instanced for HomeBaseCoverage.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public CardinalityRange getCardinalityForHomeBaseCoverage(HomeBaseCoverageType productCmpt) {
        if (productCmpt != null) {
            return homeBaseCoverageType != null && homeBaseCoverageType.getTargetId().equals(productCmpt.getId())
                    ? homeBaseCoverageType
                            .getCardinality()
                    : null;
        }
        return null;
    }

    /**
     * Returns the referenced HomeExtraCoverageTypes. Returns an empty array, if no object is
     * referenced.
     *
     * @throws org.faktorips.runtime.ProductCmptNotFoundException if one of the referenced product
     *             component types can't be found.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAssociation(name = "HomeExtraCoverageType", pluralName = "HomeExtraCoverageTypes", kind = AssociationKind.Composition, targetClass = HomeExtraCoverageType.class, min = 0, max = Integer.MAX_VALUE)
    @IpsMatchingAssociation(source = HomeContract.class, name = "HomeExtraCoverage")
    @IpsGenerated
    public List<? extends HomeExtraCoverageType> getHomeExtraCoverageTypes() {
        List<HomeExtraCoverageType> result = new ArrayList<>(homeExtraCoverageTypes.size());
        for (IProductComponentLink<HomeExtraCoverageType> homeExtraCoverageType : homeExtraCoverageTypes.values()) {
            if (!homeExtraCoverageType.getCardinality().isEmpty()) {
                result.add(homeExtraCoverageType.getTarget());
            }
        }
        return result;
    }

    /**
     * Returns the HomeExtraCoverageType at the indicated index.
     *
     * @throws IndexOutOfBoundsException if the given index is out of range (index is negative or is
     *             greater equal the number of targets).
     * @throws org.faktorips.runtime.ProductCmptNotFoundException if the referenced product
     *             component cannot be found in the repository.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeExtraCoverageType getHomeExtraCoverageType(int index) {
        return ProductComponentLinks.getTarget(index, homeExtraCoverageTypes);
    }

    /**
     * Adds the given product component.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAssociationAdder(association = "HomeExtraCoverageType")
    @IpsGenerated
    public void addHomeExtraCoverageType(HomeExtraCoverageType target) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        this.homeExtraCoverageTypes.put(target.getId(),
                new ProductComponentLink<>(this, target, "HomeExtraCoverageType"));
    }

    /**
     * Adds the given product component with the given cardinality.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAssociationAdder(association = "HomeExtraCoverageType", withCardinality = true)
    @IpsGenerated
    public void addHomeExtraCoverageType(HomeExtraCoverageType target, CardinalityRange cardinality) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        this.homeExtraCoverageTypes.put(target.getId(),
                new ProductComponentLink<>(this, target, cardinality, "HomeExtraCoverageType"));
    }

    /**
     * Removes the association to the given product component.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAssociationRemover(association = "HomeExtraCoverageType")
    @IpsGenerated
    public void removeHomeExtraCoverageType(HomeExtraCoverageType target) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        this.homeExtraCoverageTypes.remove(target.getId());
    }

    /**
     * Returns the <code>ILink</code>s to the the referenced HomeExtraCoverageTypes. Returns a empty
     * <code>Collection</code>, if no object is referenced.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAssociationLinks(association = "HomeExtraCoverageType")
    @IpsGenerated
    public Collection<IProductComponentLink<HomeExtraCoverageType>> getLinksForHomeExtraCoverageTypes() {
        return Collections.unmodifiableCollection(homeExtraCoverageTypes.values());
    }

    /**
     * Returns the <code>ILink</code> to the HomeExtraCoverageType at the indicated index.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public IProductComponentLink<HomeExtraCoverageType> getLinkForHomeExtraCoverageType(
            HomeExtraCoverageType productComponent) {
        return homeExtraCoverageTypes.get(productComponent.getId());
    }

    /**
     * Returns the cardinality for the number of allowed instanced for HomeExtraCoverage.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public CardinalityRange getCardinalityForHomeExtraCoverage(HomeExtraCoverageType productCmpt) {
        if (productCmpt != null) {
            return homeExtraCoverageTypes.containsKey(productCmpt.getId())
                    ? homeExtraCoverageTypes.get(productCmpt.getId())
                            .getCardinality()
                    : null;
        }
        return null;
    }

    /**
     * Returns the number of HomeExtraCoverageTypes.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public int getNumOfHomeExtraCoverageTypes() {
        return homeExtraCoverageTypes.size();
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    protected void doInitPropertiesFromXml(Map<String, Element> configMap) {
        super.doInitPropertiesFromXml(configMap);
        doInitProductname(configMap);
        doInitProposedSumInsuredPerSqm(configMap);
        doInitPaymentMode(configMap);
        doInitLivingSpace(configMap);
        doInitSumInsured(configMap);
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitProductname(Map<String, Element> configMap) {
        Element configElement = configMap.get(PROPERTY_PRODUCTNAME);
        if (configElement != null) {
            String value = ValueToXmlHelper.getValueFromElement(configElement, ValueToXmlHelper.XML_TAG_VALUE);
            this.productname = value;
        }
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitProposedSumInsuredPerSqm(Map<String, Element> configMap) {
        Element configElement = configMap.get(PROPERTY_PROPOSEDSUMINSUREDPERSQM);
        if (configElement != null) {
            String value = ValueToXmlHelper.getValueFromElement(configElement, ValueToXmlHelper.XML_TAG_VALUE);
            this.proposedSumInsuredPerSqm = Money.valueOf(value);
        }
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitPaymentMode(Map<String, Element> configMap) {
        Element defaultValueElement = configMap
                .get(ValueToXmlHelper.CONFIGURED_DEFAULT_PREFIX + HomeContract.PROPERTY_PAYMENTMODE);
        if (defaultValueElement != null) {
            String value = ValueToXmlHelper.getValueFromElement(defaultValueElement);
            defaultValuePaymentMode = IpsStringUtils.isEmpty(value) ? null : Integer.valueOf(value);
        }
        Element valueSetElement = configMap
                .get(ValueToXmlHelper.CONFIGURED_VALUE_SET_PREFIX + HomeContract.PROPERTY_PAYMENTMODE);
        if (valueSetElement != null) {
            EnumValues values = ValueToXmlHelper.getEnumValueSetFromElement(valueSetElement,
                    ValueToXmlHelper.XML_TAG_VALUE_SET);
            if (values != null) {
                List<Integer> enumValues = new ArrayList<>();
                for (int i = 0; i < values.getNumberOfValues(); i++) {
                    enumValues.add(
                            IpsStringUtils.isEmpty(values.getValue(i)) ? null : Integer.valueOf(values.getValue(i)));
                }
                allowedValuesForPaymentMode = new OrderedValueSet<>(enumValues, values
                        .containsNull(), null);
            }
        }
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitLivingSpace(Map<String, Element> configMap) {
        Element defaultValueElement = configMap
                .get(ValueToXmlHelper.CONFIGURED_DEFAULT_PREFIX + HomeContract.PROPERTY_LIVINGSPACE);
        if (defaultValueElement != null) {
            String value = ValueToXmlHelper.getValueFromElement(defaultValueElement);
            defaultValueLivingSpace = IpsStringUtils.isEmpty(value) ? null : Integer.valueOf(value);
        }
        Element valueSetElement = configMap
                .get(ValueToXmlHelper.CONFIGURED_VALUE_SET_PREFIX + HomeContract.PROPERTY_LIVINGSPACE);
        if (valueSetElement != null) {
            EnumValues values = ValueToXmlHelper.getEnumValueSetFromElement(valueSetElement,
                    ValueToXmlHelper.XML_TAG_VALUE_SET);
            if (values != null) {
                List<Integer> enumValues = new ArrayList<>();
                for (int i = 0; i < values.getNumberOfValues(); i++) {
                    enumValues.add(
                            IpsStringUtils.isEmpty(values.getValue(i)) ? null : Integer.valueOf(values.getValue(i)));
                }
                rangeForLivingSpace = new OrderedValueSet<>(enumValues, values
                        .containsNull(), null);
            }
            Range range = ValueToXmlHelper.getRangeFromElement(valueSetElement, ValueToXmlHelper.XML_TAG_VALUE_SET);
            if (range != null) {
                if (range.isEmpty()) {
                    rangeForLivingSpace = IntegerRange.empty();
                } else {
                    rangeForLivingSpace = IntegerRange.valueOf(range.getLower(), range
                            .getUpper(), range.getStep(), range.containsNull());
                }
            }
        }
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitSumInsured(Map<String, Element> configMap) {
        Element defaultValueElement = configMap
                .get(ValueToXmlHelper.CONFIGURED_DEFAULT_PREFIX + HomeContract.PROPERTY_SUMINSURED);
        if (defaultValueElement != null) {
            String value = ValueToXmlHelper.getValueFromElement(defaultValueElement);
            defaultValueSumInsured = Money.valueOf(value);
        }
        Element valueSetElement = configMap
                .get(ValueToXmlHelper.CONFIGURED_VALUE_SET_PREFIX + HomeContract.PROPERTY_SUMINSURED);
        if (valueSetElement != null) {
            EnumValues values = ValueToXmlHelper.getEnumValueSetFromElement(valueSetElement,
                    ValueToXmlHelper.XML_TAG_VALUE_SET);
            if (values != null) {
                List<Money> enumValues = new ArrayList<>();
                for (int i = 0; i < values.getNumberOfValues(); i++) {
                    enumValues.add(Money.valueOf(values.getValue(i)));
                }
                rangeForSumInsured = new OrderedValueSet<>(enumValues, values
                        .containsNull(), Money.NULL);
            }
            Range range = ValueToXmlHelper.getRangeFromElement(valueSetElement, ValueToXmlHelper.XML_TAG_VALUE_SET);
            if (range != null) {
                if (range.isEmpty()) {
                    rangeForSumInsured = MoneyRange.empty();
                } else {
                    rangeForSumInsured = MoneyRange.valueOf(range.getLower(), range
                            .getUpper(), range.getStep(), range.containsNull());
                }
            }
        }
    }

    /**
     * @generated
     */
    @Override
    @IpsGenerated
    protected void doInitReferencesFromXml(Map<String, List<Element>> elementsMap) {
        super.doInitReferencesFromXml(elementsMap);
        doInitHomeBaseCoverageType(elementsMap);
        doInitHomeExtraCoverageType(elementsMap);
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitHomeBaseCoverageType(Map<String, List<Element>> elementsMap) {
        List<Element> associationElements = elementsMap.get(XML_TAG_HOME_BASE_COVERAGE_TYPE);
        if (associationElements != null) {
            for (Element element : associationElements) {
                if (!"0".equals(element.getAttribute("maxCardinality"))) {
                    homeBaseCoverageType = new ProductComponentLink<>(this);
                    homeBaseCoverageType.initFromXml(element);
                }
            }
        }
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitHomeExtraCoverageType(Map<String, List<Element>> elementsMap) {
        List<Element> associationElements = elementsMap.get(XML_TAG_HOME_EXTRA_COVERAGE_TYPES);
        if (associationElements != null) {
            this.homeExtraCoverageTypes = new LinkedHashMap<>(associationElements.size());
            for (Element element : associationElements) {
                IProductComponentLink<HomeExtraCoverageType> link = new ProductComponentLink<>(this);
                link.initFromXml(element);
                this.homeExtraCoverageTypes.put(link.getTargetId(), link);
            }
        }
    }

    /**
     * Creates a new HomeContract that is configured.
     *
     * @generated
     */
    @IpsGenerated
    public HomeContract createHomeContract() {
        HomeContract policy = new HomeContract(this);
        policy.initialize();
        return policy;
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public HomeContract createPolicyComponent() {
        return createHomeContract();
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public IProductComponentLink<? extends IProductComponent> getLink(String linkName, IProductComponent target) {
        if ("HomeBaseCoverageType".equals(linkName)) {
            return getLinkForHomeBaseCoverageType((HomeBaseCoverageType)target);
        }
        if ("HomeExtraCoverageType".equals(linkName)) {
            return getLinkForHomeExtraCoverageType((HomeExtraCoverageType)target);
        }
        return null;
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public List<IProductComponentLink<? extends IProductComponent>> getLinks() {
        List<IProductComponentLink<? extends IProductComponent>> list = new ArrayList<>();
        if (getLinkForHomeBaseCoverageType() != null) {
            list.add(getLinkForHomeBaseCoverageType());
        }
        list.addAll(getLinksForHomeExtraCoverageTypes());
        return list;
    }

    /**
     * Creates a new instance of HomeProductBuilder to edit this product.
     *
     * @generated
     */
    @IpsGenerated
    public HomeProductBuilder modify() {
        return HomeProductBuilder.from(this, (IModifiableRuntimeRepository)this.getRepository());
    }

    /**
     * Generates a new instance of HomeProduct with a given {@link IModifiableRuntimeRepository},
     * ID, kindID and versionID. The new product is set to be valid from 1900/1/1.
     *
     * @generated
     */
    @IpsGenerated
    public static HomeProductBuilder builder(IModifiableRuntimeRepository runtimeRepository,
            String id,
            String kindId,
            String versionId) {
        HomeProduct product = new HomeProduct(runtimeRepository, id, kindId, versionId);
        product.setValidFrom(new DateTime(1900, 1, 1));
        runtimeRepository.putProductComponent(product);

        return new HomeProductBuilder(product, runtimeRepository);
    }

    /**
     * Generates a new instance of HomeProduct with a given {@link IModifiableRuntimeRepository},
     * ID, kindID and versionID.
     *
     * @generated
     */
    @IpsGenerated
    public static HomeProductBuilder builder(IModifiableRuntimeRepository runtimeRepository,
            String id,
            String kindId,
            String versionId,
            DateTime validFrom) {
        HomeProduct product = new HomeProduct(runtimeRepository, id, kindId, versionId);
        product.setValidFrom(validFrom);
        runtimeRepository.putProductComponent(product);

        return new HomeProductBuilder(product, runtimeRepository);
    }

    /**
     * Generates a new instance of HomeProduct with the ID of an existing product component.
     *
     * @generated
     */
    @IpsGenerated
    public static HomeProductBuilder builder(IModifiableRuntimeRepository runtimeRepository, String prodCmptId) {
        HomeProduct product = (HomeProduct)runtimeRepository.getProductComponent(prodCmptId);

        if (product == null) {
            throw new RuntimeException("No product component found with given ID!");
        } else {
            return HomeProductBuilder.from(product, runtimeRepository);
        }
    }
}
