package org.faktorips.tutorial.model.home;

import org.faktorips.runtime.IModifiableRuntimeRepository;
import org.faktorips.values.Decimal;
import org.faktorips.values.Money;
import org.faktorips.runtime.annotation.IpsGenerated;

/**
 * Implementation of HomeExtraCoverageTypeBuilder. A HomeExtraCoverageTypeBuilder provides all
 * functionalities that are needed to edit a HomeExtraCoverageType. Note that this is only for
 * testing purpose. All instances of product have to be created in a new
 * {@link IModifiableRuntimeRepository} as Product Component in the runtime repository can not be
 * edited.
 *
 * @since 1.0
 *
 * @generated
 */
public class HomeExtraCoverageTypeBuilder {
    /**
     * @generated
     */
    private final IModifiableRuntimeRepository runtimeRepository;

    /**
     * @generated
     */
    private final HomeExtraCoverageType homeExtraCoverageType;

    /**
     * Generates a new instance of HomeExtraCoverageTypeBuilder with a given product. The product
     * must exist in the given {@link IModifiableRuntimeRepository} that is not allowed to be null.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    protected HomeExtraCoverageTypeBuilder(HomeExtraCoverageType product,
            IModifiableRuntimeRepository runtimeRepository) {
        if (product == null || runtimeRepository == null) {
            throw new RuntimeException("Product and repository can not be null!");
        } else {
            runtimeRepository.getExistingProductComponent(product.getId());

            this.runtimeRepository = runtimeRepository;
            this.homeExtraCoverageType = product;
        }
    }

    /**
     * Sets the value of attribute name.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeExtraCoverageTypeBuilder name(String name) {
        homeExtraCoverageType.setName(name);
        return this;
    }

    /**
     * Sets the value of attribute factorSumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeExtraCoverageTypeBuilder factorSumInsured(Decimal factorSumInsured) {
        homeExtraCoverageType.setFactorSumInsured(factorSumInsured);
        return this;
    }

    /**
     * Sets the value of attribute maxSumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeExtraCoverageTypeBuilder maxSumInsured(Money maxSumInsured) {
        homeExtraCoverageType.setMaxSumInsured(maxSumInsured);
        return this;
    }

    /**
     * @return {@link IModifiableRuntimeRepository} that is saved.
     *
     * @generated
     */
    @IpsGenerated
    public IModifiableRuntimeRepository getRepository() {
        return this.runtimeRepository;
    }

    /**
     * @return instance of HomeExtraCoverageType that is built.
     *
     * @generated
     */
    @IpsGenerated
    public HomeExtraCoverageType getResult() {
        return homeExtraCoverageType;
    }

    /**
     * Interne Methode
     *
     * @generated
     */
    @IpsGenerated
    public static Class<?> getProductClass() {
        return HomeExtraCoverageType.class;
    }

    /**
     * Creates a new HomeExtraCoverageTypeBuilder with a given HomeExtraCoverageType and a runtime
     * repository.
     *
     * @generated
     */
    @IpsGenerated
    public static HomeExtraCoverageTypeBuilder from(HomeExtraCoverageType product,
            IModifiableRuntimeRepository runtimeRepository) {
        return new HomeExtraCoverageTypeBuilder(product, runtimeRepository);
    }

}
