package org.faktorips.tutorial.model.home;

import org.faktorips.runtime.model.annotation.IpsProductCmptType;
import org.faktorips.runtime.model.annotation.IpsAttributes;
import org.faktorips.runtime.model.annotation.IpsConfigures;
import org.faktorips.runtime.model.annotation.IpsFormulas;
import org.faktorips.runtime.model.annotation.IpsDocumented;
import org.faktorips.runtime.internal.ProductComponent;
import org.faktorips.runtime.model.annotation.IpsAllowedValues;
import org.faktorips.valueset.ValueSet;
import org.faktorips.valueset.UnrestrictedValueSet;
import org.faktorips.runtime.model.annotation.IpsDefaultValue;
import org.faktorips.values.Decimal;
import org.faktorips.values.Money;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.model.annotation.IpsAttribute;
import org.faktorips.runtime.model.type.AttributeKind;
import org.faktorips.runtime.model.type.ValueSetKind;
import org.faktorips.runtime.model.annotation.IpsAttributeSetter;
import org.faktorips.runtime.IllegalRepositoryModificationException;
import org.faktorips.runtime.model.annotation.IpsFormula;
import org.faktorips.runtime.FormulaExecutionException;
import org.w3c.dom.Element;
import java.util.Map;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.faktorips.runtime.IModifiableRuntimeRepository;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.annotation.IpsGenerated;

/**
 * Implementation for HomeExtraCoverageType.
 *
 * @since 1.0
 *
 * @generated
 */
@IpsProductCmptType(name = "home.HomeExtraCoverageType")
@IpsAttributes({ "name", "factorSumInsured", "maxSumInsured" })
@IpsConfigures(HomeExtraCoverage.class)
@IpsFormulas({ "annualBasePremium" })
@IpsDocumented(bundleName = "org.faktorips.tutorial.model.model-label-and-descriptions", defaultLocale = "en")
public class HomeExtraCoverageType extends ProductComponent {

    /**
     * The name of the property name.
     *
     * @since 1.0
     *
     * @generated
     */
    public static final String PROPERTY_NAME = "name";
    /**
     * Max allowed values for property name.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("name")
    public static final ValueSet<String> MAX_ALLOWED_VALUES_FOR_NAME = new UnrestrictedValueSet<>(true);
    /**
     * The default value for name.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsDefaultValue("name")
    public static final String DEFAULT_VALUE_FOR_NAME = null;
    /**
     * The name of the property factorSumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    public static final String PROPERTY_FACTORSUMINSURED = "factorSumInsured";
    /**
     * Max allowed values for property factorSumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("factorSumInsured")
    public static final ValueSet<Decimal> MAX_ALLOWED_VALUES_FOR_FACTOR_SUM_INSURED = new UnrestrictedValueSet<>(true);
    /**
     * The default value for factorSumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsDefaultValue("factorSumInsured")
    public static final Decimal DEFAULT_VALUE_FOR_FACTOR_SUM_INSURED = Decimal.NULL;
    /**
     * The name of the property maxSumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    public static final String PROPERTY_MAXSUMINSURED = "maxSumInsured";
    /**
     * Max allowed values for property maxSumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("maxSumInsured")
    public static final ValueSet<Money> MAX_ALLOWED_VALUES_FOR_MAX_SUM_INSURED = new UnrestrictedValueSet<>(true);
    /**
     * The default value for maxSumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsDefaultValue("maxSumInsured")
    public static final Money DEFAULT_VALUE_FOR_MAX_SUM_INSURED = Money.NULL;
    /**
     * The product component property Name.
     *
     * @since 1.0
     *
     * @generated
     */
    private String name = DEFAULT_VALUE_FOR_NAME;
    /**
     * The product component property FactorSumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    private Decimal factorSumInsured = DEFAULT_VALUE_FOR_FACTOR_SUM_INSURED;
    /**
     * The product component property MaxSumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    private Money maxSumInsured = DEFAULT_VALUE_FOR_MAX_SUM_INSURED;

    /**
     * Creates a new HomeExtraCoverageType.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeExtraCoverageType(IRuntimeRepository repository, String id, String kindId, String versionId) {
        super(repository, id, kindId, versionId);
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public boolean isChangingOverTime() {
        return false;
    }

    /**
     * Returns the value of name.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAttribute(name = "name", kind = AttributeKind.CONSTANT, valueSetKind = ValueSetKind.AllValues)
    @IpsGenerated
    public String getName() {
        return name;
    }

    /**
     * Sets the value of attribute name.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAttributeSetter("name")
    @IpsGenerated
    public void setName(String newValue) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        setNameInternal(newValue);
    }

    /**
     * Sets the value of attribute name.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    protected final void setNameInternal(String newValue) {
        this.name = newValue;
    }

    /**
     * Returns the value of factorSumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAttribute(name = "factorSumInsured", kind = AttributeKind.CONSTANT, valueSetKind = ValueSetKind.AllValues)
    @IpsGenerated
    public Decimal getFactorSumInsured() {
        return factorSumInsured;
    }

    /**
     * Sets the value of attribute factorSumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAttributeSetter("factorSumInsured")
    @IpsGenerated
    public void setFactorSumInsured(Decimal newValue) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        setFactorSumInsuredInternal(newValue);
    }

    /**
     * Sets the value of attribute factorSumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    protected final void setFactorSumInsuredInternal(Decimal newValue) {
        this.factorSumInsured = newValue;
    }

    /**
     * Returns the value of maxSumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAttribute(name = "maxSumInsured", kind = AttributeKind.CONSTANT, valueSetKind = ValueSetKind.AllValues)
    @IpsGenerated
    public Money getMaxSumInsured() {
        return maxSumInsured;
    }

    /**
     * Sets the value of attribute maxSumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAttributeSetter("maxSumInsured")
    @IpsGenerated
    public void setMaxSumInsured(Money newValue) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        setMaxSumInsuredInternal(newValue);
    }

    /**
     * Sets the value of attribute maxSumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    protected final void setMaxSumInsuredInternal(Money newValue) {
        this.maxSumInsured = newValue;
    }

    /**
     * @since 1.0
     * @generated
     */
    @IpsFormula(name = "annualBasePremium", required = true)
    @IpsGenerated
    public Money computeAnnualBasePremium(HomeContract contract, HomeExtraCoverage coverage)
            throws FormulaExecutionException {
        return (Money)getFormulaEvaluator().evaluate("computeAnnualBasePremium", contract, coverage);
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    protected void doInitPropertiesFromXml(Map<String, Element> configMap) {
        super.doInitPropertiesFromXml(configMap);
        doInitName(configMap);
        doInitFactorSumInsured(configMap);
        doInitMaxSumInsured(configMap);
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitName(Map<String, Element> configMap) {
        Element configElement = configMap.get(PROPERTY_NAME);
        if (configElement != null) {
            String value = ValueToXmlHelper.getValueFromElement(configElement, ValueToXmlHelper.XML_TAG_VALUE);
            this.name = value;
        }
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitFactorSumInsured(Map<String, Element> configMap) {
        Element configElement = configMap.get(PROPERTY_FACTORSUMINSURED);
        if (configElement != null) {
            String value = ValueToXmlHelper.getValueFromElement(configElement, ValueToXmlHelper.XML_TAG_VALUE);
            this.factorSumInsured = Decimal.valueOf(value);
        }
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitMaxSumInsured(Map<String, Element> configMap) {
        Element configElement = configMap.get(PROPERTY_MAXSUMINSURED);
        if (configElement != null) {
            String value = ValueToXmlHelper.getValueFromElement(configElement, ValueToXmlHelper.XML_TAG_VALUE);
            this.maxSumInsured = Money.valueOf(value);
        }
    }

    /**
     * Creates a new HomeExtraCoverage that is configured.
     *
     * @generated
     */
    @IpsGenerated
    public HomeExtraCoverage createHomeExtraCoverage() {
        HomeExtraCoverage policy = new HomeExtraCoverage(this);
        policy.initialize();
        return policy;
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public HomeExtraCoverage createPolicyComponent() {
        return createHomeExtraCoverage();
    }

    /**
     * Creates a new instance of HomeExtraCoverageTypeBuilder to edit this product.
     *
     * @generated
     */
    @IpsGenerated
    public HomeExtraCoverageTypeBuilder modify() {
        return HomeExtraCoverageTypeBuilder.from(this, (IModifiableRuntimeRepository)this.getRepository());
    }

    /**
     * Generates a new instance of HomeExtraCoverageType with a given
     * {@link IModifiableRuntimeRepository}, ID, kindID and versionID. The new product is set to be
     * valid from 1900/1/1.
     *
     * @generated
     */
    @IpsGenerated
    public static HomeExtraCoverageTypeBuilder builder(IModifiableRuntimeRepository runtimeRepository,
            String id,
            String kindId,
            String versionId) {
        HomeExtraCoverageType product = new HomeExtraCoverageType(runtimeRepository, id, kindId, versionId);
        product.setValidFrom(new DateTime(1900, 1, 1));
        runtimeRepository.putProductComponent(product);

        return new HomeExtraCoverageTypeBuilder(product, runtimeRepository);
    }

    /**
     * Generates a new instance of HomeExtraCoverageType with a given
     * {@link IModifiableRuntimeRepository}, ID, kindID and versionID.
     *
     * @generated
     */
    @IpsGenerated
    public static HomeExtraCoverageTypeBuilder builder(IModifiableRuntimeRepository runtimeRepository,
            String id,
            String kindId,
            String versionId,
            DateTime validFrom) {
        HomeExtraCoverageType product = new HomeExtraCoverageType(runtimeRepository, id, kindId, versionId);
        product.setValidFrom(validFrom);
        runtimeRepository.putProductComponent(product);

        return new HomeExtraCoverageTypeBuilder(product, runtimeRepository);
    }

    /**
     * Generates a new instance of HomeExtraCoverageType with the ID of an existing product
     * component.
     *
     * @generated
     */
    @IpsGenerated
    public static HomeExtraCoverageTypeBuilder builder(IModifiableRuntimeRepository runtimeRepository,
            String prodCmptId) {
        HomeExtraCoverageType product = (HomeExtraCoverageType)runtimeRepository.getProductComponent(prodCmptId);

        if (product == null) {
            throw new RuntimeException("No product component found with given ID!");
        } else {
            return HomeExtraCoverageTypeBuilder.from(product, runtimeRepository);
        }
    }
}
