package org.faktorips.tutorial.model.home;

import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.values.Money;
import org.faktorips.runtime.annotation.IpsGenerated;

/**
 * This class provides methods to edit a HomeContract.
 *
 * @since 1.0
 *
 * @generated
 */
public class HomeContractBuilder {
    /**
     * @generated
     */
    private final HomeContract homeContract;

    /**
     * @generated
     */
    private IRuntimeRepository runtimeRepository;

    /**
     * Creates a new HomeContractBuilder with a given policy and runtime repository. This
     * constructor is only to be used internally by the builder!
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    protected HomeContractBuilder(HomeContract policy, IRuntimeRepository runtimeRepository) {
        this.homeContract = policy;
        this.runtimeRepository = runtimeRepository;
    }

    /**
     * @generated
     */
    @IpsGenerated
    public HomeContractBuilder setRepository(IRuntimeRepository runtimeRepository) {
        this.runtimeRepository = runtimeRepository;
        return this;
    }

    /**
     * Sets the value of attribute paymentMode.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeContractBuilder paymentMode(Integer newPaymentMode) {
        homeContract.setPaymentMode(newPaymentMode);
        return this;
    }

    /**
     * Sets the value of attribute zipcode.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeContractBuilder zipcode(String newZipcode) {
        homeContract.setZipcode(newZipcode);
        return this;
    }

    /**
     * Sets the value of attribute livingSpace.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeContractBuilder livingSpace(Integer newLivingSpace) {
        homeContract.setLivingSpace(newLivingSpace);
        return this;
    }

    /**
     * Sets the value of attribute sumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeContractBuilder sumInsured(Money newSumInsured) {
        homeContract.setSumInsured(newSumInsured);
        return this;
    }

    /**
     * Returns the HomeContract that is built by this instance.
     *
     * @generated
     */
    @IpsGenerated
    public HomeContract getResult() {
        return homeContract;
    }

    /**
     * @generated
     */
    @IpsGenerated
    public IRuntimeRepository getRepository() {
        return runtimeRepository;
    }

    /**
     *
     *
     * @generated
     */
    @IpsGenerated
    public static Class<?> getPolicyClass() {
        return HomeContract.class;
    }

    /**
     * Creates a new HomeContractBuilder with a given HomeContract.
     *
     * @generated
     */
    @IpsGenerated
    public static HomeContractBuilder from(HomeContract policy) {
        return new HomeContractBuilder(policy, null);
    }

    /**
     * Creates a new HomeContractBuilder with a given HomeContract and a runtime repository.
     *
     * @generated
     */
    @IpsGenerated
    public static HomeContractBuilder from(HomeContract policy, IRuntimeRepository runtimeRepository) {
        return new HomeContractBuilder(policy, runtimeRepository);
    }

    /**
     * Returns an {@link AssociationBuilder} to build a target object and add directly to a
     * specified association. With the {@link AssociationBuilder} you get the builder of the target
     * object for further processing. Use the method {@link #add()} if you want to create multiple
     * target objects and always return to this builder instead of the target builder.
     *
     * @see #add()
     *
     * @generated
     */
    @IpsGenerated
    public AssociationBuilder associate() {
        return new AssociationBuilder(this);
    }

    /**
     * Returns an {@link AddAssociationBuilder} to build a target object and add directly to a
     * specified association. With the {@link AddAssociationBuilder} you always could return to this
     * builder for further processing. Use the method {@link #associate()} if you want to have the
     * builder of the target object.
     *
     * @see #associate()
     *
     * @generated
     */
    @IpsGenerated
    public AddAssociationBuilder add() {
        return new AddAssociationBuilder(this);
    }

    /**
     * This class wraps setter methods for associations. Methods in this class returns a builder for
     * the target class.
     *
     * @generated
     */
    public static class AssociationBuilder {

        /**
         * @generated
         */
        private HomeContractBuilder policyBuilder;

        /**
         * @generated
         */
        @IpsGenerated
        protected AssociationBuilder(HomeContractBuilder policyBuilder) {
            this.policyBuilder = policyBuilder;
        }

        /**
         * Creates a new instance of a subclass of HomeBaseCoverage with the given builder and sets
         * it as the target of the association HomeBaseCoverage.
         *
         * @generated
         */
        @IpsGenerated
        public <T extends HomeBaseCoverageBuilder> T homeBaseCoverage(T targetBuilder) {
            getResult().setHomeBaseCoverage(targetBuilder.getResult());
            return targetBuilder;
        }

        /**
         * Creates a new instance of HomeBaseCoverage and set it as the target of the association
         * HomeBaseCoverage.
         *
         * @generated
         */
        @IpsGenerated
        public HomeBaseCoverageBuilder homeBaseCoverage() {
            HomeBaseCoverageBuilder targetBuilder = HomeBaseCoverage.builder();
            getResult().setHomeBaseCoverage(targetBuilder.getResult());
            return targetBuilder;
        }

        /**
         * Creates a new instance of HomeBaseCoverage from a given product component and sets it as
         * the target of the association HomeBaseCoverage.
         *
         * @generated
         */
        @IpsGenerated
        public HomeBaseCoverageBuilder homeBaseCoverage(String productCmptId) {
            if (getRepository() == null) {
                throw new RuntimeException("No repository given! ");
            }
            HomeBaseCoverageBuilder targetBuilder = null;
            targetBuilder = HomeBaseCoverage.builder(getRepository(), productCmptId);
            getResult().setHomeBaseCoverage(targetBuilder.getResult());
            return targetBuilder;
        }

        /**
         * Creates a new instance of a subclass of HomeExtraCoverage with the given builder and sets
         * it as the target of the association HomeExtraCoverage.
         *
         * @generated
         */
        @IpsGenerated
        public <T extends HomeExtraCoverageBuilder> T homeExtraCoverage(T targetBuilder) {
            getResult().addHomeExtraCoverage(targetBuilder.getResult());
            return targetBuilder;
        }

        /**
         * Creates a new instance of HomeExtraCoverage and set it as the target of the association
         * HomeExtraCoverage.
         *
         * @generated
         */
        @IpsGenerated
        public HomeExtraCoverageBuilder homeExtraCoverage() {
            HomeExtraCoverageBuilder targetBuilder = HomeExtraCoverage.builder();
            getResult().addHomeExtraCoverage(targetBuilder.getResult());
            return targetBuilder;
        }

        /**
         * Creates a new instance of HomeExtraCoverage from a given product component and sets it as
         * the target of the association HomeExtraCoverage.
         *
         * @generated
         */
        @IpsGenerated
        public HomeExtraCoverageBuilder homeExtraCoverage(String productCmptId) {
            if (getRepository() == null) {
                throw new RuntimeException("No repository given! ");
            }
            HomeExtraCoverageBuilder targetBuilder = null;
            targetBuilder = HomeExtraCoverage.builder(getRepository(), productCmptId);
            getResult().addHomeExtraCoverage(targetBuilder.getResult());
            return targetBuilder;
        }

        /**
         * @generated
         */
        @IpsGenerated
        protected HomeContract getResult() {
            return policyBuilder.getResult();
        }

        /**
         * @generated
         */
        @IpsGenerated
        protected IRuntimeRepository getRepository() {
            return policyBuilder.getRepository();
        }
    }

    /**
     * This class wraps setter methods for associations. Methods in this class return the original
     * HomeContractBuilder.
     *
     * @generated
     */
    public static class AddAssociationBuilder {

        /**
         * @generated
         */
        private HomeContractBuilder policyBuilder;

        /**
         * @generated
         */
        @IpsGenerated
        protected AddAssociationBuilder(HomeContractBuilder policyBuilder) {
            this.policyBuilder = policyBuilder;
        }

        /**
         * Set a existing instance of HomeBaseCoverage as the target of the association
         * HomeBaseCoverage.
         *
         * @generated
         */
        @IpsGenerated
        public HomeContractBuilder homeBaseCoverage(HomeBaseCoverage targetPolicy) {
            getResult().setHomeBaseCoverage(targetPolicy);
            return done();
        }

        /**
         * Creates a new instance of a subclass of HomeBaseCoverage with the given builder and sets
         * it as the target of the association HomeBaseCoverage.
         *
         * @generated
         */
        @IpsGenerated
        public HomeContractBuilder homeBaseCoverage(HomeBaseCoverageBuilder targetBuilder) {
            getResult().setHomeBaseCoverage(targetBuilder.getResult());
            return done();
        }

        /**
         * Creates a new instance of HomeBaseCoverage and set it as the target of the association
         * HomeBaseCoverage.
         *
         * @generated
         */
        @IpsGenerated
        public HomeContractBuilder homeBaseCoverage() {
            HomeBaseCoverageBuilder targetBuilder = HomeBaseCoverage.builder();
            getResult().setHomeBaseCoverage(targetBuilder.getResult());
            return done();
        }

        /**
         * Creates a new instance of HomeBaseCoverage from a given product component and sets it as
         * the target of the association HomeBaseCoverage.
         *
         * @generated
         */
        @IpsGenerated
        public HomeContractBuilder homeBaseCoverage(String productCmptId) {
            if (getRepository() == null) {
                throw new RuntimeException("No repository given! ");
            }
            HomeBaseCoverageBuilder targetBuilder = null;
            targetBuilder = HomeBaseCoverage.builder(getRepository(), productCmptId);
            getResult().setHomeBaseCoverage(targetBuilder.getResult());
            return done();
        }

        /**
         * Set a existing instance of HomeExtraCoverage as the target of the association
         * HomeExtraCoverage.
         *
         * @generated
         */
        @IpsGenerated
        public HomeContractBuilder homeExtraCoverage(HomeExtraCoverage targetPolicy) {
            getResult().addHomeExtraCoverage(targetPolicy);
            return done();
        }

        /**
         * Creates a new instance of a subclass of HomeExtraCoverage with the given builder and sets
         * it as the target of the association HomeExtraCoverage.
         *
         * @generated
         */
        @IpsGenerated
        public HomeContractBuilder homeExtraCoverage(HomeExtraCoverageBuilder targetBuilder) {
            getResult().addHomeExtraCoverage(targetBuilder.getResult());
            return done();
        }

        /**
         * Creates a new instance of HomeExtraCoverage and set it as the target of the association
         * HomeExtraCoverage.
         *
         * @generated
         */
        @IpsGenerated
        public HomeContractBuilder homeExtraCoverage() {
            HomeExtraCoverageBuilder targetBuilder = HomeExtraCoverage.builder();
            getResult().addHomeExtraCoverage(targetBuilder.getResult());
            return done();
        }

        /**
         * Creates a new instance of HomeExtraCoverage from a given product component and sets it as
         * the target of the association HomeExtraCoverage.
         *
         * @generated
         */
        @IpsGenerated
        public HomeContractBuilder homeExtraCoverage(String productCmptId) {
            if (getRepository() == null) {
                throw new RuntimeException("No repository given! ");
            }
            HomeExtraCoverageBuilder targetBuilder = null;
            targetBuilder = HomeExtraCoverage.builder(getRepository(), productCmptId);
            getResult().addHomeExtraCoverage(targetBuilder.getResult());
            return done();
        }

        /**
         * @generated
         */
        @IpsGenerated
        protected HomeContractBuilder done() {
            return policyBuilder;
        }

        /**
         * @generated
         */
        @IpsGenerated
        protected HomeContract getResult() {
            return policyBuilder.getResult();
        }

        /**
         * @generated
         */
        @IpsGenerated
        protected IRuntimeRepository getRepository() {
            return policyBuilder.getRepository();
        }
    }

}
