package org.faktorips.tutorial.model.home;

import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.faktorips.runtime.IConfigurableModelObject;
import org.faktorips.runtime.ICopySupport;
import org.faktorips.runtime.IDeltaComputationOptions;
import org.faktorips.runtime.IDeltaSupport;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IModelObjectDelta;
import org.faktorips.runtime.IModelObjectVisitor;
import org.faktorips.runtime.IObjectReferenceStore;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.IValidationContext;
import org.faktorips.runtime.IVisitorSupport;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.annotation.IpsGenerated;
import org.faktorips.runtime.internal.AbstractModelObject;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.ModelObjectDelta;
import org.faktorips.runtime.internal.ProductConfiguration;
import org.faktorips.runtime.internal.XmlCallback;
import org.faktorips.runtime.model.annotation.IpsAllowedValues;
import org.faktorips.runtime.model.annotation.IpsAssociation;
import org.faktorips.runtime.model.annotation.IpsAssociationAdder;
import org.faktorips.runtime.model.annotation.IpsAssociationRemover;
import org.faktorips.runtime.model.annotation.IpsAssociations;
import org.faktorips.runtime.model.annotation.IpsAttribute;
import org.faktorips.runtime.model.annotation.IpsAttributeSetter;
import org.faktorips.runtime.model.annotation.IpsAttributes;
import org.faktorips.runtime.model.annotation.IpsConfiguredAttribute;
import org.faktorips.runtime.model.annotation.IpsConfiguredBy;
import org.faktorips.runtime.model.annotation.IpsDocumented;
import org.faktorips.runtime.model.annotation.IpsInverseAssociation;
import org.faktorips.runtime.model.annotation.IpsMatchingAssociation;
import org.faktorips.runtime.model.annotation.IpsPolicyCmptType;
import org.faktorips.runtime.model.type.AssociationKind;
import org.faktorips.runtime.model.type.AttributeKind;
import org.faktorips.runtime.model.type.ValueSetKind;
import org.faktorips.values.Decimal;
import org.faktorips.values.Money;
import org.faktorips.valueset.IntegerRange;
import org.faktorips.valueset.MoneyRange;
import org.faktorips.valueset.OrderedValueSet;
import org.faktorips.runtime.model.annotation.IpsDefaultValue;
import org.faktorips.valueset.ValueSet;
import org.faktorips.valueset.UnrestrictedValueSet;
import org.w3c.dom.Element;

/**
 * Implementation for HomeContract.
 *
 * @since 1.0
 *
 * @generated
 */
@IpsPolicyCmptType(name = "home.HomeContract")
@IpsAttributes({ "paymentMode", "zipcode", "ratingDistrict", "livingSpace", "proposedSumInsured", "sumInsured",
        "netPremiumPm", "grossPremiumPm", "annualBasePremium" })
@IpsAssociations({ "HomeBaseCoverage", "HomeExtraCoverage" })
@IpsConfiguredBy(HomeProduct.class)
@IpsDocumented(bundleName = "org.faktorips.tutorial.model.model-label-and-descriptions", defaultLocale = "en")
public class HomeContract extends AbstractModelObject
        implements IDeltaSupport, ICopySupport, IVisitorSupport, IConfigurableModelObject {

    /**
     * The maximal multiplicity of the association with the role name HomeBaseCoverage.
     *
     * @since 1.0
     *
     * @generated
     */
    public static final IntegerRange MAX_MULTIPLICITY_OF_HOME_BASE_COVERAGE = IntegerRange.valueOf(1, 1);
    /**
     * The name of the association homeBaseCoverage.
     *
     * @since 1.0
     *
     * @generated
     */
    public static final String ASSOCIATION_HOME_BASE_COVERAGE = "homeBaseCoverage";
    /**
     * The maximal multiplicity of the association with the role name HomeExtraCoverage.
     *
     * @since 1.0
     *
     * @generated
     */
    public static final IntegerRange MAX_MULTIPLICITY_OF_HOME_EXTRA_COVERAGE = IntegerRange.valueOf(0, 2147483647);
    /**
     * The name of the association homeExtraCoverages.
     *
     * @since 1.0
     *
     * @generated
     */
    public static final String ASSOCIATION_HOME_EXTRA_COVERAGES = "homeExtraCoverages";
    /**
     * The name of the property paymentMode.
     *
     * @since 1.0
     *
     * @generated
     */
    public static final String PROPERTY_PAYMENTMODE = "paymentMode";
    /**
     * Max allowed values for property paymentMode.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("paymentMode")
    public static final OrderedValueSet<Integer> MAX_ALLOWED_VALUES_FOR_PAYMENT_MODE = new OrderedValueSet<>(false,
            null, Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(12));
    /**
     * The default value for paymentMode.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsDefaultValue("paymentMode")
    public static final Integer DEFAULT_VALUE_FOR_PAYMENT_MODE = null;
    /**
     * The name of the property zipcode.
     *
     * @since 1.0
     *
     * @generated
     */
    public static final String PROPERTY_ZIPCODE = "zipcode";
    /**
     * Max allowed values for property zipcode.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("zipcode")
    public static final ValueSet<String> MAX_ALLOWED_VALUES_FOR_ZIPCODE = new UnrestrictedValueSet<>(true);
    /**
     * The default value for zipcode.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsDefaultValue("zipcode")
    public static final String DEFAULT_VALUE_FOR_ZIPCODE = null;
    /**
     * The name of the property ratingDistrict.
     *
     * @since 1.0
     *
     * @generated
     */
    public static final String PROPERTY_RATINGDISTRICT = "ratingDistrict";
    /**
     * Max allowed values for property ratingDistrict.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("ratingDistrict")
    public static final ValueSet<String> MAX_ALLOWED_VALUES_FOR_RATING_DISTRICT = new UnrestrictedValueSet<>(true);
    /**
     * The name of the property livingSpace.
     *
     * @since 1.0
     *
     * @generated
     */
    public static final String PROPERTY_LIVINGSPACE = "livingSpace";
    /**
     * Max allowed range for the property livingSpace.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("livingSpace")
    public static final IntegerRange MAX_ALLOWED_RANGE_FOR_LIVING_SPACE = IntegerRange.valueOf(Integer.valueOf("0"),
            (Integer)null, (Integer)null, false);
    /**
     * The default value for livingSpace.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsDefaultValue("livingSpace")
    public static final Integer DEFAULT_VALUE_FOR_LIVING_SPACE = null;
    /**
     * The name of the property proposedSumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    public static final String PROPERTY_PROPOSEDSUMINSURED = "proposedSumInsured";
    /**
     * Max allowed values for property proposedSumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("proposedSumInsured")
    public static final ValueSet<Money> MAX_ALLOWED_VALUES_FOR_PROPOSED_SUM_INSURED = new UnrestrictedValueSet<>(true);
    /**
     * The name of the property sumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    public static final String PROPERTY_SUMINSURED = "sumInsured";
    /**
     * Max allowed range for the property sumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("sumInsured")
    public static final MoneyRange MAX_ALLOWED_RANGE_FOR_SUM_INSURED = MoneyRange.valueOf(Money.valueOf("0.00 EUR"),
            Money.NULL, Money.NULL, false);
    /**
     * The default value for sumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsDefaultValue("sumInsured")
    public static final Money DEFAULT_VALUE_FOR_SUM_INSURED = Money.NULL;
    /**
     * The name of the property netPremiumPm.
     *
     * @since 1.0
     *
     * @generated
     */
    public static final String PROPERTY_NETPREMIUMPM = "netPremiumPm";
    /**
     * Max allowed values for property netPremiumPm.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("netPremiumPm")
    public static final ValueSet<Money> MAX_ALLOWED_VALUES_FOR_NET_PREMIUM_PM = new UnrestrictedValueSet<>(true);
    /**
     * The default value for netPremiumPm.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsDefaultValue("netPremiumPm")
    public static final Money DEFAULT_VALUE_FOR_NET_PREMIUM_PM = Money.NULL;
    /**
     * The name of the property grossPremiumPm.
     *
     * @since 1.0
     *
     * @generated
     */
    public static final String PROPERTY_GROSSPREMIUMPM = "grossPremiumPm";
    /**
     * Max allowed values for property grossPremiumPm.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("grossPremiumPm")
    public static final ValueSet<Money> MAX_ALLOWED_VALUES_FOR_GROSS_PREMIUM_PM = new UnrestrictedValueSet<>(true);
    /**
     * The default value for grossPremiumPm.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsDefaultValue("grossPremiumPm")
    public static final Money DEFAULT_VALUE_FOR_GROSS_PREMIUM_PM = Money.NULL;
    /**
     * The name of the property annualBasePremium.
     *
     * @since 1.0
     *
     * @generated
     */
    public static final String PROPERTY_ANNUALBASEPREMIUM = "annualBasePremium";
    /**
     * Max allowed values for property annualBasePremium.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("annualBasePremium")
    public static final ValueSet<Money> MAX_ALLOWED_VALUES_FOR_ANNUAL_BASE_PREMIUM = new UnrestrictedValueSet<>(true);
    /**
     * The default value for annualBasePremium.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsDefaultValue("annualBasePremium")
    public static final Money DEFAULT_VALUE_FOR_ANNUAL_BASE_PREMIUM = Money.NULL;
    /**
     * Member variable for paymentMode.
     *
     * @since 1.0
     *
     * @generated
     */
    private Integer paymentMode = DEFAULT_VALUE_FOR_PAYMENT_MODE;

    /**
     * Member variable for zipcode.
     *
     * @since 1.0
     *
     * @generated
     */
    private String zipcode = DEFAULT_VALUE_FOR_ZIPCODE;
    /**
     * Member variable for livingSpace.
     *
     * @since 1.0
     *
     * @generated
     */
    private Integer livingSpace = DEFAULT_VALUE_FOR_LIVING_SPACE;
    /**
     * Member variable for sumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    private Money sumInsured = DEFAULT_VALUE_FOR_SUM_INSURED;
    /**
     * Member variable for netPremiumPm.
     *
     * @since 1.0
     *
     * @generated
     */
    private Money netPremiumPm = DEFAULT_VALUE_FOR_NET_PREMIUM_PM;
    /**
     * Member variable for grossPremiumPm.
     *
     * @since 1.0
     *
     * @generated
     */
    private Money grossPremiumPm = DEFAULT_VALUE_FOR_GROSS_PREMIUM_PM;
    /**
     * Member variable for annualBasePremium.
     *
     * @since 1.0
     *
     * @generated
     */
    private Money annualBasePremium = DEFAULT_VALUE_FOR_ANNUAL_BASE_PREMIUM;
    /**
     * References the current product configuration.
     *
     * @generated
     */
    private ProductConfiguration productConfiguration;
    /**
     * Member variable for the association with the role name HomeBaseCoverage.
     *
     * @since 1.0
     *
     * @generated
     */
    private HomeBaseCoverage homeBaseCoverage = null;

    /**
     * Member variable for the association with the role name HomeExtraCoverage.
     *
     * @since 1.0
     *
     * @generated
     */
    private List<HomeExtraCoverage> homeExtraCoverages = new ArrayList<>();

    /**
     * Creates a new HomeContract.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeContract() {
        super();
        productConfiguration = new ProductConfiguration();
    }

    /**
     * Creates a new HomeContract.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeContract(HomeProduct productCmpt) {
        super();
        productConfiguration = new ProductConfiguration(productCmpt);
    }

    /**
     * Returns the set of allowed values for the property paymentMode.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("paymentMode")
    @IpsGenerated
    public ValueSet<Integer> getAllowedValuesForPaymentMode() {
        return getHomeProduct().getAllowedValuesForPaymentMode();
    }

    /**
     * Returns the paymentMode.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAttribute(name = "paymentMode", kind = AttributeKind.CHANGEABLE, valueSetKind = ValueSetKind.Enum)
    @IpsConfiguredAttribute(changingOverTime = false)
    @IpsGenerated
    public Integer getPaymentMode() {
        return paymentMode;
    }

    /**
     * Sets the value of attribute paymentMode.
     *
     * @since 1.0
     *
     * @generated NOT
     */
    @IpsAttributeSetter("paymentMode")
    public void setPaymentMode(Integer newValue) {
        System.out.println("setPaymentMode");
        this.paymentMode = newValue;
    }

    /**
     * Returns the set of allowed values for the property zipcode.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("zipcode")
    @IpsGenerated
    public ValueSet<String> getAllowedValuesForZipcode() {
        return MAX_ALLOWED_VALUES_FOR_ZIPCODE;
    }

    /**
     * Returns the zipcode.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAttribute(name = "zipcode", kind = AttributeKind.CHANGEABLE, valueSetKind = ValueSetKind.AllValues)
    @IpsGenerated
    public String getZipcode() {
        return zipcode;
    }

    /**
     * Sets the value of attribute zipcode.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAttributeSetter("zipcode")
    @IpsGenerated
    public void setZipcode(String newValue) {
        this.zipcode = newValue;
    }

    /**
     * Returns the set of allowed values for the property ratingDistrict.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("ratingDistrict")
    @IpsGenerated
    public ValueSet<String> getAllowedValuesForRatingDistrict() {
        return MAX_ALLOWED_VALUES_FOR_RATING_DISTRICT;
    }

    /**
     * Returns the ratingDistrict.
     *
     * @since 1.0
     *
     * @restrainedmodifiable
     */
    @IpsAttribute(name = "ratingDistrict", kind = AttributeKind.DERIVED_ON_THE_FLY, valueSetKind = ValueSetKind.AllValues)
    @IpsGenerated
    public String getRatingDistrict() {
        // begin-user-code
        if (zipcode == null) {
            return null;
        }
        IRuntimeRepository repository = getHomeProduct().getRepository();
        RatingDistrictTable table = RatingDistrictTable.getInstance(repository);
        RatingDistrictTableRow row = table.findRow(zipcode);
        if (row == null) {
            return "I";
        }
        return row.getRatingDistrict();
        // end-user-code
    }

    /**
     * Returns the range of allowed values for the property livingSpace.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("livingSpace")
    @IpsGenerated
    public ValueSet<Integer> getAllowedValuesForLivingSpace() {
        return getHomeProduct().getAllowedValuesForLivingSpace();
    }

    /**
     * Returns the livingSpace.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAttribute(name = "livingSpace", kind = AttributeKind.CHANGEABLE, valueSetKind = ValueSetKind.Range)
    @IpsConfiguredAttribute(changingOverTime = false)
    @IpsGenerated
    public Integer getLivingSpace() {
        return livingSpace;
    }

    /**
     * Sets the value of attribute livingSpace.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAttributeSetter("livingSpace")
    @IpsGenerated
    public void setLivingSpace(Integer newValue) {
        this.livingSpace = newValue;
    }

    /**
     * Returns the set of allowed values for the property proposedSumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("proposedSumInsured")
    @IpsGenerated
    public ValueSet<Money> getAllowedValuesForProposedSumInsured() {
        return MAX_ALLOWED_VALUES_FOR_PROPOSED_SUM_INSURED;
    }

    /**
     * Returns the proposedSumInsured.
     *
     * @since 1.0
     *
     * @restrainedmodifiable
     */
    @IpsAttribute(name = "proposedSumInsured", kind = AttributeKind.DERIVED_ON_THE_FLY, valueSetKind = ValueSetKind.AllValues)
    @IpsGenerated
    public Money getProposedSumInsured() {
        // begin-user-code
        HomeProduct prod = getHomeProduct();
        if (prod == null) {
            return Money.NULL;
        }
        return prod.getProposedSumInsuredPerSqm().multiply(livingSpace);
        // end-user-code
    }

    /**
     * Returns the range of allowed values for the property sumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("sumInsured")
    @IpsGenerated
    public ValueSet<Money> getAllowedValuesForSumInsured() {
        return getHomeProduct().getAllowedValuesForSumInsured();
    }

    /**
     * Returns the sumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAttribute(name = "sumInsured", kind = AttributeKind.CHANGEABLE, valueSetKind = ValueSetKind.Range)
    @IpsConfiguredAttribute(changingOverTime = false)
    @IpsGenerated
    public Money getSumInsured() {
        return sumInsured;
    }

    /**
     * Sets the value of attribute sumInsured.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAttributeSetter("sumInsured")
    @IpsGenerated
    public void setSumInsured(Money newValue) {
        this.sumInsured = newValue;
    }

    /**
     * Returns the set of allowed values for the property netPremiumPm.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("netPremiumPm")
    @IpsGenerated
    public ValueSet<Money> getAllowedValuesForNetPremiumPm() {
        return MAX_ALLOWED_VALUES_FOR_NET_PREMIUM_PM;
    }

    /**
     * Returns the netPremiumPm.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAttribute(name = "netPremiumPm", kind = AttributeKind.DERIVED_BY_EXPLICIT_METHOD_CALL, valueSetKind = ValueSetKind.AllValues)
    @IpsGenerated
    public Money getNetPremiumPm() {
        return netPremiumPm;
    }

    /**
     * Returns the set of allowed values for the property grossPremiumPm.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("grossPremiumPm")
    @IpsGenerated
    public ValueSet<Money> getAllowedValuesForGrossPremiumPm() {
        return MAX_ALLOWED_VALUES_FOR_GROSS_PREMIUM_PM;
    }

    /**
     * Returns the grossPremiumPm.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAttribute(name = "grossPremiumPm", kind = AttributeKind.DERIVED_BY_EXPLICIT_METHOD_CALL, valueSetKind = ValueSetKind.AllValues)
    @IpsGenerated
    public Money getGrossPremiumPm() {
        return grossPremiumPm;
    }

    /**
     * Returns the set of allowed values for the property annualBasePremium.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("annualBasePremium")
    @IpsGenerated
    public ValueSet<Money> getAllowedValuesForAnnualBasePremium() {
        return MAX_ALLOWED_VALUES_FOR_ANNUAL_BASE_PREMIUM;
    }

    /**
     * Returns the annualBasePremium.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAttribute(name = "annualBasePremium", kind = AttributeKind.DERIVED_BY_EXPLICIT_METHOD_CALL, valueSetKind = ValueSetKind.AllValues)
    @IpsGenerated
    public Money getAnnualBasePremium() {
        return annualBasePremium;
    }

    /**
     * Returns the referenced HomeBaseCoverage.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAssociation(name = "HomeBaseCoverage", pluralName = "HomeBaseCoverages", kind = AssociationKind.Composition, targetClass = HomeBaseCoverage.class, min = 1, max = 1)
    @IpsMatchingAssociation(source = HomeProduct.class, name = "HomeBaseCoverageType")
    @IpsInverseAssociation("HomeContract")
    @IpsGenerated
    public HomeBaseCoverage getHomeBaseCoverage() {
        return homeBaseCoverage;
    }

    /**
     * Sets the HomeBaseCoverage.
     *
     * @throws ClassCastException If the association is constrained and the given object is not of
     *             the correct type.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAssociationAdder(association = "HomeBaseCoverage")
    @IpsGenerated
    public void setHomeBaseCoverage(HomeBaseCoverage newObject) {
        if (homeBaseCoverage != null) {
            homeBaseCoverage.setHomeContractInternal(null);
        }
        if (newObject != null) {
            newObject.setHomeContractInternal(this);
        }
        homeBaseCoverage = newObject;
    }

    /**
     * Creates a new HomeBaseCoverage and adds it as HomeBaseCoverage.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeBaseCoverage newHomeBaseCoverage() {
        HomeBaseCoverage newHomeBaseCoverage = new HomeBaseCoverage();
        setHomeBaseCoverage(newHomeBaseCoverage);
        newHomeBaseCoverage.initialize();
        return newHomeBaseCoverage;
    }

    /**
     * Creates a new HomeBaseCoverage and adds it as HomeBaseCoverage.
     *
     * @param homeBaseCoverageType The product component that configures the new object.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeBaseCoverage newHomeBaseCoverage(HomeBaseCoverageType homeBaseCoverageType) {
        if (homeBaseCoverageType == null) {
            return newHomeBaseCoverage();
        }
        HomeBaseCoverage newHomeBaseCoverage = homeBaseCoverageType.createHomeBaseCoverage();
        setHomeBaseCoverage(newHomeBaseCoverage);
        newHomeBaseCoverage.initialize();
        return newHomeBaseCoverage;
    }

    /**
     * Returns the number of HomeExtraCoverages.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public int getNumOfHomeExtraCoverages() {
        return homeExtraCoverages.size();
    }

    /**
     * Returns <code>true</code> if the given object is referenced in the association, otherwise
     * <code>false</code>.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public boolean containsHomeExtraCoverage(HomeExtraCoverage objectToTest) {
        return homeExtraCoverages.contains(objectToTest);
    }

    /**
     * Returns the referenced HomeExtraCoverages.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAssociation(name = "HomeExtraCoverage", pluralName = "HomeExtraCoverages", kind = AssociationKind.Composition, targetClass = HomeExtraCoverage.class, min = 0, max = Integer.MAX_VALUE)
    @IpsMatchingAssociation(source = HomeProduct.class, name = "HomeExtraCoverageType")
    @IpsInverseAssociation("HomeContract")
    @IpsGenerated
    public List<? extends HomeExtraCoverage> getHomeExtraCoverages() {
        return Collections.unmodifiableList(homeExtraCoverages);
    }

    /**
     * Returns the object at the indexed position from the association HomeExtraCoverage.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeExtraCoverage getHomeExtraCoverage(int index) {
        return homeExtraCoverages.get(index);
    }

    /**
     * Adds the given object as HomeExtraCoverage.
     *
     * @throws ClassCastException If the association is constrained and the given object is not of
     *             the correct type.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAssociationAdder(association = "HomeExtraCoverage")
    @IpsGenerated
    public void addHomeExtraCoverage(HomeExtraCoverage objectToAdd) {
        if (objectToAdd == null) {
            throw new NullPointerException("Can't add null to association HomeExtraCoverage of " + this);
        }
        if (homeExtraCoverages.contains(objectToAdd)) {
            return;
        }
        objectToAdd.setHomeContractInternal(this);
        homeExtraCoverages.add(objectToAdd);
    }

    /**
     * Creates a new HomeExtraCoverage and adds it as HomeExtraCoverage.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeExtraCoverage newHomeExtraCoverage() {
        HomeExtraCoverage newHomeExtraCoverage = new HomeExtraCoverage();
        addHomeExtraCoverage(newHomeExtraCoverage);
        newHomeExtraCoverage.initialize();
        return newHomeExtraCoverage;
    }

    /**
     * Creates a new HomeExtraCoverage and adds it as HomeExtraCoverage.
     *
     * @param homeExtraCoverageType The product component that configures the new object.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeExtraCoverage newHomeExtraCoverage(HomeExtraCoverageType homeExtraCoverageType) {
        if (homeExtraCoverageType == null) {
            return newHomeExtraCoverage();
        }
        HomeExtraCoverage newHomeExtraCoverage = homeExtraCoverageType.createHomeExtraCoverage();
        addHomeExtraCoverage(newHomeExtraCoverage);
        newHomeExtraCoverage.initialize();
        return newHomeExtraCoverage;
    }

    /**
     * Removes the given object from the association HomeExtraCoverage.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAssociationRemover(association = "HomeExtraCoverage")
    @IpsGenerated
    public void removeHomeExtraCoverage(HomeExtraCoverage objectToRemove) {
        if (objectToRemove == null) {
            return;
        }
        if (homeExtraCoverages.remove(objectToRemove)) {
            objectToRemove.setHomeContractInternal(null);
        }
    }

    /**
     * @generated NOT
     */
    public void computePremium() {
        computeAnnualBasePremium();
        computeNetPremiumPm();
        Decimal taxMultiplier = Decimal.valueOf(119, 2); // 1 + 19% tax rate
        grossPremiumPm = netPremiumPm.multiply(taxMultiplier, RoundingMode.HALF_UP);
    }

    private void computeAnnualBasePremium() {
        annualBasePremium = Money.euro(0, 0);
        HomeBaseCoverage baseCoverage = getHomeBaseCoverage();
        baseCoverage.computeAnnualBasePremium();
        annualBasePremium = annualBasePremium.add(baseCoverage.getAnnualBasePremium());
        // Iterate over extra coverages and sum their base premiums
        for (HomeExtraCoverage coverage : getHomeExtraCoverages()) {
            annualBasePremium = annualBasePremium.add(coverage.computeAnnualBasePremium());
        }
    }

    private void computeNetPremiumPm() {
        if (paymentMode == null) {
            netPremiumPm = Money.NULL;
            return;
        }
        if (paymentMode.intValue() == 1) {
            netPremiumPm = annualBasePremium;
        } else {
            Decimal factor = Decimal.valueOf(103, 2); // 1 + 0.03 surcharge for none annual payment
            netPremiumPm = annualBasePremium.multiply(factor, RoundingMode.HALF_UP);
        }
        netPremiumPm = netPremiumPm.divide(paymentMode.intValue(), RoundingMode.HALF_UP);
    }

    /**
     * Initializes the object with the configured defaults.
     *
     * @restrainedmodifiable
     */
    @Override
    @IpsGenerated
    public void initialize() {
        if (getHomeProduct() != null) {
            setPaymentMode(getHomeProduct().getDefaultValuePaymentMode());
            setLivingSpace(getHomeProduct().getDefaultValueLivingSpace());
            setSumInsured(getHomeProduct().getDefaultValueSumInsured());
        }
        // begin-user-code
        // end-user-code
    }

    /**
     * Returns the HomeProduct that configures this object.
     *
     * @generated
     */
    @IpsGenerated
    public HomeProduct getHomeProduct() {
        return (HomeProduct)getProductComponent();
    }

    /**
     * Sets the new HomeProduct that configures this object.
     *
     * @param homeProduct The new HomeProduct.
     * @param initPropertiesWithConfiguratedDefaults <code>true</code> if the properties should be
     *            initialized with the defaults defined in the HomeProduct.
     *
     * @generated
     */
    @IpsGenerated
    public void setHomeProduct(HomeProduct homeProduct, boolean initPropertiesWithConfiguratedDefaults) {
        setProductComponent(homeProduct);
        if (initPropertiesWithConfiguratedDefaults) {
            initialize();
        }
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public IProductComponent getProductComponent() {
        return productConfiguration.getProductComponent();
    }

    /**
     * Sets the current product component.
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public void setProductComponent(IProductComponent productComponent) {
        productConfiguration.setProductComponent(productComponent);
    }

    /**
     * This method is called when the effective from date has changed, so that the reference to the
     * product component generation can be cleared. If this policy component contains child
     * components, this method will also clear the reference to their product component generations.
     * <p>
     * The product component generation is cleared if and only if there is a new effective from
     * date. If {@link #getEffectiveFromAsCalendar()} returns <code>null</code> the product
     * component generation is not reset, for example if this model object was removed from its
     * parent.
     * <p>
     * Clients may change the behavior of resetting the product component by overwriting
     * {@link #resetProductCmptGenerationAfterEffectiveFromHasChanged()} instead of this method.
     *
     * @generated
     */
    @IpsGenerated
    public void effectiveFromHasChanged() {
        if (getEffectiveFromAsCalendar() != null) {
            resetProductCmptGenerationAfterEffectiveFromHasChanged();
        }
        if (homeBaseCoverage != null) {
            homeBaseCoverage.effectiveFromHasChanged();
        }
        for (Iterator<HomeExtraCoverage> it = homeExtraCoverages.iterator(); it.hasNext();) {
            HomeExtraCoverage child = it.next();
            child.effectiveFromHasChanged();
        }
    }

    /**
     * Clears the product component generation.
     * <p>
     * This method can be overwritten to affect the behavior in case of an effective-date change.
     *
     * @generated
     */
    @IpsGenerated
    protected void resetProductCmptGenerationAfterEffectiveFromHasChanged() {
        productConfiguration.resetProductCmptGeneration();
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public Calendar getEffectiveFromAsCalendar() {
        // TODO Implement access to effective from.
        // To avoid that the generator overwrites the implementation,
        // you have to add NOT after @generated in the Javadoc!
        return null;
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    protected void initFromXml(Element objectEl,
            boolean initWithProductDefaultsBeforeReadingXmlData,
            IRuntimeRepository productRepository,
            IObjectReferenceStore store,
            XmlCallback xmlCallback,
            String currPath) {
        productConfiguration.initFromXml(objectEl, productRepository);
        if (initWithProductDefaultsBeforeReadingXmlData) {
            initialize();
        }
        super.initFromXml(objectEl, initWithProductDefaultsBeforeReadingXmlData, productRepository, store, xmlCallback,
                currPath);
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    protected void initPropertiesFromXml(Map<String, String> propMap, IRuntimeRepository productRepository) {
        super.initPropertiesFromXml(propMap, productRepository);
        doInitPaymentMode(propMap);
        doInitZipcode(propMap);
        doInitLivingSpace(propMap);
        doInitSumInsured(propMap);
        doInitNetPremiumPm(propMap);
        doInitGrossPremiumPm(propMap);
        doInitAnnualBasePremium(propMap);
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitPaymentMode(Map<String, String> propMap) {
        if (propMap.containsKey(PROPERTY_PAYMENTMODE)) {
            this.paymentMode = IpsStringUtils.isEmpty(propMap.get(PROPERTY_PAYMENTMODE)) ? null
                    : Integer.valueOf(propMap.get(PROPERTY_PAYMENTMODE));
        }
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitZipcode(Map<String, String> propMap) {
        if (propMap.containsKey(PROPERTY_ZIPCODE)) {
            this.zipcode = propMap.get(PROPERTY_ZIPCODE);
        }
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitLivingSpace(Map<String, String> propMap) {
        if (propMap.containsKey(PROPERTY_LIVINGSPACE)) {
            this.livingSpace = IpsStringUtils.isEmpty(propMap.get(PROPERTY_LIVINGSPACE)) ? null
                    : Integer.valueOf(propMap.get(PROPERTY_LIVINGSPACE));
        }
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitSumInsured(Map<String, String> propMap) {
        if (propMap.containsKey(PROPERTY_SUMINSURED)) {
            this.sumInsured = Money.valueOf(propMap.get(PROPERTY_SUMINSURED));
        }
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitNetPremiumPm(Map<String, String> propMap) {
        if (propMap.containsKey(PROPERTY_NETPREMIUMPM)) {
            this.netPremiumPm = Money.valueOf(propMap.get(PROPERTY_NETPREMIUMPM));
        }
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitGrossPremiumPm(Map<String, String> propMap) {
        if (propMap.containsKey(PROPERTY_GROSSPREMIUMPM)) {
            this.grossPremiumPm = Money.valueOf(propMap.get(PROPERTY_GROSSPREMIUMPM));
        }
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitAnnualBasePremium(Map<String, String> propMap) {
        if (propMap.containsKey(PROPERTY_ANNUALBASEPREMIUM)) {
            this.annualBasePremium = Money.valueOf(propMap.get(PROPERTY_ANNUALBASEPREMIUM));
        }
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    protected AbstractModelObject createChildFromXml(Element childEl) {
        AbstractModelObject newChild = super.createChildFromXml(childEl);
        if (newChild != null) {
            return newChild;
        }
        if ("HomeBaseCoverage".equals(childEl.getNodeName())) {
            return doInitHomeBaseCoverage(childEl);
        }
        if ("HomeExtraCoverage".equals(childEl.getNodeName())) {
            return doInitHomeExtraCoverage(childEl);
        }
        return null;
    }

    /**
     * @generated
     */
    @IpsGenerated
    private AbstractModelObject doInitHomeBaseCoverage(Element childEl) {
        String className = childEl.getAttribute("class");
        if (className.length() > 0) {
            try {
                HomeBaseCoverage homeBaseCoverageLocalVar = (HomeBaseCoverage)Class.forName(className).getConstructor()
                        .newInstance();
                setHomeBaseCoverage(homeBaseCoverageLocalVar);
                return homeBaseCoverageLocalVar;
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return newHomeBaseCoverage();
    }

    /**
     * @generated
     */
    @IpsGenerated
    private AbstractModelObject doInitHomeExtraCoverage(Element childEl) {
        String className = childEl.getAttribute("class");
        if (className.length() > 0) {
            try {
                HomeExtraCoverage homeExtraCoverageLocalVar = (HomeExtraCoverage)Class.forName(className)
                        .getConstructor().newInstance();
                addHomeExtraCoverage(homeExtraCoverageLocalVar);
                return homeExtraCoverageLocalVar;
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return newHomeExtraCoverage();
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public IModelObjectDelta computeDelta(IModelObject otherObject, IDeltaComputationOptions options) {
        ModelObjectDelta delta = ModelObjectDelta.newDelta(this, otherObject, options);
        if (!HomeContract.class.isAssignableFrom(otherObject.getClass())) {
            return delta;
        }
        HomeContract otherHomeContract = (HomeContract)otherObject;
        delta.checkPropertyChange(HomeContract.PROPERTY_PAYMENTMODE, paymentMode, otherHomeContract.paymentMode,
                options);
        delta.checkPropertyChange(HomeContract.PROPERTY_ZIPCODE, zipcode, otherHomeContract.zipcode, options);
        delta.checkPropertyChange(HomeContract.PROPERTY_LIVINGSPACE, livingSpace, otherHomeContract.livingSpace,
                options);
        delta.checkPropertyChange(HomeContract.PROPERTY_SUMINSURED, sumInsured, otherHomeContract.sumInsured, options);
        delta.checkPropertyChange(HomeContract.PROPERTY_NETPREMIUMPM, netPremiumPm, otherHomeContract.netPremiumPm,
                options);
        delta.checkPropertyChange(HomeContract.PROPERTY_GROSSPREMIUMPM, grossPremiumPm,
                otherHomeContract.grossPremiumPm, options);
        delta.checkPropertyChange(HomeContract.PROPERTY_ANNUALBASEPREMIUM, annualBasePremium,
                otherHomeContract.annualBasePremium, options);
        ModelObjectDelta.createChildDeltas(delta, homeBaseCoverage, otherHomeContract.homeBaseCoverage,
                ASSOCIATION_HOME_BASE_COVERAGE, options);
        ModelObjectDelta.createChildDeltas(delta, homeExtraCoverages, otherHomeContract.homeExtraCoverages,
                ASSOCIATION_HOME_EXTRA_COVERAGES, options);
        return delta;
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public HomeContract newCopy() {
        Map<IModelObject, IModelObject> copyMap = new HashMap<>();
        HomeContract newCopy = newCopyInternal(copyMap);
        copyAssociationsInternal(newCopy, copyMap);
        return newCopy;
    }

    /**
     * Internal copy method with a {@link Map} containing already copied instances.
     *
     * @param copyMap the map contains the copied instances
     *
     * @generated
     */
    @IpsGenerated
    public HomeContract newCopyInternal(Map<IModelObject, IModelObject> copyMap) {
        HomeContract newCopy = (HomeContract)copyMap.get(this);
        if (newCopy == null) {
            newCopy = new HomeContract();
            copyMap.put(this, newCopy);
            newCopy.copyProductCmptAndGenerationInternal(this);
            copyProperties(newCopy, copyMap);
        }
        return newCopy;
    }

    /**
     * Copies the product component and product component generation from the other object.
     *
     * @generated
     */
    @IpsGenerated
    protected void copyProductCmptAndGenerationInternal(HomeContract otherObject) {
        productConfiguration.copy(otherObject.productConfiguration);
    }

    /**
     * This method sets all properties in the copy with the values of this object. If there are
     * copied associated objects they are added to the copyMap in {@link #newCopyInternal(Map)}.
     *
     * @param copy The copy object
     * @param copyMap a map containing copied associated objects
     *
     * @generated
     */
    @IpsGenerated
    protected void copyProperties(IModelObject copy, Map<IModelObject, IModelObject> copyMap) {
        HomeContract concreteCopy = (HomeContract)copy;
        concreteCopy.paymentMode = paymentMode;
        concreteCopy.zipcode = zipcode;
        concreteCopy.livingSpace = livingSpace;
        concreteCopy.sumInsured = sumInsured;
        concreteCopy.netPremiumPm = netPremiumPm;
        concreteCopy.grossPremiumPm = grossPremiumPm;
        concreteCopy.annualBasePremium = annualBasePremium;
        if (homeBaseCoverage != null) {
            concreteCopy.homeBaseCoverage = homeBaseCoverage.newCopyInternal(copyMap);
            concreteCopy.homeBaseCoverage.setHomeContractInternal(concreteCopy);
        }
        for (Iterator<HomeExtraCoverage> it = homeExtraCoverages.iterator(); it.hasNext();) {
            HomeExtraCoverage homeExtraCoverage = it.next();
            HomeExtraCoverage copyHomeExtraCoverage = homeExtraCoverage.newCopyInternal(copyMap);
            copyHomeExtraCoverage.setHomeContractInternal(concreteCopy);
            concreteCopy.homeExtraCoverages.add(copyHomeExtraCoverage);
        }
    }

    /**
     * Internal method for setting copied associations. For copied targets, the associations have to
     * be retargeted to the new copied instances. This method have to call
     * {@link #copyAssociationsInternal(IModelObject, Map)} in other instances associated by
     * composite.
     *
     * @param abstractCopy the copy of this policy component
     * @param copyMap the map contains the copied instances
     *
     * @generated
     */
    @IpsGenerated
    public void copyAssociationsInternal(IModelObject abstractCopy, Map<IModelObject, IModelObject> copyMap) {
        if (homeBaseCoverage != null) {
            HomeBaseCoverage copyHomeBaseCoverage = (HomeBaseCoverage)copyMap.get(homeBaseCoverage);
            homeBaseCoverage.copyAssociationsInternal(copyHomeBaseCoverage, copyMap);
        }
        for (HomeExtraCoverage homeExtraCoverage : homeExtraCoverages) {
            HomeExtraCoverage copyHomeExtraCoverage = (HomeExtraCoverage)copyMap.get(homeExtraCoverage);
            homeExtraCoverage.copyAssociationsInternal(copyHomeExtraCoverage, copyMap);
        }
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public boolean accept(IModelObjectVisitor visitor) {
        if (!visitor.visit(this)) {
            return false;
        }
        if (homeBaseCoverage != null) {
            homeBaseCoverage.accept(visitor);
        }
        for (HomeExtraCoverage homeExtraCoverage : homeExtraCoverages) {
            homeExtraCoverage.accept(visitor);
        }
        return true;
    }

    /**
     * Validates the object (but not its children). Returns <code>true</code> if this object should
     * continue validating, <code>false</code> otherwise.
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public boolean validateSelf(MessageList ml, IValidationContext context) {
        if (!super.validateSelf(ml, context)) {
            return STOP_VALIDATION;
        }
        return CONTINUE_VALIDATION;
    }

    /**
     * Validates the object's children.
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public void validateDependants(MessageList ml, IValidationContext context) {
        super.validateDependants(ml, context);
        if (homeBaseCoverage != null) {
            ml.add(homeBaseCoverage.validate(context));
        }
        if (getNumOfHomeExtraCoverages() > 0) {
            for (HomeExtraCoverage rel : getHomeExtraCoverages()) {
                ml.add(rel.validate(context));
            }
        }
    }

    /**
     * @restrainedmodifiable
     */
    @Override
    @IpsGenerated
    public String toString() {
        // begin-user-code
        return getProductComponent() == null ? getClass().getSimpleName()
                : getClass().getSimpleName() + '[' + getProductComponent().toString() + ']';
        // end-user-code
    }

    /**
     * Creates a new instance of HomeContractBuilder to edit this policy.
     *
     * @generated
     */
    @IpsGenerated
    public HomeContractBuilder modify() {
        return HomeContractBuilder.from(this, getProductComponent().getRepository());
    }

    /**
     * The runtime repository is used to create configured association targets from existing product
     * components.
     *
     * @generated
     */
    @IpsGenerated
    public HomeContractBuilder modify(IRuntimeRepository runtimeRepository) {
        return HomeContractBuilder.from(this, runtimeRepository);
    }

    /**
     * Creates a new HomeContractBuilder with a new instance of policy. Runtime repository is set to
     * null.
     *
     * @generated
     */
    @IpsGenerated
    public static HomeContractBuilder builder() {
        return HomeContractBuilder.from(new HomeContract(), null);
    }

    /**
     * Creates a new HomeContractBuilder with a new instance of policy. Runtime repository is set to
     * null. The runtime repository is required as association targets exists that are configured by
     * a product. The product components of the targets must be in the given runtime repository.
     *
     * @generated
     */
    @IpsGenerated
    public static HomeContractBuilder builder(IRuntimeRepository runtimeRepository) {
        return HomeContractBuilder.from(new HomeContract(), runtimeRepository);
    }

    /**
     * Creates a new HomeContractBuilder with a new instance of policy created by the given product
     * component.
     *
     * @generated
     */
    @IpsGenerated
    public static HomeContractBuilder builder(HomeProduct productCmpt) {
        return HomeContractBuilder.from(new HomeContract(productCmpt), productCmpt.getRepository());
    }

    /**
     * Creates a new HomeContractBuilder with a new instance of policy created by the product
     * component with the given ID in the runtime repository that configures the policy.
     *
     * @generated
     */
    @IpsGenerated
    public static HomeContractBuilder builder(IRuntimeRepository runtimeRepository, String productCmptId) {
        HomeProduct product = (HomeProduct)runtimeRepository.getProductComponent(productCmptId);
        if (product == null) {
            throw new RuntimeException("No product component found with given ID!");
        } else {
            HomeContract policy = product.createHomeContract();

            policy.initialize();
            return HomeContractBuilder.from(policy, runtimeRepository);
        }
    }

}
