package org.faktorips.tutorial.model.home;

import org.faktorips.runtime.IModifiableRuntimeRepository;
import org.faktorips.runtime.annotation.IpsGenerated;

/**
 * Implementation of HomeBaseCoverageTypeBuilder. A HomeBaseCoverageTypeBuilder provides all
 * functionalities that are needed to edit a HomeBaseCoverageType. Note that this is only for
 * testing purpose. All instances of product have to be created in a new
 * {@link IModifiableRuntimeRepository} as Product Component in the runtime repository can not be
 * edited.
 *
 * @since 1.0
 *
 * @generated
 */
public class HomeBaseCoverageTypeBuilder {
    /**
     * @generated
     */
    private final IModifiableRuntimeRepository runtimeRepository;

    /**
     * @generated
     */
    private final HomeBaseCoverageType homeBaseCoverageType;

    /**
     * Generates a new instance of HomeBaseCoverageTypeBuilder with a given product. The product
     * must exist in the given {@link IModifiableRuntimeRepository} that is not allowed to be null.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    protected HomeBaseCoverageTypeBuilder(HomeBaseCoverageType product,
            IModifiableRuntimeRepository runtimeRepository) {
        if (product == null || runtimeRepository == null) {
            throw new RuntimeException("Product and repository can not be null!");
        } else {
            runtimeRepository.getExistingProductComponent(product.getId());

            this.runtimeRepository = runtimeRepository;
            this.homeBaseCoverageType = product;
        }
    }

    /**
     * Sets the value of attribute name.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeBaseCoverageTypeBuilder name(String name) {
        homeBaseCoverageType.setName(name);
        return this;
    }

    /**
     * @return {@link IModifiableRuntimeRepository} that is saved.
     *
     * @generated
     */
    @IpsGenerated
    public IModifiableRuntimeRepository getRepository() {
        return this.runtimeRepository;
    }

    /**
     * @return instance of HomeBaseCoverageType that is built.
     *
     * @generated
     */
    @IpsGenerated
    public HomeBaseCoverageType getResult() {
        return homeBaseCoverageType;
    }

    /**
     * Interne Methode
     *
     * @generated
     */
    @IpsGenerated
    public static Class<?> getProductClass() {
        return HomeBaseCoverageType.class;
    }

    /**
     * Creates a new HomeBaseCoverageTypeBuilder with a given HomeBaseCoverageType and a runtime
     * repository.
     *
     * @generated
     */
    @IpsGenerated
    public static HomeBaseCoverageTypeBuilder from(HomeBaseCoverageType product,
            IModifiableRuntimeRepository runtimeRepository) {
        return new HomeBaseCoverageTypeBuilder(product, runtimeRepository);
    }

}
