package org.faktorips.tutorial.model.home;

import org.faktorips.runtime.model.annotation.IpsProductCmptType;
import org.faktorips.runtime.model.annotation.IpsAttributes;
import org.faktorips.runtime.model.annotation.IpsConfigures;
import org.faktorips.runtime.model.annotation.IpsTableUsages;
import org.faktorips.runtime.model.annotation.IpsDocumented;
import org.faktorips.runtime.internal.ProductComponent;
import org.faktorips.runtime.model.annotation.IpsAllowedValues;
import org.faktorips.valueset.ValueSet;
import org.faktorips.valueset.UnrestrictedValueSet;
import org.faktorips.runtime.model.annotation.IpsDefaultValue;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.model.annotation.IpsAttribute;
import org.faktorips.runtime.model.type.AttributeKind;
import org.faktorips.runtime.model.type.ValueSetKind;
import org.faktorips.runtime.model.annotation.IpsAttributeSetter;
import org.faktorips.runtime.IllegalRepositoryModificationException;
import org.faktorips.runtime.model.annotation.IpsTableUsage;
import org.w3c.dom.Element;
import java.util.Map;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.faktorips.runtime.IModifiableRuntimeRepository;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.annotation.IpsGenerated;

/**
 * Implementation for HomeBaseCoverageType.
 *
 * @since 1.0
 *
 * @generated
 */
@IpsProductCmptType(name = "home.HomeBaseCoverageType")
@IpsAttributes({ "name" })
@IpsConfigures(HomeBaseCoverage.class)
@IpsTableUsages({ "rateTable" })
@IpsDocumented(bundleName = "org.faktorips.tutorial.model.model-label-and-descriptions", defaultLocale = "en")
public class HomeBaseCoverageType extends ProductComponent {

    /**
     * The name of the property name.
     *
     * @since 1.0
     *
     * @generated
     */
    public static final String PROPERTY_NAME = "name";
    /**
     * Max allowed values for property name.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("name")
    public static final ValueSet<String> MAX_ALLOWED_VALUES_FOR_NAME = new UnrestrictedValueSet<>(true);
    /**
     * The default value for name.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsDefaultValue("name")
    public static final String DEFAULT_VALUE_FOR_NAME = null;
    /**
     * The product component property Name.
     *
     * @since 1.0
     *
     * @generated
     */
    private String name = DEFAULT_VALUE_FOR_NAME;

    /**
     * The property name of the table rateTable.
     *
     * @since 1.0
     *
     * @generated
     */
    public static final String TABLE_RATE_TABLE = "rateTable";
    /**
     * The name of the table used as rateTable.
     *
     * @since 1.0
     *
     * @generated
     */
    private String rateTableName = null;

    /**
     * Creates a new HomeBaseCoverageType.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeBaseCoverageType(IRuntimeRepository repository, String id, String kindId, String versionId) {
        super(repository, id, kindId, versionId);
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public boolean isChangingOverTime() {
        return false;
    }

    /**
     * Returns the value of name.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAttribute(name = "name", kind = AttributeKind.CONSTANT, valueSetKind = ValueSetKind.AllValues)
    @IpsGenerated
    public String getName() {
        return name;
    }

    /**
     * Sets the value of attribute name.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAttributeSetter("name")
    @IpsGenerated
    public void setName(String newValue) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        setNameInternal(newValue);
    }

    /**
     * Sets the value of attribute name.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    protected final void setNameInternal(String newValue) {
        this.name = newValue;
    }

    /**
     * Returns the name of the table used as rateTable.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public String getRateTableName() {
        return rateTableName;
    }

    /**
     * Returns the table used as rateTable.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsTableUsage(name = "rateTable", required = true, tableClasses = RateTableHome.class)
    @IpsGenerated
    public RateTableHome getRateTable() {
        if (rateTableName == null) {
            return null;
        }
        return (RateTableHome)getRepository().getTable(rateTableName);
    }

    /**
     * Sets the name of the table used as RateTableName.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public void setRateTableName(String tableName) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        this.rateTableName = tableName;
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    protected void doInitPropertiesFromXml(Map<String, Element> configMap) {
        super.doInitPropertiesFromXml(configMap);
        doInitName(configMap);
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitName(Map<String, Element> configMap) {
        Element configElement = configMap.get(PROPERTY_NAME);
        if (configElement != null) {
            String value = ValueToXmlHelper.getValueFromElement(configElement, ValueToXmlHelper.XML_TAG_VALUE);
            this.name = value;
        }
    }

    /**
     * @generated
     */
    @Override
    @IpsGenerated
    protected void doInitTableUsagesFromXml(Map<String, Element> tableUsageMap) {
        super.doInitTableUsagesFromXml(tableUsageMap);
        doInitRateTable(tableUsageMap);
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitRateTable(Map<String, Element> tableUsageMap) {
        Element element = tableUsageMap.get(TABLE_RATE_TABLE);
        if (element != null) {
            rateTableName = ValueToXmlHelper.getValueFromElement(element, ValueToXmlHelper.XML_TAG_TABLE_CONTENT_NAME);
        }
    }

    /**
     * Creates a new HomeBaseCoverage that is configured.
     *
     * @generated
     */
    @IpsGenerated
    public HomeBaseCoverage createHomeBaseCoverage() {
        HomeBaseCoverage policy = new HomeBaseCoverage(this);
        policy.initialize();
        return policy;
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public HomeBaseCoverage createPolicyComponent() {
        return createHomeBaseCoverage();
    }

    /**
     * Creates a new instance of HomeBaseCoverageTypeBuilder to edit this product.
     *
     * @generated
     */
    @IpsGenerated
    public HomeBaseCoverageTypeBuilder modify() {
        return HomeBaseCoverageTypeBuilder.from(this, (IModifiableRuntimeRepository)this.getRepository());
    }

    /**
     * Generates a new instance of HomeBaseCoverageType with a given
     * {@link IModifiableRuntimeRepository}, ID, kindID and versionID. The new product is set to be
     * valid from 1900/1/1.
     *
     * @generated
     */
    @IpsGenerated
    public static HomeBaseCoverageTypeBuilder builder(IModifiableRuntimeRepository runtimeRepository,
            String id,
            String kindId,
            String versionId) {
        HomeBaseCoverageType product = new HomeBaseCoverageType(runtimeRepository, id, kindId, versionId);
        product.setValidFrom(new DateTime(1900, 1, 1));
        runtimeRepository.putProductComponent(product);

        return new HomeBaseCoverageTypeBuilder(product, runtimeRepository);
    }

    /**
     * Generates a new instance of HomeBaseCoverageType with a given
     * {@link IModifiableRuntimeRepository}, ID, kindID and versionID.
     *
     * @generated
     */
    @IpsGenerated
    public static HomeBaseCoverageTypeBuilder builder(IModifiableRuntimeRepository runtimeRepository,
            String id,
            String kindId,
            String versionId,
            DateTime validFrom) {
        HomeBaseCoverageType product = new HomeBaseCoverageType(runtimeRepository, id, kindId, versionId);
        product.setValidFrom(validFrom);
        runtimeRepository.putProductComponent(product);

        return new HomeBaseCoverageTypeBuilder(product, runtimeRepository);
    }

    /**
     * Generates a new instance of HomeBaseCoverageType with the ID of an existing product
     * component.
     *
     * @generated
     */
    @IpsGenerated
    public static HomeBaseCoverageTypeBuilder builder(IModifiableRuntimeRepository runtimeRepository,
            String prodCmptId) {
        HomeBaseCoverageType product = (HomeBaseCoverageType)runtimeRepository.getProductComponent(prodCmptId);

        if (product == null) {
            throw new RuntimeException("No product component found with given ID!");
        } else {
            return HomeBaseCoverageTypeBuilder.from(product, runtimeRepository);
        }
    }
}
