package org.faktorips.tutorial.model.home;

import java.math.RoundingMode;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

import org.faktorips.runtime.IConfigurableModelObject;
import org.faktorips.valueset.ValueSet;
import org.faktorips.runtime.ICopySupport;
import org.faktorips.runtime.IDeltaComputationOptions;
import org.faktorips.runtime.IDeltaSupport;
import org.faktorips.runtime.IDependantObject;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IModelObjectDelta;
import org.faktorips.runtime.IModelObjectVisitor;
import org.faktorips.runtime.IObjectReferenceStore;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.IValidationContext;
import org.faktorips.runtime.IVisitorSupport;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.annotation.IpsGenerated;
import org.faktorips.runtime.internal.AbstractModelObject;
import org.faktorips.runtime.internal.ModelObjectDelta;
import org.faktorips.runtime.internal.ProductConfiguration;
import org.faktorips.runtime.model.annotation.IpsAllowedValues;
import org.faktorips.runtime.internal.XmlCallback;
import org.faktorips.runtime.model.annotation.IpsAssociation;
import org.faktorips.runtime.model.annotation.IpsAssociationAdder;
import org.faktorips.runtime.model.annotation.IpsAssociations;
import org.faktorips.runtime.model.annotation.IpsAttribute;
import org.faktorips.runtime.model.annotation.IpsAttributes;
import org.faktorips.runtime.model.annotation.IpsConfiguredBy;
import org.faktorips.runtime.model.annotation.IpsDocumented;
import org.faktorips.runtime.model.annotation.IpsInverseAssociation;
import org.faktorips.runtime.model.annotation.IpsPolicyCmptType;
import org.faktorips.runtime.model.type.AssociationKind;
import org.faktorips.runtime.model.type.AttributeKind;
import org.faktorips.runtime.model.type.ValueSetKind;
import org.faktorips.values.Decimal;
import org.faktorips.values.Money;
import org.faktorips.valueset.UnrestrictedValueSet;
import org.faktorips.runtime.model.annotation.IpsDefaultValue;
import org.w3c.dom.Element;

/**
 * Implementation for HomeBaseCoverage.
 *
 * @since 1.0
 *
 * @generated
 */
@IpsPolicyCmptType(name = "home.HomeBaseCoverage")
@IpsAttributes({ "annualBasePremium" })
@IpsAssociations({ "HomeContract" })
@IpsConfiguredBy(HomeBaseCoverageType.class)
@IpsDocumented(bundleName = "org.faktorips.tutorial.model.model-label-and-descriptions", defaultLocale = "en")
public class HomeBaseCoverage extends AbstractModelObject
        implements IDeltaSupport, ICopySupport, IVisitorSupport, IDependantObject, IConfigurableModelObject {

    /**
     * The name of the association homeContract.
     *
     * @since 1.0
     *
     * @generated
     */
    public static final String ASSOCIATION_HOME_CONTRACT = "homeContract";
    /**
     * The name of the property annualBasePremium.
     *
     * @since 1.0
     *
     * @generated
     */
    public static final String PROPERTY_ANNUALBASEPREMIUM = "annualBasePremium";
    /**
     * Max allowed values for property annualBasePremium.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("annualBasePremium")
    public static final ValueSet<Money> MAX_ALLOWED_VALUES_FOR_ANNUAL_BASE_PREMIUM = new UnrestrictedValueSet<>(true);
    /**
     * The default value for annualBasePremium.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsDefaultValue("annualBasePremium")
    public static final Money DEFAULT_VALUE_FOR_ANNUAL_BASE_PREMIUM = Money.NULL;
    /**
     * Member variable for annualBasePremium.
     *
     * @since 1.0
     *
     * @generated
     */
    private Money annualBasePremium = DEFAULT_VALUE_FOR_ANNUAL_BASE_PREMIUM;
    /**
     * References the current product configuration.
     *
     * @generated
     */
    private ProductConfiguration productConfiguration;
    /**
     * Member variable for the parent object: HomeContract.
     *
     * @since 1.0
     *
     * @generated
     */
    private HomeContract homeContract;

    /**
     * Creates a new HomeBaseCoverage.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeBaseCoverage() {
        super();
        productConfiguration = new ProductConfiguration();
    }

    /**
     * Creates a new HomeBaseCoverage.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public HomeBaseCoverage(HomeBaseCoverageType productCmpt) {
        super();
        productConfiguration = new ProductConfiguration(productCmpt);
    }

    /**
     * Returns the set of allowed values for the property annualBasePremium.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAllowedValues("annualBasePremium")
    @IpsGenerated
    public ValueSet<Money> getAllowedValuesForAnnualBasePremium() {
        return MAX_ALLOWED_VALUES_FOR_ANNUAL_BASE_PREMIUM;
    }

    /**
     * Returns the annualBasePremium.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAttribute(name = "annualBasePremium", kind = AttributeKind.DERIVED_BY_EXPLICIT_METHOD_CALL, valueSetKind = ValueSetKind.AllValues)
    @IpsGenerated
    public Money getAnnualBasePremium() {
        return annualBasePremium;
    }

    /**
     * Returns the referenced HomeContract.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsAssociation(name = "HomeContract", pluralName = "HomeContracts", kind = AssociationKind.CompositionToMaster, targetClass = HomeContract.class, min = 0, max = 1)
    @IpsInverseAssociation("HomeBaseCoverage")
    @IpsGenerated
    public HomeContract getHomeContract() {
        return homeContract;
    }

    /**
     * @since 1.0
     *
     * @generated
     */
    @IpsAssociationAdder(association = "HomeContract")
    @IpsGenerated
    public void setHomeContractInternal(HomeContract newParent) {
        if (getHomeContract() == newParent) {
            return;
        }
        IModelObject parent = getParentModelObject();
        if (newParent != null && parent != null) {
            throw new IllegalStateException(String.format(
                    "HomeBaseCoverage (\"%s\") can't be assigned to parent object of class HomeContract (\"%s\"), because object already belongs to the parent object (\"%s\").",
                    toString(), newParent.toString(), parent.toString()));
        }
        this.homeContract = newParent;
        effectiveFromHasChanged();
    }

    /**
     * @since 1.0
     *
     * @generated NOT
     */
    public void computeAnnualBasePremium() {
        RateTableHome table = getRateTable();
        RateTableHomeRow row = null;
        if (table != null) {
            row = table.findRow(getHomeContract().getRatingDistrict());
        }
        if (row == null) {
            annualBasePremium = Money.NULL;
            return;
        }
        Money si = getHomeContract().getSumInsured();
        Decimal premiumRate = row.getPremiumRate();
        annualBasePremium = si.divide(1000, RoundingMode.HALF_UP).multiply(premiumRate, RoundingMode.HALF_UP);
    }

    /**
     * Returns the table rateTable referenced by the corresponding product component.
     *
     * @since 1.0
     *
     * @generated
     */
    @IpsGenerated
    public RateTableHome getRateTable() {
        HomeBaseCoverageType productCmpt = getHomeBaseCoverageType();
        if (productCmpt == null) {
            return null;
        }
        return productCmpt.getRateTable();
    }

    /**
     * Initializes the object with the configured defaults.
     *
     * @restrainedmodifiable
     */
    @Override
    @IpsGenerated
    public void initialize() {
        // begin-user-code
        // end-user-code
    }

    /**
     * Returns the HomeBaseCoverageType that configures this object.
     *
     * @generated
     */
    @IpsGenerated
    public HomeBaseCoverageType getHomeBaseCoverageType() {
        return (HomeBaseCoverageType)getProductComponent();
    }

    /**
     * Sets the new HomeBaseCoverageType that configures this object.
     *
     * @param homeBaseCoverageType The new HomeBaseCoverageType.
     * @param initPropertiesWithConfiguratedDefaults <code>true</code> if the properties should be
     *            initialized with the defaults defined in the HomeBaseCoverageType.
     *
     * @generated
     */
    @IpsGenerated
    public void setHomeBaseCoverageType(HomeBaseCoverageType homeBaseCoverageType,
            boolean initPropertiesWithConfiguratedDefaults) {
        setProductComponent(homeBaseCoverageType);
        if (initPropertiesWithConfiguratedDefaults) {
            initialize();
        }
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public IProductComponent getProductComponent() {
        return productConfiguration.getProductComponent();
    }

    /**
     * Sets the current product component.
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public void setProductComponent(IProductComponent productComponent) {
        productConfiguration.setProductComponent(productComponent);
    }

    /**
     * This method is called when the effective from date has changed, so that the reference to the
     * product component generation can be cleared. If this policy component contains child
     * components, this method will also clear the reference to their product component generations.
     * <p>
     * The product component generation is cleared if and only if there is a new effective from
     * date. If {@link #getEffectiveFromAsCalendar()} returns <code>null</code> the product
     * component generation is not reset, for example if this model object was removed from its
     * parent.
     * <p>
     * Clients may change the behavior of resetting the product component by overwriting
     * {@link #resetProductCmptGenerationAfterEffectiveFromHasChanged()} instead of this method.
     *
     * @generated
     */
    @IpsGenerated
    public void effectiveFromHasChanged() {
        if (getEffectiveFromAsCalendar() != null) {
            resetProductCmptGenerationAfterEffectiveFromHasChanged();
        }
    }

    /**
     * Clears the product component generation.
     * <p>
     * This method can be overwritten to affect the behavior in case of an effective-date change.
     *
     * @generated
     */
    @IpsGenerated
    protected void resetProductCmptGenerationAfterEffectiveFromHasChanged() {
        productConfiguration.resetProductCmptGeneration();
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public Calendar getEffectiveFromAsCalendar() {
        IModelObject parent = getParentModelObject();
        if (parent instanceof IConfigurableModelObject) {
            return ((IConfigurableModelObject)parent).getEffectiveFromAsCalendar();
        }
        return null;
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public IModelObject getParentModelObject() {
        if (homeContract != null) {
            return homeContract;
        }
        return null;
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    protected void initFromXml(Element objectEl,
            boolean initWithProductDefaultsBeforeReadingXmlData,
            IRuntimeRepository productRepository,
            IObjectReferenceStore store,
            XmlCallback xmlCallback,
            String currPath) {
        productConfiguration.initFromXml(objectEl, productRepository);
        if (initWithProductDefaultsBeforeReadingXmlData) {
            initialize();
        }
        super.initFromXml(objectEl, initWithProductDefaultsBeforeReadingXmlData, productRepository, store, xmlCallback,
                currPath);
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    protected void initPropertiesFromXml(Map<String, String> propMap, IRuntimeRepository productRepository) {
        super.initPropertiesFromXml(propMap, productRepository);
        doInitAnnualBasePremium(propMap);
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitAnnualBasePremium(Map<String, String> propMap) {
        if (propMap.containsKey(PROPERTY_ANNUALBASEPREMIUM)) {
            this.annualBasePremium = Money.valueOf(propMap.get(PROPERTY_ANNUALBASEPREMIUM));
        }
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    protected AbstractModelObject createChildFromXml(Element childEl) {
        AbstractModelObject newChild = super.createChildFromXml(childEl);
        if (newChild != null) {
            return newChild;
        }
        return null;
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public IModelObjectDelta computeDelta(IModelObject otherObject, IDeltaComputationOptions options) {
        ModelObjectDelta delta = ModelObjectDelta.newDelta(this, otherObject, options);
        if (!HomeBaseCoverage.class.isAssignableFrom(otherObject.getClass())) {
            return delta;
        }
        HomeBaseCoverage otherHomeBaseCoverage = (HomeBaseCoverage)otherObject;
        delta.checkPropertyChange(HomeBaseCoverage.PROPERTY_ANNUALBASEPREMIUM, annualBasePremium,
                otherHomeBaseCoverage.annualBasePremium, options);
        return delta;
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public HomeBaseCoverage newCopy() {
        Map<IModelObject, IModelObject> copyMap = new HashMap<>();
        HomeBaseCoverage newCopy = newCopyInternal(copyMap);
        copyAssociationsInternal(newCopy, copyMap);
        return newCopy;
    }

    /**
     * Internal copy method with a {@link Map} containing already copied instances.
     *
     * @param copyMap the map contains the copied instances
     *
     * @generated
     */
    @IpsGenerated
    public HomeBaseCoverage newCopyInternal(Map<IModelObject, IModelObject> copyMap) {
        HomeBaseCoverage newCopy = (HomeBaseCoverage)copyMap.get(this);
        if (newCopy == null) {
            newCopy = new HomeBaseCoverage();
            copyMap.put(this, newCopy);
            newCopy.copyProductCmptAndGenerationInternal(this);
            copyProperties(newCopy, copyMap);
        }
        return newCopy;
    }

    /**
     * Copies the product component and product component generation from the other object.
     *
     * @generated
     */
    @IpsGenerated
    protected void copyProductCmptAndGenerationInternal(HomeBaseCoverage otherObject) {
        productConfiguration.copy(otherObject.productConfiguration);
    }

    /**
     * This method sets all properties in the copy with the values of this object. If there are
     * copied associated objects they are added to the copyMap in {@link #newCopyInternal(Map)}.
     *
     * @param copy The copy object
     * @param copyMap a map containing copied associated objects
     *
     * @generated
     */
    @IpsGenerated
    protected void copyProperties(IModelObject copy, Map<IModelObject, IModelObject> copyMap) {
        HomeBaseCoverage concreteCopy = (HomeBaseCoverage)copy;
        concreteCopy.annualBasePremium = annualBasePremium;
    }

    /**
     * Internal method for setting copied associations. For copied targets, the associations have to
     * be retargeted to the new copied instances. This method have to call
     * {@link #copyAssociationsInternal(IModelObject, Map)} in other instances associated by
     * composite.
     *
     * @param abstractCopy the copy of this policy component
     * @param copyMap the map contains the copied instances
     *
     * @generated
     */
    @IpsGenerated
    public void copyAssociationsInternal(IModelObject abstractCopy, Map<IModelObject, IModelObject> copyMap) {
        // Nothing to do.
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public boolean accept(IModelObjectVisitor visitor) {
        if (!visitor.visit(this)) {
            return false;
        }
        return true;
    }

    /**
     * Validates the object (but not its children). Returns <code>true</code> if this object should
     * continue validating, <code>false</code> otherwise.
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public boolean validateSelf(MessageList ml, IValidationContext context) {
        if (!super.validateSelf(ml, context)) {
            return STOP_VALIDATION;
        }
        return CONTINUE_VALIDATION;
    }

    /**
     * Validates the object's children.
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public void validateDependants(MessageList ml, IValidationContext context) {
        super.validateDependants(ml, context);
    }

    /**
     * @restrainedmodifiable
     */
    @Override
    @IpsGenerated
    public String toString() {
        // begin-user-code
        return getProductComponent() == null ? getClass().getSimpleName()
                : getClass().getSimpleName() + '[' + getProductComponent().toString() + ']';
        // end-user-code
    }

    /**
     * Creates a new instance of HomeBaseCoverageBuilder to edit this policy.
     *
     * @generated
     */
    @IpsGenerated
    public HomeBaseCoverageBuilder modify() {
        return HomeBaseCoverageBuilder.from(this, getProductComponent().getRepository());
    }

    /**
     * The runtime repository is used to create configured association targets from existing product
     * components.
     *
     * @generated
     */
    @IpsGenerated
    public HomeBaseCoverageBuilder modify(IRuntimeRepository runtimeRepository) {
        return HomeBaseCoverageBuilder.from(this, runtimeRepository);
    }

    /**
     * Creates a new HomeBaseCoverageBuilder with a new instance of policy. Runtime repository is
     * set to null.
     *
     * @generated
     */
    @IpsGenerated
    public static HomeBaseCoverageBuilder builder() {
        return HomeBaseCoverageBuilder.from(new HomeBaseCoverage(), null);
    }

    /**
     * Creates a new HomeBaseCoverageBuilder with a new instance of policy. Runtime repository is
     * set to null. The runtime repository is required as association targets exists that are
     * configured by a product. The product components of the targets must be in the given runtime
     * repository.
     *
     * @generated
     */
    @IpsGenerated
    public static HomeBaseCoverageBuilder builder(IRuntimeRepository runtimeRepository) {
        return HomeBaseCoverageBuilder.from(new HomeBaseCoverage(), runtimeRepository);
    }

    /**
     * Creates a new HomeBaseCoverageBuilder with a new instance of policy created by the given
     * product component.
     *
     * @generated
     */
    @IpsGenerated
    public static HomeBaseCoverageBuilder builder(HomeBaseCoverageType productCmpt) {
        return HomeBaseCoverageBuilder.from(new HomeBaseCoverage(productCmpt), productCmpt.getRepository());
    }

    /**
     * Creates a new HomeBaseCoverageBuilder with a new instance of policy created by the product
     * component with the given ID in the runtime repository that configures the policy.
     *
     * @generated
     */
    @IpsGenerated
    public static HomeBaseCoverageBuilder builder(IRuntimeRepository runtimeRepository, String productCmptId) {
        HomeBaseCoverageType product = (HomeBaseCoverageType)runtimeRepository.getProductComponent(productCmptId);
        if (product == null) {
            throw new RuntimeException("No product component found with given ID!");
        } else {
            HomeBaseCoverage policy = product.createHomeBaseCoverage();

            policy.initialize();
            return HomeBaseCoverageBuilder.from(policy, runtimeRepository);
        }
    }

}
