package org.faktorips.tutorial.produktdaten.deckungen;

import org.faktorips.tutorial.model.hausrat.HausratZusatzdeckungstyp;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.values.Money;
import org.faktorips.tutorial.model.hausrat.HausratVertrag;
import org.faktorips.tutorial.model.hausrat.HausratZusatzdeckung;
import org.faktorips.runtime.FormulaExecutionException;
import org.faktorips.values.Decimal;
import java.math.RoundingMode;

public class HRD__Überspannung___2019__07 extends HausratZusatzdeckungstyp {

    /**
     * Erzeugt eine neue Produkt Komponente.
     *
     */
    public HRD__Überspannung___2019__07(IRuntimeRepository repository, String id, String kindId, String versionId) {
        super(repository, id, kindId, versionId);
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    public Money berechneJahresbasisbeitrag(final HausratVertrag vertrag, final HausratZusatzdeckung deckung)
            throws FormulaExecutionException {
        try {
            return Money.valueOf("10EUR")
                    .add(deckung.getVersSumme().multiply(Decimal.valueOf("0.03"), RoundingMode.HALF_UP));
        } catch (Exception e) {
            StringBuilder parameterValues = new StringBuilder();
            parameterValues.append("vertrag=");
            parameterValues.append(vertrag == null ? "null" : vertrag.toString());
            parameterValues.append(", ");
            parameterValues.append("deckung=");
            parameterValues.append(deckung == null ? "null" : deckung.toString());
            throw new FormulaExecutionException(toString(), "10EUR +deckung.versSumme * 0.03",
                    parameterValues.toString(), e);
        }
    }

}
