package org.faktorips.tutorial.model.hausrat;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.internal.Table;
import org.faktorips.runtime.internal.tableindex.TwoColumnRangeStructure;
import org.faktorips.runtime.internal.tableindex.UniqueResultStructure;
import org.faktorips.runtime.model.annotation.IpsDocumented;
import org.faktorips.runtime.model.annotation.IpsTableStructure;
import org.faktorips.runtime.model.table.TableStructureKind;
import org.faktorips.runtime.annotation.IpsGenerated;

/**
 * Diese Klasse implementiert eine Read-Only In-Memory-Tabelle. Auf die Daten der Tabelle kann ueber
 * Finder-Methoden zugegriffen werden.
 *
 * @generated
 */
@IpsTableStructure(name = "hausrat.Tarifzonentabelle", type = TableStructureKind.SINGLE_CONTENT, columns = { "plzVon",
        "plzBis", "tarifzone" })
@IpsDocumented(bundleName = "org.faktorips.tutorial.model.model-label-and-descriptions", defaultLocale = "de")
public final class Tarifzonentabelle extends Table<TarifzonentabelleRow> {

    /**
     * Membervariable die Keys auf Tabellenzeilen abbildet.
     *
     * @generated
     */
    private TwoColumnRangeStructure<String, UniqueResultStructure<TarifzonentabelleRow>, TarifzonentabelleRow> key0SearchStructure;

    /**
     * Erzeugt einen leeren Tabelleninhalt.
     *
     * @generated
     */
    @IpsGenerated
    public Tarifzonentabelle() {
        super();
        rows = new ArrayList<>();
        init();
    }

    /**
     * Erzeugt einen neuen Tabelleninhalt mit den uebergebenen Zeilen. Die Liste mit den Zeilen wird
     * kopiert. Spaetere Aenderungen am Inhalt der Liste aendern also nicht die erzeugte Tabelle.
     * Dieser Konstruktor ist vor allem fuer die Verwendung in JUnit Tests vorgesehen, um beliebige
     * Tabelleninhalte erzeugen zu koennen.
     *
     * @generated
     */
    @IpsGenerated
    public Tarifzonentabelle(List<TarifzonentabelleRow> content) {
        super();
        rows = new ArrayList<>(content);
        init();
    }

    /**
     * Erzeugt einen neuen Tabelleninhalt mit den uebergebenen Zeilen. Die Liste mit den Zeilen wird
     * kopiert. Spaetere Aenderungen am Inhalt der Liste aendern also nicht die erzeugte Tabelle.
     * Dieser Konstruktor ist vor allem fuer die Verwendung in JUnit Tests und mit veraenderbaren
     * Repositories vorgesehen, um beliebige Tabelleninhalte erzeugen zu koennen.
     *
     * @param qualifiedTableName der Name mit dem der Tabelleninhalt im {@link IRuntimeRepository}
     *            referenziert wird
     *
     * @generated
     */
    @IpsGenerated
    public Tarifzonentabelle(List<TarifzonentabelleRow> content, String qualifiedTableName) {
        super(qualifiedTableName);
        rows = new ArrayList<>(content);
        init();
    }

    /**
     * Diese Methode wird waehrend der Initialisierung verwendet. Sie fuegt eine neue Tabellenzeile
     * hinzu.
     *
     * @generated
     */
    @Override
    @IpsGenerated
    protected void addRow(List<String> values, IRuntimeRepository productRepository) {
        String columnValue = values.get(0);
        String plzVon = columnValue;
        columnValue = values.get(1);
        String plzBis = columnValue;
        columnValue = values.get(2);
        String tarifzone = columnValue;
        rows.add(new TarifzonentabelleRow(plzVon, plzBis, tarifzone));
    }

    /**
     * Initialisiert die Maps dieser Tabelle. Diese werden von den Finder-Methoden dieser Klasse
     * verwendet.
     *
     * @generated
     */
    @Override
    @IpsGenerated
    protected final void initKeyMaps() {
        key0SearchStructure = TwoColumnRangeStructure
                .<String, UniqueResultStructure<TarifzonentabelleRow>, TarifzonentabelleRow> create();
        for (TarifzonentabelleRow row : rows) {
            key0SearchStructure.put(
                    row.getPlzVon(),
                    row.getPlzBis(),
                    UniqueResultStructure.createWith(row));
        }
    }

    /**
     * Gibt die Instanz dieser Tabellenklasse zurueck.
     *
     * @generated
     */
    @IpsGenerated
    public static final Tarifzonentabelle getInstance(IRuntimeRepository repository) {
        return repository.getTable(Tarifzonentabelle.class);
    }

    /**
     * Gibt die Instanz dieser Tabellenklasse zurueck.
     *
     * @generated
     */
    @IpsGenerated
    public static final Tarifzonentabelle getInstance(IRuntimeRepository repository, String qualifiedTableName) {
        return (Tarifzonentabelle)repository.getTable(qualifiedTableName);
    }

    /**
     * Durchsucht den Inhalt dieser Tabelle nach einem Eintrag entsprechend der Suchkriterien und
     * gibt diesen zurueck. Null wird zurueckgegeben falls kein Eintrag gefunden wird.
     *
     * @generated
     */
    @IpsGenerated
    public TarifzonentabelleRow findRow(String plz) {
        return key0SearchStructure
                .get(plz)
                .getUnique(null);
    }

    /**
     * Durchsucht den Inhalt dieser Tabelle nach einem Eintrag entsprechend der Suchkriterien und
     * gibt diesen zurück. Eine 'Null-Row' wird zurueckgegeben, falls kein Eintrag gefunden wird.
     *
     * @generated
     */
    @IpsGenerated
    public TarifzonentabelleRow findRowNullRowReturnedForEmptyResult(String plz) {
        return key0SearchStructure
                .get(plz)
                .getUnique(TarifzonentabelleRow.NULL_ROW);
    }

    /**
     * Durchsucht den Inhalt dieser Tabelle nach einem Eintrag entsprechend der Suchkriterien und
     * gibt diesen zurück. Eine Exception wird geworfen, falls kein Eintrag gefunden wird.
     *
     * @return Gibt die gesuchte Zeile zurück.
     * @throws IllegalArgumentException Wenn keine Zeile gefunden wurde.
     *
     * @generated
     */
    @IpsGenerated
    public TarifzonentabelleRow findExistingRow(String plz) {
        try {
            return key0SearchStructure
                    .get(plz)
                    .getUnique();
        } catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Es wurde keine Zeile in Tabelle " + getName()
                    + " mit folgenden Suchparametern gefunden:  plz = " + plz);
        }
    }

}
