package org.faktorips.tutorial.model.hausrat;

import org.faktorips.runtime.IModifiableRuntimeRepository;
import org.faktorips.values.Decimal;
import org.faktorips.values.Money;
import org.faktorips.runtime.annotation.IpsGenerated;

/**
 * Implementierung von HausratZusatzdeckungstypBuilder. Ein HausratZusatzdeckungstypBuilder stellt
 * alle Funktionen bereit, die für das Bearbeiten einer Instanz der Klasse HausratZusatzdeckungstyp
 * notwendig sind. Beachte, dass diese Klasse für Tests gedacht ist. Alle Produktbausteintypen
 * müssen hierfür in einem {@link IModifiableRuntimeRepository} liegen, da die Instanzen in Runtime
 * Repository nicht verändert werden können.
 *
 * @generated
 */
public class HausratZusatzdeckungstypBuilder {
    /**
     * @generated
     */
    private final IModifiableRuntimeRepository runtimeRepository;

    /**
     * @generated
     */
    private final HausratZusatzdeckungstyp hausratZusatzdeckungstyp;

    /**
     * Erzeugt eine neue Instanz von HausratZusatzdeckungstypBuilder mit einem Produkt. Das Produkt
     * muss im angegebenen {@link IModifiableRuntimeRepository} liegen, das selbst nicht null sein
     * darf.
     *
     * @generated
     */
    @IpsGenerated
    protected HausratZusatzdeckungstypBuilder(HausratZusatzdeckungstyp product,
            IModifiableRuntimeRepository runtimeRepository) {
        if (product == null || runtimeRepository == null) {
            throw new RuntimeException("Das Produkt und Repository dürfen nicht null sein!");
        } else {
            runtimeRepository.getExistingProductComponent(product.getId());

            this.runtimeRepository = runtimeRepository;
            this.hausratZusatzdeckungstyp = product;
        }
    }

    /**
     * Setzt den Wert der Eigenschaft versSummenFaktor.
     *
     * @generated
     */
    @IpsGenerated
    public HausratZusatzdeckungstypBuilder versSummenFaktor(Decimal versSummenFaktor) {
        hausratZusatzdeckungstyp.setVersSummenFaktor(versSummenFaktor);
        return this;
    }

    /**
     * Setzt den Wert der Eigenschaft maximaleVersSumme.
     *
     * @generated
     */
    @IpsGenerated
    public HausratZusatzdeckungstypBuilder maximaleVersSumme(Money maximaleVersSumme) {
        hausratZusatzdeckungstyp.setMaximaleVersSumme(maximaleVersSumme);
        return this;
    }

    /**
     * Setzt den Wert der Eigenschaft bezeichnung.
     *
     * @generated
     */
    @IpsGenerated
    public HausratZusatzdeckungstypBuilder bezeichnung(String bezeichnung) {
        hausratZusatzdeckungstyp.setBezeichnung(bezeichnung);
        return this;
    }

    /**
     * @return {@link IModifiableRuntimeRepository}, welches gespeichert wurde.
     *
     * @generated
     */
    @IpsGenerated
    public IModifiableRuntimeRepository getRepository() {
        return this.runtimeRepository;
    }

    /**
     * @return Instanz von HausratZusatzdeckungstyp, die gebaut wurde
     *
     * @generated
     */
    @IpsGenerated
    public HausratZusatzdeckungstyp getResult() {
        return hausratZusatzdeckungstyp;
    }

    /**
     * Interne Methode
     *
     * @generated
     */
    @IpsGenerated
    public static Class<?> getProductClass() {
        return HausratZusatzdeckungstyp.class;
    }

    /**
     * Erzeugt ein neues HausratZusatzdeckungstypBuilder mit HausratZusatzdeckungstyp und einem
     * Runtime Repository.
     *
     * @generated
     */
    @IpsGenerated
    public static HausratZusatzdeckungstypBuilder from(HausratZusatzdeckungstyp product,
            IModifiableRuntimeRepository runtimeRepository) {
        return new HausratZusatzdeckungstypBuilder(product, runtimeRepository);
    }

}
