package org.faktorips.tutorial.model.hausrat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.faktorips.runtime.CardinalityRange;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IModifiableRuntimeRepository;
import org.faktorips.runtime.IProductComponentLink;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.IllegalRepositoryModificationException;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.internal.EnumValues;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.ProductComponent;
import org.faktorips.runtime.internal.ProductComponentLink;
import org.faktorips.runtime.internal.Range;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.faktorips.runtime.model.annotation.IpsAllowedValues;
import org.faktorips.runtime.model.annotation.IpsAllowedValuesSetter;
import org.faktorips.runtime.model.annotation.IpsAssociation;
import org.faktorips.runtime.model.annotation.IpsAssociationAdder;
import org.faktorips.runtime.model.annotation.IpsAssociationLinks;
import org.faktorips.runtime.model.annotation.IpsAssociationRemover;
import org.faktorips.runtime.model.annotation.IpsAssociations;
import org.faktorips.runtime.model.annotation.IpsAttribute;
import org.faktorips.runtime.model.annotation.IpsAttributeSetter;
import org.faktorips.runtime.model.annotation.IpsAttributes;
import org.faktorips.runtime.model.annotation.IpsConfigures;
import org.faktorips.runtime.model.annotation.IpsDefaultValue;
import org.faktorips.runtime.model.annotation.IpsDefaultValueSetter;
import org.faktorips.runtime.model.annotation.IpsDocumented;
import org.faktorips.runtime.model.annotation.IpsMatchingAssociation;
import org.faktorips.runtime.model.annotation.IpsProductCmptType;
import org.faktorips.runtime.model.type.AssociationKind;
import org.faktorips.runtime.model.type.AttributeKind;
import org.faktorips.runtime.model.type.ValueSetKind;
import org.faktorips.runtime.util.ProductComponentLinks;
import org.faktorips.values.Money;
import org.faktorips.valueset.IntegerRange;
import org.faktorips.valueset.MoneyRange;
import org.faktorips.valueset.OrderedValueSet;
import org.faktorips.valueset.ValueSet;
import org.faktorips.valueset.UnrestrictedValueSet;
import org.w3c.dom.Element;
import org.faktorips.runtime.annotation.IpsGenerated;

/**
 * Implementierung von HausratProdukt.
 *
 * @generated
 */
@IpsProductCmptType(name = "hausrat.HausratProdukt")
@IpsAttributes({ "produktname", "vorschlagVersSummeProQm" })
@IpsAssociations({ "HausratGrunddeckungstyp", "HausratZusatzdeckungstyp" })
@IpsConfigures(HausratVertrag.class)
@IpsDocumented(bundleName = "org.faktorips.tutorial.model.model-label-and-descriptions", defaultLocale = "de")
public class HausratProdukt extends ProductComponent {

    /**
     * Der XML Tag Name der Assoziation hausratGrunddeckungstyp.
     *
     * @generated
     */
    private static final String XML_TAG_HAUSRAT_GRUNDDECKUNGSTYP = "HausratGrunddeckungstyp";
    /**
     * Der XML Tag Name der Assoziation hausratZusatzdeckungstypen.
     *
     * @generated
     */
    private static final String XML_TAG_HAUSRAT_ZUSATZDECKUNGSTYPEN = "HausratZusatzdeckungstyp";
    /**
     * Diese Konstante enthält den Namen der Eigenschaft produktname.
     *
     * @generated
     */
    public static final String PROPERTY_PRODUKTNAME = "produktname";
    /**
     * Die maximal erlaubten Werte fuer die Eigenschaft produktname.
     *
     * @generated
     */
    @IpsAllowedValues("produktname")
    public static final ValueSet<String> MAX_ALLOWED_VALUES_FOR_PRODUKTNAME = new UnrestrictedValueSet<>(true);
    /**
     * Der Vorgabewert des Attributs produktname.
     *
     * @generated
     */
    @IpsDefaultValue("produktname")
    public static final String DEFAULT_VALUE_FOR_PRODUKTNAME = null;
    /**
     * Diese Konstante enthält den Namen der Eigenschaft vorschlagVersSummeProQm.
     *
     * @generated
     */
    public static final String PROPERTY_VORSCHLAGVERSSUMMEPROQM = "vorschlagVersSummeProQm";
    /**
     * Die maximal erlaubten Werte fuer die Eigenschaft vorschlagVersSummeProQm.
     *
     * @generated
     */
    @IpsAllowedValues("vorschlagVersSummeProQm")
    public static final ValueSet<Money> MAX_ALLOWED_VALUES_FOR_VORSCHLAG_VERS_SUMME_PRO_QM = new UnrestrictedValueSet<>(
            true);
    /**
     * Der Vorgabewert des Attributs vorschlagVersSummeProQm.
     *
     * @generated
     */
    @IpsDefaultValue("vorschlagVersSummeProQm")
    public static final Money DEFAULT_VALUE_FOR_VORSCHLAG_VERS_SUMME_PRO_QM = Money.NULL;
    /**
     * Membervariable für die Produkteigenschaft Produktname.
     *
     * @generated
     */
    private String produktname = DEFAULT_VALUE_FOR_PRODUKTNAME;

    /**
     * Membervariable für die Produkteigenschaft VorschlagVersSummeProQm.
     *
     * @generated
     */
    private Money vorschlagVersSummeProQm = DEFAULT_VALUE_FOR_VORSCHLAG_VERS_SUMME_PRO_QM;
    /**
     * Membervariable fuer den Vorgabewert der Vertragseigenschaft zahlweise.
     *
     * @generated
     */
    private Integer defaultValueZahlweise = null;
    /**
     * Instanzvariable fuer den Wertebereich des Attributs zahlweise.
     *
     * @generated
     */
    private OrderedValueSet<Integer> allowedValuesForZahlweise = HausratVertrag.MAX_ALLOWED_VALUES_FOR_ZAHLWEISE;

    /**
     * Membervariable fuer den Vorgabewert der Vertragseigenschaft wohnflaeche.
     *
     * @generated
     */
    private Integer defaultValueWohnflaeche = null;
    /**
     * Instanzvariable fuer den Wertebereich des Attributs wohnflaeche.
     *
     * @generated
     */
    private ValueSet<Integer> rangeForWohnflaeche = HausratVertrag.MAX_ALLOWED_RANGE_FOR_WOHNFLAECHE;
    /**
     * Membervariable fuer den Vorgabewert der Vertragseigenschaft versSumme.
     *
     * @generated
     */
    private Money defaultValueVersSumme = Money.NULL;
    /**
     * Instanzvariable fuer den Wertebereich des Attributs versSumme.
     *
     * @generated
     */
    private ValueSet<Money> rangeForVersSumme = HausratVertrag.MAX_ALLOWED_RANGE_FOR_VERS_SUMME;
    /**
     * Membervariable fuer die Beziehung HausratGrunddeckungstyp.
     *
     * @generated
     */
    private IProductComponentLink<HausratGrunddeckungstyp> hausratGrunddeckungstyp = null;

    /**
     * Membervariable fuer die Beziehung HausratZusatzdeckungstypen.
     *
     * @generated
     */
    private Map<String, IProductComponentLink<HausratZusatzdeckungstyp>> hausratZusatzdeckungstypen = new LinkedHashMap<>(
            0);

    /**
     * Erzeugt eine neue Instanz von HausratProdukt.
     *
     * @generated
     */
    @IpsGenerated
    public HausratProdukt(IRuntimeRepository repository, String id, String kindId, String versionId) {
        super(repository, id, kindId, versionId);
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public boolean isChangingOverTime() {
        return false;
    }

    /**
     * Gibt den Wert der Eigenschaft produktname zurück.
     *
     * @generated
     */
    @IpsAttribute(name = "produktname", kind = AttributeKind.CONSTANT, valueSetKind = ValueSetKind.AllValues)
    @IpsGenerated
    public String getProduktname() {
        return produktname;
    }

    /**
     * Setzt den Wert der Eigenschaft produktname.
     *
     * @generated
     */
    @IpsAttributeSetter("produktname")
    @IpsGenerated
    public void setProduktname(String newValue) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        setProduktnameInternal(newValue);
    }

    /**
     * Setzt den Wert der Eigenschaft produktname.
     *
     * @generated
     */
    @IpsGenerated
    protected final void setProduktnameInternal(String newValue) {
        this.produktname = newValue;
    }

    /**
     * Gibt den Wert der Eigenschaft vorschlagVersSummeProQm zurück.
     *
     * @generated
     */
    @IpsAttribute(name = "vorschlagVersSummeProQm", kind = AttributeKind.CONSTANT, valueSetKind = ValueSetKind.AllValues)
    @IpsGenerated
    public Money getVorschlagVersSummeProQm() {
        return vorschlagVersSummeProQm;
    }

    /**
     * Setzt den Wert der Eigenschaft vorschlagVersSummeProQm.
     *
     * @generated
     */
    @IpsAttributeSetter("vorschlagVersSummeProQm")
    @IpsGenerated
    public void setVorschlagVersSummeProQm(Money newValue) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        setVorschlagVersSummeProQmInternal(newValue);
    }

    /**
     * Setzt den Wert der Eigenschaft vorschlagVersSummeProQm.
     *
     * @generated
     */
    @IpsGenerated
    protected final void setVorschlagVersSummeProQmInternal(Money newValue) {
        this.vorschlagVersSummeProQm = newValue;
    }

    /**
     * Gibt den Defaultwert fuer die Eigenschaft zahlweise zurueck.
     *
     * @generated
     */
    @IpsDefaultValue("zahlweise")
    @IpsGenerated
    public Integer getDefaultValueZahlweise() {
        return defaultValueZahlweise;
    }

    /**
     * Setzt den Defaultwert fuer die Eigenschaft zahlweise.
     *
     * @generated
     */
    @IpsDefaultValueSetter("zahlweise")
    @IpsGenerated
    public void setDefaultValueZahlweise(Integer defaultValueZahlweise) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        this.defaultValueZahlweise = defaultValueZahlweise;
    }

    /**
     * Gibt den erlaubten Wertebereich fuer das Attribut zahlweise zurueck.
     *
     * @generated
     */
    @IpsAllowedValues("zahlweise")
    @IpsGenerated
    public ValueSet<Integer> getAllowedValuesForZahlweise() {
        return allowedValuesForZahlweise;
    }

    /**
     * Setzt den erlaubten Wertebereich fuer das Attribut zahlweise.
     *
     * @throws ClassCastException wenn der Typ des Wertebereichs nicht zur Konfiguration des
     *             Attributs passt.
     *
     * @generated
     */
    @IpsAllowedValuesSetter("zahlweise")
    @IpsGenerated
    public void setAllowedValuesForZahlweise(ValueSet<Integer> allowedValuesForZahlweise) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        this.allowedValuesForZahlweise = (OrderedValueSet<Integer>)allowedValuesForZahlweise;
    }

    /**
     * Gibt den Defaultwert fuer die Eigenschaft wohnflaeche zurueck.
     *
     * @generated
     */
    @IpsDefaultValue("wohnflaeche")
    @IpsGenerated
    public Integer getDefaultValueWohnflaeche() {
        return defaultValueWohnflaeche;
    }

    /**
     * Setzt den Defaultwert fuer die Eigenschaft wohnflaeche.
     *
     * @generated
     */
    @IpsDefaultValueSetter("wohnflaeche")
    @IpsGenerated
    public void setDefaultValueWohnflaeche(Integer defaultValueWohnflaeche) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        this.defaultValueWohnflaeche = defaultValueWohnflaeche;
    }

    /**
     * Gibt den erlaubten Wertebereich fuer das Attribut wohnflaeche zurueck.
     *
     * @generated
     */
    @IpsAllowedValues("wohnflaeche")
    @IpsGenerated
    public ValueSet<Integer> getAllowedValuesForWohnflaeche() {
        return rangeForWohnflaeche;
    }

    /**
     * Setzt den erlaubten Wertebereich fuer das Attribut wohnflaeche.
     *
     * @throws ClassCastException wenn der Typ des Wertebereichs nicht zur Konfiguration des
     *             Attributs passt.
     *
     * @generated
     */
    @IpsAllowedValuesSetter("wohnflaeche")
    @IpsGenerated
    public void setAllowedValuesForWohnflaeche(ValueSet<Integer> rangeForWohnflaeche) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        if (rangeForWohnflaeche != null
                && !(rangeForWohnflaeche.isRange() || rangeForWohnflaeche instanceof OrderedValueSet)) {
            throw new java.lang.ClassCastException(
                    rangeForWohnflaeche + " is neither a range nor an ordered value set");
        }
        this.rangeForWohnflaeche = rangeForWohnflaeche;
    }

    /**
     * Gibt den Defaultwert fuer die Eigenschaft versSumme zurueck.
     *
     * @generated
     */
    @IpsDefaultValue("versSumme")
    @IpsGenerated
    public Money getDefaultValueVersSumme() {
        return defaultValueVersSumme;
    }

    /**
     * Setzt den Defaultwert fuer die Eigenschaft versSumme.
     *
     * @generated
     */
    @IpsDefaultValueSetter("versSumme")
    @IpsGenerated
    public void setDefaultValueVersSumme(Money defaultValueVersSumme) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        this.defaultValueVersSumme = defaultValueVersSumme;
    }

    /**
     * Gibt den erlaubten Wertebereich fuer das Attribut versSumme zurueck.
     *
     * @generated
     */
    @IpsAllowedValues("versSumme")
    @IpsGenerated
    public ValueSet<Money> getAllowedValuesForVersSumme() {
        return rangeForVersSumme;
    }

    /**
     * Setzt den erlaubten Wertebereich fuer das Attribut versSumme.
     *
     * @throws ClassCastException wenn der Typ des Wertebereichs nicht zur Konfiguration des
     *             Attributs passt.
     *
     * @generated
     */
    @IpsAllowedValuesSetter("versSumme")
    @IpsGenerated
    public void setAllowedValuesForVersSumme(ValueSet<Money> rangeForVersSumme) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        if (rangeForVersSumme != null
                && !(rangeForVersSumme.isRange() || rangeForVersSumme instanceof OrderedValueSet)) {
            throw new java.lang.ClassCastException(rangeForVersSumme + " is neither a range nor an ordered value set");
        }
        this.rangeForVersSumme = rangeForVersSumme;
    }

    /**
     * Gibt HausratGrunddeckungstyp zurueck. bzw. <code>null</code>, wenn kein
     * HausratGrunddeckungstyp referenziert wird.
     *
     * @throws org.faktorips.runtime.ProductCmptNotFoundException wenn ein Baustein referenziert
     *             ist, dieser aber nicht gefunden wird.
     *
     * @generated
     */
    @IpsAssociation(name = "HausratGrunddeckungstyp", pluralName = "HausratGrunddeckungstypen", kind = AssociationKind.Composition, targetClass = HausratGrunddeckungstyp.class, min = 1, max = 1)
    @IpsMatchingAssociation(source = HausratVertrag.class, name = "HausratGrunddeckung")
    @IpsGenerated
    public HausratGrunddeckungstyp getHausratGrunddeckungstyp() {
        if (hausratGrunddeckungstyp != null && !hausratGrunddeckungstyp.getCardinality().isEmpty()) {
            return hausratGrunddeckungstyp.getTarget();
        }
        return null;
    }

    /**
     * Setzt das neue referenzierte HausratGrunddeckungstyp-Objekt.
     *
     * @generated
     */
    @IpsAssociationAdder(association = "HausratGrunddeckungstyp")
    @IpsGenerated
    public void setHausratGrunddeckungstyp(HausratGrunddeckungstyp target) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        hausratGrunddeckungstyp = (target == null ? null
                : new ProductComponentLink<>(this, target, "HausratGrunddeckungstyp"));
    }

    /**
     * Setzt das neue referenzierte HausratGrunddeckungstyp-Objekt mit der gegebenen Kardinalitaet.
     *
     * @generated
     */
    @IpsAssociationAdder(association = "HausratGrunddeckungstyp", withCardinality = true)
    @IpsGenerated
    public void setHausratGrunddeckungstyp(HausratGrunddeckungstyp target, CardinalityRange cardinality) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        hausratGrunddeckungstyp = (target == null ? null
                : new ProductComponentLink<>(this, target, cardinality, "HausratGrunddeckungstyp"));
    }

    /**
     * Gibt den <code>ILink</code> zu HausratGrunddeckungstyp zurueck. bzw. <code>null</code>, wenn
     * kein Objekt referenziert wird.
     *
     * @generated
     */
    @IpsAssociationLinks(association = "HausratGrunddeckungstyp")
    @IpsGenerated
    public IProductComponentLink<HausratGrunddeckungstyp> getLinkForHausratGrunddeckungstyp() {
        return hausratGrunddeckungstyp;
    }

    /**
     * Gibt den <code>ILink</code> zu HausratGrunddeckungstyp an dem angegebenen Index zurueck.
     *
     * @generated
     */
    @IpsGenerated
    public IProductComponentLink<HausratGrunddeckungstyp> getLinkForHausratGrunddeckungstyp(
            HausratGrunddeckungstyp productComponent) {
        return hausratGrunddeckungstyp != null && hausratGrunddeckungstyp.getTargetId().equals(productComponent.getId())
                ? hausratGrunddeckungstyp
                : null;
    }

    /**
     * Gibt die Kardinalitaet fuer die Beziehung mit den Rollennamen HausratGrunddeckung zurueck.
     *
     * @generated
     */
    @IpsGenerated
    public CardinalityRange getCardinalityForHausratGrunddeckung(HausratGrunddeckungstyp productCmpt) {
        if (productCmpt != null) {
            return hausratGrunddeckungstyp != null && hausratGrunddeckungstyp.getTargetId().equals(productCmpt.getId())
                    ? hausratGrunddeckungstyp
                            .getCardinality()
                    : null;
        }
        return null;
    }

    /**
     * Gibt die referenzierten HausratZusatzdeckungstypen zurueck. Gibt ein leeres Array zurueck,
     * wenn kein Objekt referenziert wird.
     *
     * @throws org.faktorips.runtime.ProductCmptNotFoundException wenn einer der referenzierten
     *             Bausteine nicht gefunden wird.
     *
     * @generated
     */
    @IpsAssociation(name = "HausratZusatzdeckungstyp", pluralName = "HausratZusatzdeckungstypen", kind = AssociationKind.Composition, targetClass = HausratZusatzdeckungstyp.class, min = 0, max = Integer.MAX_VALUE)
    @IpsMatchingAssociation(source = HausratVertrag.class, name = "HausratZusatzdeckung")
    @IpsGenerated
    public List<? extends HausratZusatzdeckungstyp> getHausratZusatzdeckungstypen() {
        List<HausratZusatzdeckungstyp> result = new ArrayList<>(hausratZusatzdeckungstypen.size());
        for (IProductComponentLink<HausratZusatzdeckungstyp> hausratZusatzdeckungstyp : hausratZusatzdeckungstypen
                .values()) {
            if (!hausratZusatzdeckungstyp.getCardinality().isEmpty()) {
                result.add(hausratZusatzdeckungstyp.getTarget());
            }
        }
        return result;
    }

    /**
     * Gibt HausratZusatzdeckungstyp an dem angegebenen Index zurueck.
     *
     * @throws IndexOutOfBoundsException wenn der angegebene Index nicht im erlaubten Bereich liegt
     *             (kleiner als 0 oder größer gleich Anzahl der referenzierten Bausteine).
     * @throws org.faktorips.runtime.ProductCmptNotFoundException wenn der referenzierte Baustein
     *             nicht im Repository gefunden werden kann.
     *
     * @generated
     */
    @IpsGenerated
    public HausratZusatzdeckungstyp getHausratZusatzdeckungstyp(int index) {
        return ProductComponentLinks.getTarget(index, hausratZusatzdeckungstypen);
    }

    /**
     * Fuegt den gegebenen Produktbaustein zu diesem hinzu.
     *
     * @generated
     */
    @IpsAssociationAdder(association = "HausratZusatzdeckungstyp")
    @IpsGenerated
    public void addHausratZusatzdeckungstyp(HausratZusatzdeckungstyp target) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        this.hausratZusatzdeckungstypen.put(target.getId(),
                new ProductComponentLink<>(this, target, "HausratZusatzdeckungstyp"));
    }

    /**
     * Fuegt den gegebenen Produktbaustein mit der gegebenen Kardinalitaet zu diesem hinzu.
     *
     * @generated
     */
    @IpsAssociationAdder(association = "HausratZusatzdeckungstyp", withCardinality = true)
    @IpsGenerated
    public void addHausratZusatzdeckungstyp(HausratZusatzdeckungstyp target, CardinalityRange cardinality) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        this.hausratZusatzdeckungstypen.put(target.getId(),
                new ProductComponentLink<>(this, target, cardinality, "HausratZusatzdeckungstyp"));
    }

    /**
     * Entfernt die Beziehung zum gegebenen Produktbaustein.
     *
     * @generated
     */
    @IpsAssociationRemover(association = "HausratZusatzdeckungstyp")
    @IpsGenerated
    public void removeHausratZusatzdeckungstyp(HausratZusatzdeckungstyp target) {
        if (getRepository() != null && !getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        this.hausratZusatzdeckungstypen.remove(target.getId());
    }

    /**
     * Gibt die <code>ILink</code>s zu den referenzierten HausratZusatzdeckungstypen zurueck. Gibt
     * eine leere <code>Collection</code> zurueck, wenn kein Objekt referenziert wird.
     *
     * @generated
     */
    @IpsAssociationLinks(association = "HausratZusatzdeckungstyp")
    @IpsGenerated
    public Collection<IProductComponentLink<HausratZusatzdeckungstyp>> getLinksForHausratZusatzdeckungstypen() {
        return Collections.unmodifiableCollection(hausratZusatzdeckungstypen.values());
    }

    /**
     * Gibt den <code>ILink</code> zu HausratZusatzdeckungstyp an dem angegebenen Index zurueck.
     *
     * @generated
     */
    @IpsGenerated
    public IProductComponentLink<HausratZusatzdeckungstyp> getLinkForHausratZusatzdeckungstyp(
            HausratZusatzdeckungstyp productComponent) {
        return hausratZusatzdeckungstypen.get(productComponent.getId());
    }

    /**
     * Gibt die Kardinalitaet fuer die Beziehung mit den Rollennamen HausratZusatzdeckung zurueck.
     *
     * @generated
     */
    @IpsGenerated
    public CardinalityRange getCardinalityForHausratZusatzdeckung(HausratZusatzdeckungstyp productCmpt) {
        if (productCmpt != null) {
            return hausratZusatzdeckungstypen.containsKey(productCmpt.getId())
                    ? hausratZusatzdeckungstypen.get(productCmpt.getId())
                            .getCardinality()
                    : null;
        }
        return null;
    }

    /**
     * Gibt die Anzahl der HausratZusatzdeckungstypen zurueck.
     *
     * @generated
     */
    @IpsGenerated
    public int getNumOfHausratZusatzdeckungstypen() {
        return hausratZusatzdeckungstypen.size();
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    protected void doInitPropertiesFromXml(Map<String, Element> configMap) {
        super.doInitPropertiesFromXml(configMap);
        doInitProduktname(configMap);
        doInitVorschlagVersSummeProQm(configMap);
        doInitZahlweise(configMap);
        doInitWohnflaeche(configMap);
        doInitVersSumme(configMap);
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitProduktname(Map<String, Element> configMap) {
        Element configElement = configMap.get(PROPERTY_PRODUKTNAME);
        if (configElement != null) {
            String value = ValueToXmlHelper.getValueFromElement(configElement, ValueToXmlHelper.XML_TAG_VALUE);
            this.produktname = value;
        }
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitVorschlagVersSummeProQm(Map<String, Element> configMap) {
        Element configElement = configMap.get(PROPERTY_VORSCHLAGVERSSUMMEPROQM);
        if (configElement != null) {
            String value = ValueToXmlHelper.getValueFromElement(configElement, ValueToXmlHelper.XML_TAG_VALUE);
            this.vorschlagVersSummeProQm = Money.valueOf(value);
        }
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitZahlweise(Map<String, Element> configMap) {
        Element defaultValueElement = configMap
                .get(ValueToXmlHelper.CONFIGURED_DEFAULT_PREFIX + HausratVertrag.PROPERTY_ZAHLWEISE);
        if (defaultValueElement != null) {
            String value = ValueToXmlHelper.getValueFromElement(defaultValueElement);
            defaultValueZahlweise = IpsStringUtils.isEmpty(value) ? null : Integer.valueOf(value);
        }
        Element valueSetElement = configMap
                .get(ValueToXmlHelper.CONFIGURED_VALUE_SET_PREFIX + HausratVertrag.PROPERTY_ZAHLWEISE);
        if (valueSetElement != null) {
            EnumValues values = ValueToXmlHelper.getEnumValueSetFromElement(valueSetElement,
                    ValueToXmlHelper.XML_TAG_VALUE_SET);
            if (values != null) {
                List<Integer> enumValues = new ArrayList<>();
                for (int i = 0; i < values.getNumberOfValues(); i++) {
                    enumValues.add(
                            IpsStringUtils.isEmpty(values.getValue(i)) ? null : Integer.valueOf(values.getValue(i)));
                }
                allowedValuesForZahlweise = new OrderedValueSet<>(enumValues, values
                        .containsNull(), null);
            }
        }
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitWohnflaeche(Map<String, Element> configMap) {
        Element defaultValueElement = configMap
                .get(ValueToXmlHelper.CONFIGURED_DEFAULT_PREFIX + HausratVertrag.PROPERTY_WOHNFLAECHE);
        if (defaultValueElement != null) {
            String value = ValueToXmlHelper.getValueFromElement(defaultValueElement);
            defaultValueWohnflaeche = IpsStringUtils.isEmpty(value) ? null : Integer.valueOf(value);
        }
        Element valueSetElement = configMap
                .get(ValueToXmlHelper.CONFIGURED_VALUE_SET_PREFIX + HausratVertrag.PROPERTY_WOHNFLAECHE);
        if (valueSetElement != null) {
            EnumValues values = ValueToXmlHelper.getEnumValueSetFromElement(valueSetElement,
                    ValueToXmlHelper.XML_TAG_VALUE_SET);
            if (values != null) {
                List<Integer> enumValues = new ArrayList<>();
                for (int i = 0; i < values.getNumberOfValues(); i++) {
                    enumValues.add(
                            IpsStringUtils.isEmpty(values.getValue(i)) ? null : Integer.valueOf(values.getValue(i)));
                }
                rangeForWohnflaeche = new OrderedValueSet<>(enumValues, values
                        .containsNull(), null);
            }
            Range range = ValueToXmlHelper.getRangeFromElement(valueSetElement, ValueToXmlHelper.XML_TAG_VALUE_SET);
            if (range != null) {
                if (range.isEmpty()) {
                    rangeForWohnflaeche = IntegerRange.empty();
                } else {
                    rangeForWohnflaeche = IntegerRange.valueOf(range.getLower(), range
                            .getUpper(), range.getStep(), range.containsNull());
                }
            }
        }
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitVersSumme(Map<String, Element> configMap) {
        Element defaultValueElement = configMap
                .get(ValueToXmlHelper.CONFIGURED_DEFAULT_PREFIX + HausratVertrag.PROPERTY_VERSSUMME);
        if (defaultValueElement != null) {
            String value = ValueToXmlHelper.getValueFromElement(defaultValueElement);
            defaultValueVersSumme = Money.valueOf(value);
        }
        Element valueSetElement = configMap
                .get(ValueToXmlHelper.CONFIGURED_VALUE_SET_PREFIX + HausratVertrag.PROPERTY_VERSSUMME);
        if (valueSetElement != null) {
            EnumValues values = ValueToXmlHelper.getEnumValueSetFromElement(valueSetElement,
                    ValueToXmlHelper.XML_TAG_VALUE_SET);
            if (values != null) {
                List<Money> enumValues = new ArrayList<>();
                for (int i = 0; i < values.getNumberOfValues(); i++) {
                    enumValues.add(Money.valueOf(values.getValue(i)));
                }
                rangeForVersSumme = new OrderedValueSet<>(enumValues, values
                        .containsNull(), Money.NULL);
            }
            Range range = ValueToXmlHelper.getRangeFromElement(valueSetElement, ValueToXmlHelper.XML_TAG_VALUE_SET);
            if (range != null) {
                if (range.isEmpty()) {
                    rangeForVersSumme = MoneyRange.empty();
                } else {
                    rangeForVersSumme = MoneyRange.valueOf(range.getLower(), range
                            .getUpper(), range.getStep(), range.containsNull());
                }
            }
        }
    }

    /**
     * @generated
     */
    @Override
    @IpsGenerated
    protected void doInitReferencesFromXml(Map<String, List<Element>> elementsMap) {
        super.doInitReferencesFromXml(elementsMap);
        doInitHausratGrunddeckungstyp(elementsMap);
        doInitHausratZusatzdeckungstyp(elementsMap);
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitHausratGrunddeckungstyp(Map<String, List<Element>> elementsMap) {
        List<Element> associationElements = elementsMap.get(XML_TAG_HAUSRAT_GRUNDDECKUNGSTYP);
        if (associationElements != null) {
            for (Element element : associationElements) {
                if (!"0".equals(element.getAttribute("maxCardinality"))) {
                    hausratGrunddeckungstyp = new ProductComponentLink<>(this);
                    hausratGrunddeckungstyp.initFromXml(element);
                }
            }
        }
    }

    /**
     * @generated
     */
    @IpsGenerated
    private void doInitHausratZusatzdeckungstyp(Map<String, List<Element>> elementsMap) {
        List<Element> associationElements = elementsMap.get(XML_TAG_HAUSRAT_ZUSATZDECKUNGSTYPEN);
        if (associationElements != null) {
            this.hausratZusatzdeckungstypen = new LinkedHashMap<>(associationElements.size());
            for (Element element : associationElements) {
                IProductComponentLink<HausratZusatzdeckungstyp> link = new ProductComponentLink<>(this);
                link.initFromXml(element);
                this.hausratZusatzdeckungstypen.put(link.getTargetId(), link);
            }
        }
    }

    /**
     * Erzeugt eine neue Instanz von HausratVertrag, die durch diesen Produktbaustein konfiguriert
     * wird.
     *
     * @generated
     */
    @IpsGenerated
    public HausratVertrag createHausratVertrag() {
        HausratVertrag policy = new HausratVertrag(this);
        policy.initialize();
        return policy;
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public HausratVertrag createPolicyComponent() {
        return createHausratVertrag();
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public IProductComponentLink<? extends IProductComponent> getLink(String linkName, IProductComponent target) {
        if ("HausratGrunddeckungstyp".equals(linkName)) {
            return getLinkForHausratGrunddeckungstyp((HausratGrunddeckungstyp)target);
        }
        if ("HausratZusatzdeckungstyp".equals(linkName)) {
            return getLinkForHausratZusatzdeckungstyp((HausratZusatzdeckungstyp)target);
        }
        return null;
    }

    /**
     * {@inheritDoc}
     *
     * @generated
     */
    @Override
    @IpsGenerated
    public List<IProductComponentLink<? extends IProductComponent>> getLinks() {
        List<IProductComponentLink<? extends IProductComponent>> list = new ArrayList<>();
        if (getLinkForHausratGrunddeckungstyp() != null) {
            list.add(getLinkForHausratGrunddeckungstyp());
        }
        list.addAll(getLinksForHausratZusatzdeckungstypen());
        return list;
    }

    /**
     * Erzeugt ein neues HausratProduktBuilder um dieses Produkt zu bearbeiten.
     *
     * @generated
     */
    @IpsGenerated
    public HausratProduktBuilder modify() {
        return HausratProduktBuilder.from(this, (IModifiableRuntimeRepository)this.getRepository());
    }

    /**
     * Erzeugt eine neue Instanz von HausratProdukt mit einem {@link IModifiableRuntimeRepository},
     * ID, kindID und versionID. Das Wirksamkeitsdatum der neuen Instanz wird auf 1900/1/1 gesetzt.
     *
     * @generated
     */
    @IpsGenerated
    public static HausratProduktBuilder builder(IModifiableRuntimeRepository runtimeRepository,
            String id,
            String kindId,
            String versionId) {
        HausratProdukt product = new HausratProdukt(runtimeRepository, id, kindId, versionId);
        product.setValidFrom(new DateTime(1900, 1, 1));
        runtimeRepository.putProductComponent(product);

        return new HausratProduktBuilder(product, runtimeRepository);
    }

    /**
     * Erzeugt eine neue Instanz von HausratProdukt mit einem {@link IModifiableRuntimeRepository},
     * ID, kindID und versionID.
     *
     * @generated
     */
    @IpsGenerated
    public static HausratProduktBuilder builder(IModifiableRuntimeRepository runtimeRepository,
            String id,
            String kindId,
            String versionId,
            DateTime validFrom) {
        HausratProdukt product = new HausratProdukt(runtimeRepository, id, kindId, versionId);
        product.setValidFrom(validFrom);
        runtimeRepository.putProductComponent(product);

        return new HausratProduktBuilder(product, runtimeRepository);
    }

    /**
     * Erzeugt eine neue Instanz von HausratProdukt mit dem ID von einem existierenden
     * Produktbaustein.
     *
     * @generated
     */
    @IpsGenerated
    public static HausratProduktBuilder builder(IModifiableRuntimeRepository runtimeRepository, String prodCmptId) {
        HausratProdukt product = (HausratProdukt)runtimeRepository.getProductComponent(prodCmptId);

        if (product == null) {
            throw new RuntimeException("Keinen Produktbaustein mit der gegebenden ID gefunden!");
        } else {
            return HausratProduktBuilder.from(product, runtimeRepository);
        }
    }
}
