/*******************************************************************************
 * Copyright (c) 2005-2010 Faktor Zehn AG und andere.
 * 
 * Alle Rechte vorbehalten.
 * 
 * Dieses Programm und alle mitgelieferten Sachen (Dokumentationen, Beispiele, Konfigurationen,
 * etc.) duerfen nur unter den Bedingungen der Faktor-Zehn-Community Lizenzvereinbarung - Version
 * 0.1 (vor Gruendung Community) genutzt werden, die Bestandteil der Auslieferung ist und auch unter
 * http://www.faktorzehn.org/fips:lizenz eingesehen werden kann.
 * 
 * Mitwirkende: Faktor Zehn AG - initial API and implementation - http://www.faktorzehn.de
 *******************************************************************************/

package org.faktorips.productdataservice;

import java.io.Serializable;

/**
 * This data type combines XML content and time stamp. It is used by the {@link IProductDataService}
 * to provide XML content tagged with the time of the loaded table of content.
 * 
 * @author dirmeier
 */
public class XmlTimestampData implements Serializable {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    /**
     * The XML data. This variable is public because this type is only used to transfer data.
     */
    public String xmlData;

    /**
     * The version of the XML data. This variable is public because this type is only used to
     * transfer data.
     */
    public String version;

    /**
     * Creating the data object
     * 
     * @param xmlData The XML content
     * @param version The time stamp of the loaded content
     */
    public XmlTimestampData(String xmlData, String version) {
        this.xmlData = xmlData;
        this.version = version;
    }

}
