/*******************************************************************************
 * Copyright (c) 2005-2010 Faktor Zehn AG und andere.
 * 
 * Alle Rechte vorbehalten.
 * 
 * Dieses Programm und alle mitgelieferten Sachen (Dokumentationen, Beispiele, Konfigurationen,
 * etc.) duerfen nur unter den Bedingungen der Faktor-Zehn-Community Lizenzvereinbarung - Version
 * 0.1 (vor Gruendung Community) genutzt werden, die Bestandteil der Auslieferung ist und auch unter
 * http://www.faktorzehn.org/fips:lizenz eingesehen werden kann.
 * 
 * Mitwirkende: Faktor Zehn AG - initial API and implementation - http://www.faktorzehn.de
 *******************************************************************************/

package org.faktorips.productdataservice;

import javax.ejb.Remote;

/**
 * The repote interface for the product data service. The interface is implemented by a EJB 3.0
 * stateless session bean.
 * <p>
 * This service provides the xml content of product data and the version of the actually loaded
 * data.
 * 
 * @author dirmeier
 */
@Remote
public interface IProductDataService {

    /**
     * Getting the modification time stamp or version of the table of contents actually loaded by
     * the product data service
     * 
     */
    public String getProductDataVersion();

    /**
     * Getting the content and time stamp for the table of content
     * 
     */
    public XmlTimestampData getTocData();

    /**
     * Getting the content and time stamp for the product component identified by the ips object id
     * 
     */
    public XmlTimestampData getProductCmptData(String ipsObjectId);

    /**
     * Getting the content and time stamp for the test case identified by its qualified name
     * 
     */
    public XmlTimestampData getTestCaseData(String qName);

    /**
     * Getting the content and times stamp for the table content identified by its qualified name
     */
    public XmlTimestampData getTableContent(String qName);

    /**
     * Getting the content and version for the enum content identified by the class name
     */
    public XmlTimestampData getEnumContent(String className);

}
