/*******************************************************************************
 * Copyright (c) 2005-2010 Faktor Zehn AG und andere.
 * 
 * Alle Rechte vorbehalten.
 * 
 * Dieses Programm und alle mitgelieferten Sachen (Dokumentationen, Beispiele, Konfigurationen,
 * etc.) duerfen nur unter den Bedingungen der Faktor-Zehn-Community Lizenzvereinbarung - Version
 * 0.1 (vor Gruendung Community) genutzt werden, die Bestandteil der Auslieferung ist und auch unter
 * http://www.faktorzehn.org/fips:lizenz eingesehen werden kann.
 * 
 * Mitwirkende: Faktor Zehn AG - initial API and implementation - http://www.faktorzehn.de
 *******************************************************************************/

package org.faktorips.runtime.productdataprovider.ejbclient;

import javax.naming.InitialContext;

import org.faktorips.runtime.IVersionChecker;
import org.faktorips.runtime.productdataprovider.IProductDataProvider;
import org.faktorips.runtime.productdataprovider.IProductDataProviderFactory;

public class EjbProductDataProviderFactory implements IProductDataProviderFactory {

    private final String beanName;
    private final InitialContext initalContext;
    private IVersionChecker versionChecker;

    public EjbProductDataProviderFactory(String beanName, InitialContext initalContext) {
        this.beanName = beanName;
        this.initalContext = initalContext;
        versionChecker = new IVersionChecker() {

            @Override
            public boolean isCompatibleVersion(String oldVersion, String newVersion) {
                return oldVersion.equals(newVersion);
            }
        };
    }

    @Override
    public IProductDataProvider newInstance() {
        return new EjbProductDataProvider(beanName, initalContext, getVersionChecker());
    }

    /**
     * @param versionChecker The versionChecker to set.
     */
    public void setVersionChecker(IVersionChecker versionChecker) {
        this.versionChecker = versionChecker;
    }

    /**
     * @return Returns the versionChecker.
     */
    public IVersionChecker getVersionChecker() {
        return versionChecker;
    }

}
