/*******************************************************************************
 * Copyright (c) 2005-2010 Faktor Zehn AG und andere.
 * 
 * Alle Rechte vorbehalten.
 * 
 * Dieses Programm und alle mitgelieferten Sachen (Dokumentationen, Beispiele, Konfigurationen,
 * etc.) duerfen nur unter den Bedingungen der Faktor-Zehn-Community Lizenzvereinbarung - Version
 * 0.1 (vor Gruendung Community) genutzt werden, die Bestandteil der Auslieferung ist und auch unter
 * http://www.faktorzehn.org/fips:lizenz eingesehen werden kann.
 * 
 * Mitwirkende: Faktor Zehn AG - initial API and implementation - http://www.faktorzehn.de
 *******************************************************************************/

package org.faktorips.productdataservice;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;

public class FileReaderUtil {

    public static String readContent(URL url) throws IOException {
        InputStream stream = null;
        try {
            stream = url.openStream();
            String result = readContent(stream);
            return result;
        } finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static String readContent(InputStream stream) throws IOException {
        Reader reader = null;
        try {
            reader = new InputStreamReader(stream);
            String result = readContent(reader);
            return result;
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static String readContent(Reader reader) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(reader);
            StringBuilder tocBuilder = new StringBuilder();
            while (bufferedReader.ready()) {
                tocBuilder.append(bufferedReader.readLine()).append('\n');
            }
            return tocBuilder.toString();
        } finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

}
