/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.pojo;

import javax.naming.Context;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.Bus;
import org.apache.cxf.jaxws.JAXWSMethodInvoker;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.core.webservices.JaxWsUtils;
import org.apache.openejb.core.webservices.PortData;
import org.apache.openejb.server.cxf.CxfEndpoint;
import org.apache.openejb.server.cxf.CxfServiceConfiguration;
import org.apache.openejb.server.cxf.JaxWsImplementorInfoImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoEndpoint
extends CxfEndpoint {
    private InjectionProcessor<Object> injectionProcessor;

    public PojoEndpoint(Bus bus, PortData port, Context context, Class<?> instance) {
        super(bus, port, context, instance);
        String bindingURI = null;
        if (port.getBindingID() != null) {
            bindingURI = JaxWsUtils.getBindingURI((String)port.getBindingID());
        }
        this.implInfo = new JaxWsImplementorInfoImpl(instance, bindingURI);
        this.serviceFactory = new JaxWsServiceFactoryBean(this.implInfo);
        this.serviceFactory.setBus(bus);
        CxfServiceConfiguration configuration = new CxfServiceConfiguration(port);
        this.serviceFactory.getConfigurations().add(0, configuration);
        this.service = this.serviceFactory.create();
        try {
            this.injectionProcessor = new InjectionProcessor(instance, port.getInjections(), null, null, InjectionProcessor.unwrap((Context)context));
            this.injectionProcessor.createInstance();
            this.injectionProcessor.postConstruct();
            this.implementor = this.injectionProcessor.getInstance();
        }
        catch (Exception e) {
            throw new WebServiceException("Service resource injection failed", (Throwable)e);
        }
        this.service.setInvoker((Invoker)new JAXWSMethodInvoker(this.implementor));
    }

    @Override
    protected void init() {
        try {
            this.initHandlers();
        }
        catch (Exception e) {
            throw new WebServiceException("Error configuring handlers", (Throwable)e);
        }
    }

    @Override
    public void stop() {
        this.destroyHandlers();
        if (this.injectionProcessor != null) {
            this.injectionProcessor.preDestroy();
        }
        super.stop();
    }
}

