/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.ejb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.interceptor.InvocationContext;
import javax.xml.ws.WebFault;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.Bus;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.context.WebServiceContextImpl;
import org.apache.cxf.jaxws.support.ContextPropertiesMapping;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.service.invoker.AbstractInvoker;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.server.cxf.ejb.EjbInterceptor;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbMethodInvoker
extends AbstractInvoker {
    private static final Logger log = Logger.getInstance((LogCategory)LogCategory.CXF, EjbMethodInvoker.class);
    private DeploymentInfo deploymentInfo;
    private Bus bus;

    public EjbMethodInvoker(Bus bus, DeploymentInfo deploymentInfo) {
        this.bus = bus;
        this.deploymentInfo = deploymentInfo;
    }

    public Object getServiceObject(Exchange context) {
        return null;
    }

    protected Object invoke(Exchange exchange, Object serviceObject, Method m, List<Object> params) {
        Object result = null;
        InvocationContext invContext = (InvocationContext)exchange.get(InvocationContext.class);
        if (invContext == null) {
            log.debug("PreEJBInvoke");
            result = this.preEjbInvoke(exchange, m, params);
        } else {
            log.debug("EJBInvoke");
            result = this.ejbInvoke(exchange, m, params);
        }
        return result;
    }

    private Object preEjbInvoke(Exchange exchange, Method method, List<Object> params) {
        MessageContext ctx = ContextPropertiesMapping.createWebServiceContext((Exchange)exchange);
        WebServiceContextImpl.setMessageContext((MessageContext)ctx);
        try {
            EjbInterceptor interceptor = new EjbInterceptor(params, method, this.bus, exchange);
            Object[] arguments = new Object[]{ctx, interceptor};
            RpcContainer container = (RpcContainer)this.deploymentInfo.getContainer();
            Class callInterface = this.deploymentInfo.getServiceEndpointInterface();
            method = EjbMethodInvoker.getMostSpecificMethod((Method)method, (Class)callInterface);
            Object res = container.invoke(this.deploymentInfo.getDeploymentID(), InterfaceType.SERVICE_ENDPOINT, callInterface, method, arguments, null);
            if (exchange.isOneWay()) {
                Object var10_12 = null;
                return var10_12;
            }
            ArrayList<Object> retList = new ArrayList<Object>(1);
            if (!method.getReturnType().getName().equals("void")) {
                retList.add(res);
            }
            ArrayList<Object> arrayList = retList;
            return arrayList;
        }
        catch (ApplicationException e) {
            Throwable t = e.getCause();
            if (t != null) {
                if (t.getClass().isAssignableFrom(RuntimeException.class) && t.getClass().isAnnotationPresent(javax.ejb.ApplicationException.class)) {
                    throw (RuntimeException)t;
                }
                if (!t.getClass().isAnnotationPresent(WebFault.class)) {
                    exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.UNCHECKED_APPLICATION_FAULT);
                    throw new Fault(t);
                }
            } else {
                t = e;
            }
            exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.UNCHECKED_APPLICATION_FAULT);
            throw new Fault(t);
        }
        catch (Exception e) {
            exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.UNCHECKED_APPLICATION_FAULT);
            throw new Fault((Throwable)e);
        }
        finally {
            WebServiceContextImpl.clear();
        }
    }

    private Object ejbInvoke(Exchange exchange, Method m, List<Object> params) {
        try {
            Object res = this.directEjbInvoke(exchange, m, params);
            if (exchange.isOneWay()) {
                return null;
            }
            ArrayList<Object> retList = new ArrayList<Object>(1);
            if (!m.getReturnType().getName().equals("void")) {
                retList.add(res);
            }
            return retList;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t == null) {
                t = e;
            }
            exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.CHECKED_APPLICATION_FAULT);
            throw new Fault(t);
        }
        catch (Exception e) {
            exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.UNCHECKED_APPLICATION_FAULT);
            throw new Fault((Throwable)e);
        }
    }

    public Object directEjbInvoke(Exchange exchange, Method m, List<Object> params) throws Exception {
        InvocationContext invContext = (InvocationContext)exchange.get(InvocationContext.class);
        Object[] paramArray = params != null ? params.toArray() : new Object[]{};
        invContext.setParameters(paramArray);
        Object res = invContext.proceed();
        ContextPropertiesMapping.updateWebServiceContext((Exchange)exchange, (MessageContext)((MessageContext)invContext.getContextData()));
        return res;
    }
}

