/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.tools.common.extensions.soap.SoapAddress;
import org.apache.cxf.tools.util.SOAPBindingUtil;
import org.apache.cxf.transport.http.WSDLQueryHandler;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.xmlsoap.schemas.wsdl.http.AddressType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlQueryHandler
extends WSDLQueryHandler {
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.CXF, WsdlQueryHandler.class);

    public WsdlQueryHandler(Bus bus) {
        super(bus);
    }

    protected void updateDefinition(Definition def, Map<String, Definition> done, Map<String, SchemaReference> doneSchemas, String base, EndpointInfo ei) {
        if (done.get("") == def) {
            QName serviceName = ei.getService().getName();
            String portName = ei.getName().getLocalPart();
            this.updateServices(serviceName, portName, def, base);
        }
        super.updateDefinition(def, done, doneSchemas, base, ei);
    }

    private void updateServices(QName serviceName, String portName, Definition def, String baseUri) {
        boolean updated = false;
        Map services = def.getServices();
        if (services != null) {
            ArrayList<QName> servicesToRemove = new ArrayList<QName>();
            for (Map.Entry serviceEntry : services.entrySet()) {
                QName currServiceName = (QName)serviceEntry.getKey();
                if (currServiceName.equals(serviceName)) {
                    Service service = (Service)serviceEntry.getValue();
                    this.updatePorts(portName, service, baseUri);
                    updated = true;
                    continue;
                }
                servicesToRemove.add(currServiceName);
            }
            for (QName serviceToRemove : servicesToRemove) {
                def.removeService(serviceToRemove);
            }
        }
        if (!updated) {
            logger.warning("WSDL '" + serviceName.getLocalPart() + "' service not found.");
        }
    }

    private void updatePorts(String portName, Service service, String baseUri) {
        boolean updated = false;
        Map ports = service.getPorts();
        if (ports != null) {
            ArrayList<String> portsToRemove = new ArrayList<String>();
            for (Map.Entry portEntry : ports.entrySet()) {
                String currPortName = (String)portEntry.getKey();
                if (currPortName.equals(portName)) {
                    Port port = (Port)portEntry.getValue();
                    this.updatePortLocation(port, baseUri);
                    updated = true;
                    continue;
                }
                portsToRemove.add(currPortName);
            }
            for (String portToRemove : portsToRemove) {
                service.removePort(portToRemove);
            }
        }
        if (!updated) {
            logger.warning("WSDL '" + portName + "' port not found.");
        }
    }

    private void updatePortLocation(Port port, String baseUri) {
        List exts = port.getExtensibilityElements();
        if (exts != null && exts.size() > 0) {
            SoapAddress add;
            ExtensibilityElement el = (ExtensibilityElement)exts.get(0);
            if (SOAPBindingUtil.isSOAPAddress((Object)el)) {
                add = SOAPBindingUtil.getSoapAddress((Object)el);
                add.setLocationURI(baseUri);
            }
            if (el instanceof AddressType) {
                add = (AddressType)el;
                add.setLocation(baseUri);
            }
        }
    }
}

