/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.extension.ExtensionManagerBus;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.openejb.core.webservices.PortData;
import org.apache.openejb.server.cxf.CxfEndpoint;
import org.apache.openejb.server.cxf.HttpDestination;
import org.apache.openejb.server.cxf.HttpTransportFactory;
import org.apache.openejb.server.cxf.WsdlQueryHandler;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.server.webservices.saaj.SaajUniverse;

public abstract class CxfWsContainer
implements HttpListener {
    protected final Bus bus;
    protected final PortData port;
    protected HttpDestination destination;
    protected CxfEndpoint endpoint;

    public CxfWsContainer(Bus bus, PortData port) {
        this.bus = bus;
        this.port = port;
        ArrayList<String> ids = new ArrayList<String>();
        ids.add("http://schemas.xmlsoap.org/wsdl/soap/");
        DestinationFactoryManager factoryManager = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
        HttpTransportFactory factory = new HttpTransportFactory(bus);
        factory.setTransportIds(ids);
        factoryManager.registerDestinationFactory("http://cxf.apache.org/transports/http/configuration", (DestinationFactory)factory);
        factoryManager.registerDestinationFactory("http://cxf.apache.org/bindings/xformat", (DestinationFactory)factory);
        factoryManager.registerDestinationFactory("http://www.w3.org/2003/05/soap/bindings/HTTP/", (DestinationFactory)factory);
        factoryManager.registerDestinationFactory("http://schemas.xmlsoap.org/soap/http", (DestinationFactory)factory);
        factoryManager.registerDestinationFactory("http://schemas.xmlsoap.org/wsdl/http/", (DestinationFactory)factory);
        factoryManager.registerDestinationFactory("http://schemas.xmlsoap.org/wsdl/soap/http", (DestinationFactory)factory);
    }

    public void start() {
        this.endpoint = this.createEndpoint();
        this.endpoint.publish("http://nopath");
        this.destination = (HttpDestination)this.endpoint.getServer().getDestination();
    }

    protected abstract CxfEndpoint createEndpoint();

    public void destroy() {
        if (this.endpoint != null) {
            this.endpoint.stop();
            this.endpoint = null;
        }
    }

    public void onMessage(HttpRequest request, HttpResponse response) throws Exception {
        if (request.getMethod() == HttpRequest.Method.GET) {
            this.processGET(request, response);
        } else {
            this.processPOST(request, response);
        }
    }

    protected void processGET(HttpRequest request, HttpResponse response) throws Exception {
        boolean wsdlRequest;
        boolean bl = wsdlRequest = request.getParameter("wsdl") != null || request.getParameter("WSDL") != null || request.getParameter("xsd") != null || request.getParameter("XSD") != null;
        if (wsdlRequest) {
            this.getWsdl(request, response);
        } else if (this.endpoint.isSOAP11()) {
            EndpointInfo ei = this.destination.getEndpointInfo();
            response.setContentType("text/html");
            PrintWriter pw = new PrintWriter(response.getOutputStream());
            pw.write("<html><title>Web Service</title><body>");
            pw.write("Hi, this is '" + ei.getService().getName().getLocalPart() + "' web service.");
            pw.write("</body></html>");
            pw.flush();
        } else {
            this.processPOST(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processPOST(HttpRequest request, HttpResponse response) throws Exception {
        SaajUniverse universe = new SaajUniverse();
        universe.set(SaajUniverse.DEFAULT);
        try {
            this.destination.invoke(request, response);
        }
        finally {
            universe.unset();
        }
    }

    private void getWsdl(HttpRequest request, HttpResponse response) throws Exception {
        WsdlQueryHandler queryHandler = new WsdlQueryHandler(this.bus);
        String requestUri = request.getURI().toString();
        EndpointInfo ei = this.destination.getEndpointInfo();
        OutputStream out = response.getOutputStream();
        response.setContentType("text/xml");
        queryHandler.writeResponse(requestUri, null, ei, out);
    }

    public static Bus getBus() {
        CxfWsContainer.getDefaultBus();
        return new ExtensionManagerBus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bus getDefaultBus() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CxfEndpoint.class.getClassLoader());
        try {
            Bus bus = BusFactory.getDefaultBus();
            return bus;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }
}

