/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf;

import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.Context;
import org.apache.cxf.Bus;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.core.webservices.PortData;
import org.apache.openejb.server.cxf.CxfCatalogUtils;
import org.apache.openejb.server.cxf.CxfWsContainer;
import org.apache.openejb.server.cxf.client.SaajInterceptor;
import org.apache.openejb.server.cxf.ejb.EjbWsContainer;
import org.apache.openejb.server.cxf.pojo.PojoWsContainer;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.webservices.WsService;

public class CxfService
extends WsService {
    private final Map<String, CxfWsContainer> wsContainers = new TreeMap<String, CxfWsContainer>();

    public CxfService() {
        SaajInterceptor.registerInterceptors();
    }

    public String getName() {
        return "cxf";
    }

    protected HttpListener createEjbWsContainer(URL moduleBaseUrl, PortData port, DeploymentInfo deploymentInfo) {
        Bus bus = CxfWsContainer.getBus();
        CxfCatalogUtils.loadOASISCatalog(bus, moduleBaseUrl, "META-INF/jax-ws-catalog.xml");
        EjbWsContainer container = new EjbWsContainer(bus, port, deploymentInfo);
        container.start();
        this.wsContainers.put(deploymentInfo.getDeploymentID().toString(), container);
        return container;
    }

    protected void destroyEjbWsContainer(String deploymentId) {
        CxfWsContainer container = this.wsContainers.remove(deploymentId);
        if (container != null) {
            container.destroy();
        }
    }

    protected HttpListener createPojoWsContainer(URL moduleBaseUrl, PortData port, String serviceId, Class target, Context context, String contextRoot) {
        Bus bus = CxfWsContainer.getBus();
        CxfCatalogUtils.loadOASISCatalog(bus, moduleBaseUrl, "META-INF/jax-ws-catalog.xml");
        PojoWsContainer container = new PojoWsContainer(bus, port, context, target);
        container.start();
        this.wsContainers.put(serviceId, container);
        return container;
    }

    protected void destroyPojoWsContainer(String serviceId) {
        CxfWsContainer container = this.wsContainers.remove(serviceId);
        if (container != null) {
            container.destroy();
        }
    }
}

