/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.naming.Context;
import javax.xml.transform.Source;
import javax.xml.ws.Binding;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.handler.PortInfoImpl;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.openejb.core.webservices.HandlerResolverImpl;
import org.apache.openejb.core.webservices.PortData;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CxfEndpoint
extends javax.xml.ws.Endpoint {
    protected Bus bus;
    protected PortData port;
    protected Context context;
    protected Object implementor;
    protected Server server;
    protected Service service;
    protected JaxWsImplementorInfo implInfo;
    protected JaxWsServiceFactoryBean serviceFactory;
    protected HandlerResolverImpl handlerResolver;

    public CxfEndpoint(Bus bus, PortData port, Context context, Object implementor) {
        this.bus = bus;
        this.port = port;
        this.implementor = implementor;
        this.context = context;
    }

    protected URL getWsdlURL(URL configurationBaseUrl, String wsdlFile) {
        URL wsdlURL;
        block5: {
            wsdlURL = null;
            if (wsdlFile != null && wsdlFile.trim().length() > 0) {
                wsdlFile = wsdlFile.trim();
                try {
                    wsdlURL = new URL(wsdlFile);
                }
                catch (MalformedURLException e) {
                    wsdlURL = this.getImplementorClass().getResource("/" + wsdlFile);
                    if (wsdlURL != null || configurationBaseUrl == null) break block5;
                    try {
                        wsdlURL = new URL(configurationBaseUrl, wsdlFile);
                    }
                    catch (MalformedURLException ee) {
                        // empty catch block
                    }
                }
            }
        }
        return wsdlURL;
    }

    protected Class getImplementorClass() {
        return this.implementor.getClass();
    }

    protected Endpoint getEndpoint() {
        return this.getServer().getEndpoint();
    }

    public boolean isSOAP11() {
        return "http://schemas.xmlsoap.org/wsdl/soap/http".equals(this.implInfo.getBindingType()) || "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(this.implInfo.getBindingType());
    }

    public ServerImpl getServer() {
        return (ServerImpl)this.server;
    }

    public Binding getBinding() {
        return ((JaxWsEndpointImpl)this.getEndpoint()).getJaxwsBinding();
    }

    public void setExecutor(Executor executor) {
        this.service.setExecutor(executor);
    }

    public Executor getExecutor() {
        return this.service.getExecutor();
    }

    public Object getImplementor() {
        return this.implementor;
    }

    public List<Source> getMetadata() {
        return null;
    }

    public Map<String, Object> getProperties() {
        return null;
    }

    public boolean isPublished() {
        return this.server != null;
    }

    public void publish(Object arg0) {
    }

    public void publish(String address) {
        this.doPublish(address);
    }

    public void setMetadata(List<Source> arg0) {
    }

    public void setProperties(Map<String, Object> arg0) {
    }

    public EndpointReference getEndpointReference(Element ... referenceParameters) {
        throw new UnsupportedOperationException("JaxWS 2.1 APIs are not supported");
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... referenceParameters) {
        throw new UnsupportedOperationException("JaxWS 2.1 APIs are not supported");
    }

    protected void doPublish(String address) {
        NoInitJaxWsServerFactoryBean svrFactory = new NoInitJaxWsServerFactoryBean();
        svrFactory.setBus(this.bus);
        svrFactory.setAddress(address);
        svrFactory.setServiceFactory((ReflectionServiceFactoryBean)this.serviceFactory);
        svrFactory.setStart(false);
        svrFactory.setServiceBean(this.implementor);
        if ("http://www.w3.org/2004/08/wsdl/http".equals(this.implInfo.getBindingType())) {
            svrFactory.setTransportId("http://cxf.apache.org/bindings/xformat");
        }
        this.server = svrFactory.create();
        this.init();
        this.getEndpoint();
        if (this.getBinding() instanceof SOAPBinding) {
            ((SOAPBinding)this.getBinding()).setMTOMEnabled(this.port.isMtomEnabled());
        }
        this.server.start();
    }

    protected void init() {
    }

    protected void initHandlers() throws Exception {
        PortInfoImpl portInfo = new PortInfoImpl(this.implInfo.getBindingType(), this.serviceFactory.getEndpointName(), this.service.getName());
        this.handlerResolver = new HandlerResolverImpl(this.port.getHandlerChains(), this.port.getInjections(), this.context);
        List chain = this.handlerResolver.getHandlerChain((PortInfo)portInfo);
        this.getBinding().setHandlerChain(chain);
    }

    protected void destroyHandlers() {
        if (this.handlerResolver != null) {
            this.handlerResolver.destroyHandlers();
            this.handlerResolver = null;
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    private static class NoInitJaxWsServerFactoryBean
    extends JaxWsServerFactoryBean {
        public NoInitJaxWsServerFactoryBean() {
            this.doInit = false;
        }
    }
}

