/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.apache.openejb.server.cxf.ServerPasswordHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureCxfSecurity {
    public static final void setupWSS4JChain(Endpoint endpoint, Properties inProps) {
        Map<String, Object> in = ConfigureCxfSecurity.getPropsFromProperties(inProps, "wss4j.in.");
        Map<String, Object> out = ConfigureCxfSecurity.getPropsFromProperties(inProps, "wss4j.out.");
        ConfigureCxfSecurity.setupWSS4JChain(endpoint, in, out);
    }

    public static Map<String, Object> getPropsFromProperties(Properties inProps, String pattern) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : inProps.entrySet()) {
            String key = String.valueOf(entry.getKey());
            String val = String.valueOf(entry.getValue()).trim();
            if (!key.startsWith(pattern)) continue;
            props.put(key.substring(pattern.length()), val);
        }
        if (!props.isEmpty()) {
            props.put("passwordCallbackRef", new ServerPasswordHandler());
        }
        return props;
    }

    public static final void setupWSS4JChain(Endpoint endpoint, Map<String, Object> inProps, Map<String, Object> outProps) {
        if (null != inProps && !inProps.isEmpty()) {
            endpoint.getInInterceptors().add(new SAAJInInterceptor());
            endpoint.getInInterceptors().add(new WSS4JInInterceptor(inProps));
        }
        if (null != outProps && !outProps.isEmpty()) {
            endpoint.getOutInterceptors().add(new SAAJOutInterceptor());
            endpoint.getOutInterceptors().add(new WSS4JOutInterceptor(outProps));
        }
    }

    public static final void configure(Endpoint endpoint, Properties p) {
        ConfigureCxfSecurity.setupWSS4JChain(endpoint, p);
    }
}

