/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.productdataprovider;

import java.io.InputStream;
import org.faktorips.runtime.formula.IFormulaEvaluatorFactory;
import org.faktorips.runtime.internal.AbstractClassLoadingRuntimeRepository;
import org.faktorips.runtime.internal.toc.EnumContentTocEntry;
import org.faktorips.runtime.internal.toc.GenerationTocEntry;
import org.faktorips.runtime.internal.toc.IReadonlyTableOfContents;
import org.faktorips.runtime.internal.toc.ProductCmptTocEntry;
import org.faktorips.runtime.internal.toc.TableContentTocEntry;
import org.faktorips.runtime.internal.toc.TestCaseTocEntry;
import org.faktorips.runtime.productdataprovider.DataModifiedException;
import org.faktorips.runtime.productdataprovider.DataModifiedRuntimeException;
import org.faktorips.runtime.productdataprovider.DetachedContentRuntimeRepositoryManager;
import org.faktorips.runtime.productdataprovider.IProductDataProvider;
import org.w3c.dom.Element;

public class DetachedContentRuntimeRepository
extends AbstractClassLoadingRuntimeRepository {
    private final IProductDataProvider productDataProvider;
    private final IFormulaEvaluatorFactory formulaEvaluatorFactory;

    DetachedContentRuntimeRepository(DetachedContentRuntimeRepositoryManager.Builder builder) {
        super(builder.getRepositoryName(), builder.getCacheFactory(), builder.getClassLoader());
        this.productDataProvider = builder.getProductDataProviderFactory().newInstance();
        this.formulaEvaluatorFactory = builder.getFormulaEvaluatorFactory();
        super.initialize();
    }

    public IFormulaEvaluatorFactory getFormulaEvaluatorFactory() {
        return this.formulaEvaluatorFactory;
    }

    protected Element getDocumentElement(ProductCmptTocEntry tocEntry) {
        try {
            return this.productDataProvider.getProductCmptData(tocEntry);
        }
        catch (DataModifiedException e) {
            throw this.createDataModifiedException(e);
        }
    }

    protected Element getDocumentElement(GenerationTocEntry tocEntry) {
        try {
            return this.productDataProvider.getProductCmptGenerationData(tocEntry);
        }
        catch (DataModifiedException e) {
            throw this.createDataModifiedException(e);
        }
    }

    protected Element getDocumentElement(TestCaseTocEntry tocEntry) {
        try {
            return this.productDataProvider.getTestcaseElement(tocEntry);
        }
        catch (DataModifiedException e) {
            throw this.createDataModifiedException(e);
        }
    }

    protected String getProductComponentGenerationImplClass(GenerationTocEntry tocEntry) {
        if (this.getFormulaEvaluatorFactory() != null) {
            return tocEntry.getParent().getGenerationImplClassName();
        }
        return tocEntry.getImplementationClassName();
    }

    protected synchronized IReadonlyTableOfContents loadTableOfContents() {
        IReadonlyTableOfContents toc = this.productDataProvider.getToc();
        return toc;
    }

    protected InputStream getXmlAsStream(EnumContentTocEntry tocEntry) {
        try {
            return this.productDataProvider.getEnumContentAsStream(tocEntry);
        }
        catch (DataModifiedException e) {
            throw this.createDataModifiedException(e);
        }
    }

    protected InputStream getXmlAsStream(TableContentTocEntry tocEntry) {
        try {
            return this.productDataProvider.getTableContentAsStream(tocEntry);
        }
        catch (DataModifiedException e) {
            throw this.createDataModifiedException(e);
        }
    }

    public String getProductDataVersion() {
        return this.productDataProvider.getVersion();
    }

    boolean isUpToDate() {
        return this.productDataProvider.isCompatibleToBaseVersion();
    }

    private RuntimeException createDataModifiedException(DataModifiedException e) {
        return new DataModifiedRuntimeException(e);
    }

    public boolean isModifiable() {
        return false;
    }
}

