/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.modeltype.internal;

import java.util.Arrays;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.faktorips.runtime.modeltype.IModelType;
import org.faktorips.runtime.modeltype.IModelTypeAttribute;
import org.faktorips.runtime.modeltype.internal.AbstractModelElement;
import org.faktorips.runtime.modeltype.internal.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelTypeAttribute
extends AbstractModelElement
implements IModelTypeAttribute {
    private ModelType modelType;
    private Class<?> datatype;
    private String datatypeName;
    private IModelTypeAttribute.ValueSetType valueSetType = IModelTypeAttribute.ValueSetType.AllValues;
    private IModelTypeAttribute.AttributeType attributeType = IModelTypeAttribute.AttributeType.CHANGEABLE;
    private boolean isProductRelevant = false;

    public ModelTypeAttribute(ModelType modelType) {
        super(modelType.getAbstractRepository());
        this.modelType = modelType;
    }

    @Override
    public IModelType getModelType() {
        return this.modelType;
    }

    @Override
    public Class<?> getDatatype() throws ClassNotFoundException {
        if (this.datatype == null) {
            this.datatype = this.findDatatype();
        }
        return this.datatype;
    }

    @Override
    public IModelTypeAttribute.AttributeType getAttributeType() {
        return this.attributeType;
    }

    @Override
    public IModelTypeAttribute.ValueSetType getValueSetType() {
        return this.valueSetType;
    }

    @Override
    public boolean isProductRelevant() {
        return this.isProductRelevant;
    }

    @Override
    public void initFromXml(XMLStreamReader parser) throws XMLStreamException {
        super.initFromXml(parser);
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if (parser.getAttributeLocalName(i).equals("datatype")) {
                this.datatypeName = parser.getAttributeValue(i);
                continue;
            }
            if (parser.getAttributeLocalName(i).equals("valueSetType")) {
                this.valueSetType = IModelTypeAttribute.ValueSetType.valueOf(parser.getAttributeValue(i));
                continue;
            }
            if (parser.getAttributeLocalName(i).equals("attributeType")) {
                this.attributeType = IModelTypeAttribute.AttributeType.forName(parser.getAttributeValue(i));
                continue;
            }
            if (!parser.getAttributeLocalName(i).equals("isProductRelevant")) continue;
            this.isProductRelevant = Boolean.valueOf(parser.getAttributeValue(i));
        }
        this.initExtPropertiesFromXml(parser);
    }

    protected Class<?> findDatatype() {
        String actualName = this.datatypeName;
        int arraydepth = 0;
        while (actualName.lastIndexOf(91) > 0) {
            actualName = actualName.substring(0, actualName.lastIndexOf(91));
            ++arraydepth;
        }
        if (arraydepth > 0) {
            actualName = "boolean".equals(actualName) ? "Z" : ("byte".equals(actualName) ? "B" : ("char".equals(actualName) ? "C" : ("double".equals(actualName) ? "D" : ("float".equals(actualName) ? "F" : ("int".equals(actualName) ? "I" : ("long".equals(actualName) ? "J" : ("short".equals(actualName) ? "S" : "L" + actualName + ";")))))));
            char[] da = new char[arraydepth];
            Arrays.fill(da, '[');
            actualName = new String(da) + actualName;
        }
        if (actualName.equals(Boolean.TYPE.getName())) {
            return Boolean.TYPE;
        }
        if (actualName.equals(Byte.TYPE.getName())) {
            return Byte.TYPE;
        }
        if (actualName.equals(Character.TYPE.getName())) {
            return Character.TYPE;
        }
        if (actualName.equals(Double.TYPE.getName())) {
            return Double.TYPE;
        }
        if (actualName.equals(Float.TYPE.getName())) {
            return Float.TYPE;
        }
        if (actualName.equals(Integer.TYPE.getName())) {
            return Integer.TYPE;
        }
        if (actualName.equals(Long.TYPE.getName())) {
            return Long.TYPE;
        }
        if (actualName.equals(Short.TYPE.getName())) {
            return Short.TYPE;
        }
        return this.loadClass(actualName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(": ");
        sb.append(this.datatypeName);
        sb.append('(');
        sb.append((Object)this.attributeType);
        sb.append(", ");
        sb.append((Object)this.valueSetType);
        if (this.isProductRelevant) {
            sb.append(", ");
            sb.append("isProductRelevant");
        }
        sb.append(')');
        return sb.toString();
    }
}

