/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.modeltype.internal;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.faktorips.runtime.modeltype.IModelType;
import org.faktorips.runtime.modeltype.IModelTypeAssociation;
import org.faktorips.runtime.modeltype.internal.AbstractModelElement;
import org.faktorips.runtime.modeltype.internal.ModelType;

public class ModelTypeAssociation
extends AbstractModelElement
implements IModelTypeAssociation {
    private ModelType modelType;
    private IModelTypeAssociation.AssociationType associationType = IModelTypeAssociation.AssociationType.Association;
    private int minCardinality = 0;
    private int maxCardinality = Integer.MAX_VALUE;
    private String namePlural = null;
    private String targetJavaClassName = null;
    private boolean isProductRelevant = false;
    private boolean isDerivedUnion = false;
    private boolean isSubsetOfADerivedUnion = false;
    private Boolean isTargetRolePluralRequired = false;

    public ModelTypeAssociation(ModelType modelType) {
        super(modelType.getAbstractRepository());
        this.modelType = modelType;
    }

    public IModelType getModelType() {
        return this.modelType;
    }

    public IModelTypeAssociation.AssociationType getAssociationType() {
        return this.associationType;
    }

    public int getMaxCardinality() {
        return this.maxCardinality;
    }

    public int getMinCardinality() {
        return this.minCardinality;
    }

    public String getNamePlural() {
        return this.namePlural;
    }

    public IModelType getTarget() throws ClassNotFoundException {
        if (this.targetJavaClassName != null && this.targetJavaClassName.length() > 0) {
            Class<?> targetClass = this.loadClass(this.targetJavaClassName);
            return this.getRepository().getModelType(targetClass);
        }
        return null;
    }

    public boolean isProductRelevant() {
        return this.isProductRelevant;
    }

    public void initFromXml(XMLStreamReader parser) throws XMLStreamException {
        super.initFromXml(parser);
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if (parser.getAttributeLocalName(i).equals("namePlural")) {
                this.namePlural = parser.getAttributeValue(i);
                if (this.namePlural.length() != 0) continue;
                this.namePlural = null;
                continue;
            }
            if (parser.getAttributeLocalName(i).equals("target")) {
                this.targetJavaClassName = parser.getAttributeValue(i);
                continue;
            }
            if (parser.getAttributeLocalName(i).equals("minCardinality")) {
                this.minCardinality = Integer.parseInt(parser.getAttributeValue(i));
                continue;
            }
            if (parser.getAttributeLocalName(i).equals("maxCardinality")) {
                this.maxCardinality = Integer.parseInt(parser.getAttributeValue(i));
                continue;
            }
            if (parser.getAttributeLocalName(i).equals("associationType")) {
                this.associationType = IModelTypeAssociation.AssociationType.valueOf(parser.getAttributeValue(i));
                continue;
            }
            if (parser.getAttributeLocalName(i).equals("isProductRelevant")) {
                this.isProductRelevant = Boolean.valueOf(parser.getAttributeValue(i));
                continue;
            }
            if (parser.getAttributeLocalName(i).equals("isDerivedUnion")) {
                this.isDerivedUnion = Boolean.valueOf(parser.getAttributeValue(i));
                continue;
            }
            if (parser.getAttributeLocalName(i).equals("isSubsetOfADerivedUnion")) {
                this.isSubsetOfADerivedUnion = Boolean.valueOf(parser.getAttributeValue(i));
                continue;
            }
            if (!parser.getAttributeLocalName(i).equals("isTargetRolePluralRequired")) continue;
            this.isTargetRolePluralRequired = Boolean.valueOf(parser.getAttributeValue(i));
        }
        this.initExtPropertiesFromXml(parser);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getUsedName());
        sb.append(": ");
        sb.append(this.targetJavaClassName);
        sb.append('(');
        sb.append((Object)this.associationType);
        sb.append(' ');
        if (this.isDerivedUnion) {
            sb.append(", Derived Union ");
        }
        if (this.isSubsetOfADerivedUnion) {
            sb.append(", Subset of a Derived Union ");
        }
        sb.append(this.minCardinality);
        sb.append("..");
        sb.append(this.maxCardinality == Integer.MAX_VALUE ? "*" : Integer.valueOf(this.maxCardinality));
        if (this.isProductRelevant) {
            sb.append(", ");
            sb.append("isProductRelevant");
        }
        sb.append(')');
        return sb.toString();
    }

    public String getUsedName() {
        return this.isTargetRolePluralRequired != false ? this.getNamePlural() : this.getName();
    }

    public boolean isDerivedUnion() {
        return this.isDerivedUnion;
    }

    public boolean isSubsetOfADerivedUnion() {
        return this.isSubsetOfADerivedUnion;
    }
}

