/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.toc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.faktorips.runtime.internal.toc.AbstractReadonlyTableOfContents;
import org.faktorips.runtime.internal.toc.EnumContentTocEntry;
import org.faktorips.runtime.internal.toc.EnumXmlAdapterTocEntry;
import org.faktorips.runtime.internal.toc.FormulaTestTocEntry;
import org.faktorips.runtime.internal.toc.ModelTypeTocEntry;
import org.faktorips.runtime.internal.toc.ProductCmptTocEntry;
import org.faktorips.runtime.internal.toc.TableContentTocEntry;
import org.faktorips.runtime.internal.toc.TestCaseTocEntry;
import org.faktorips.runtime.internal.toc.TocEntryObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadonlyTableOfContents
extends AbstractReadonlyTableOfContents {
    protected Map<String, ProductCmptTocEntry> pcIdTocEntryMap = new HashMap<String, ProductCmptTocEntry>(1000);
    protected Map<String, ProductCmptTocEntry> pcNameTocEntryMap = new HashMap<String, ProductCmptTocEntry>(1000);
    protected Map<String, List<VersionIdTocEntry>> kindIdTocEntryListMap = new HashMap<String, List<VersionIdTocEntry>>(500);
    protected Map<String, TableContentTocEntry> tableImplClassTocEntryMap = new HashMap<String, TableContentTocEntry>(100);
    protected Map<String, TableContentTocEntry> tableContentNameTocEntryMap = new HashMap<String, TableContentTocEntry>(100);
    protected Map<String, TestCaseTocEntry> testCaseNameTocEntryMap = new HashMap<String, TestCaseTocEntry>(10);
    protected Map<String, ModelTypeTocEntry> modelTypeNameTocEntryMap = new HashMap<String, ModelTypeTocEntry>(100);
    protected Map<String, EnumContentTocEntry> enumContentImplClassTocEntryMap = new HashMap<String, EnumContentTocEntry>(100);
    protected Map<String, EnumXmlAdapterTocEntry> enumXmlAdapterTocEntryMap = new HashMap<String, EnumXmlAdapterTocEntry>(100);

    @Override
    protected void internalAddEntry(TocEntryObject entry) {
        if (entry instanceof ProductCmptTocEntry) {
            ProductCmptTocEntry prodEntry = (ProductCmptTocEntry)entry;
            this.pcIdTocEntryMap.put(prodEntry.getIpsObjectId(), prodEntry);
            this.pcNameTocEntryMap.put(prodEntry.getIpsObjectQualifiedName(), prodEntry);
            List<VersionIdTocEntry> versions = this.getVersionList(prodEntry.getKindId());
            versions.add(new VersionIdTocEntry(prodEntry.getVersionId(), prodEntry));
            return;
        }
        if (entry instanceof TableContentTocEntry) {
            this.tableImplClassTocEntryMap.put(entry.getImplementationClassName(), (TableContentTocEntry)entry);
            this.tableContentNameTocEntryMap.put(entry.getIpsObjectQualifiedName(), (TableContentTocEntry)entry);
            return;
        }
        if (entry instanceof TestCaseTocEntry) {
            this.testCaseNameTocEntryMap.put(entry.getIpsObjectQualifiedName(), (TestCaseTocEntry)entry);
            return;
        }
        if (entry instanceof FormulaTestTocEntry) {
            this.testCaseNameTocEntryMap.put(entry.getIpsObjectQualifiedName(), (FormulaTestTocEntry)entry);
            return;
        }
        if (entry instanceof ModelTypeTocEntry) {
            this.modelTypeNameTocEntryMap.put(entry.getIpsObjectQualifiedName(), (ModelTypeTocEntry)entry);
            return;
        }
        if (entry instanceof EnumContentTocEntry) {
            this.enumContentImplClassTocEntryMap.put(entry.getImplementationClassName(), (EnumContentTocEntry)entry);
            return;
        }
        if (entry instanceof EnumXmlAdapterTocEntry) {
            this.enumXmlAdapterTocEntryMap.put(entry.getIpsObjectId(), (EnumXmlAdapterTocEntry)entry);
            return;
        }
        throw new IllegalArgumentException("Unknown entry type " + entry);
    }

    @Override
    public List<ProductCmptTocEntry> getProductCmptTocEntries() {
        return new ArrayList<ProductCmptTocEntry>(this.pcIdTocEntryMap.values());
    }

    @Override
    public ProductCmptTocEntry getProductCmptTocEntry(String id) {
        return this.pcIdTocEntryMap.get(id);
    }

    @Override
    public ProductCmptTocEntry getProductCmptTocEntry(String kindId, String versionId) {
        if (kindId == null) {
            return null;
        }
        if (versionId == null) {
            throw new RuntimeException("Not implemented yet!");
        }
        List<VersionIdTocEntry> versions = this.getVersionList(kindId);
        for (VersionIdTocEntry each : versions) {
            if (!versionId.equals(each.versionId)) continue;
            return each.tocEntry;
        }
        return null;
    }

    @Override
    public List<ProductCmptTocEntry> getProductCmptTocEntries(String kindId) {
        ArrayList<ProductCmptTocEntry> result = new ArrayList<ProductCmptTocEntry>();
        List<VersionIdTocEntry> versionList = this.getVersionList(kindId);
        for (VersionIdTocEntry each : versionList) {
            result.add(each.tocEntry);
        }
        return result;
    }

    private List<VersionIdTocEntry> getVersionList(String kindId) {
        List<VersionIdTocEntry> versions = this.kindIdTocEntryListMap.get(kindId);
        if (versions == null) {
            versions = new ArrayList<VersionIdTocEntry>(1);
            this.kindIdTocEntryListMap.put(kindId, versions);
        }
        return versions;
    }

    @Override
    public List<TableContentTocEntry> getTableTocEntries() {
        return new ArrayList<TableContentTocEntry>(this.tableContentNameTocEntryMap.values());
    }

    @Override
    public TableContentTocEntry getTableTocEntryByClassname(String implementationClass) {
        return this.tableImplClassTocEntryMap.get(implementationClass);
    }

    @Override
    public TableContentTocEntry getTableTocEntryByQualifiedTableName(String qualifiedTableName) {
        return this.tableContentNameTocEntryMap.get(qualifiedTableName);
    }

    @Override
    public List<TestCaseTocEntry> getTestCaseTocEntries() {
        return new ArrayList<TestCaseTocEntry>(this.testCaseNameTocEntryMap.values());
    }

    @Override
    public TestCaseTocEntry getTestCaseTocEntryByQName(String qName) {
        return this.testCaseNameTocEntryMap.get(qName);
    }

    @Override
    public Set<ModelTypeTocEntry> getModelTypeTocEntries() {
        return new HashSet<ModelTypeTocEntry>(this.modelTypeNameTocEntryMap.values());
    }

    @Override
    public EnumContentTocEntry getEnumContentTocEntry(String className) {
        return this.enumContentImplClassTocEntryMap.get(className);
    }

    @Override
    public Set<EnumXmlAdapterTocEntry> getEnumXmlAdapterTocEntries() {
        return new HashSet<EnumXmlAdapterTocEntry>(this.enumXmlAdapterTocEntryMap.values());
    }

    public List<TocEntryObject> getEntries() {
        ArrayList<TocEntryObject> results = new ArrayList<TocEntryObject>();
        results.addAll(this.pcIdTocEntryMap.values());
        results.addAll(this.tableContentNameTocEntryMap.values());
        results.addAll(this.testCaseNameTocEntryMap.values());
        results.addAll(this.modelTypeNameTocEntryMap.values());
        results.addAll(this.enumContentImplClassTocEntryMap.values());
        results.addAll(this.enumXmlAdapterTocEntryMap.values());
        return results;
    }

    private class VersionIdTocEntry {
        private String versionId;
        private ProductCmptTocEntry tocEntry;

        public VersionIdTocEntry(String versionId, ProductCmptTocEntry entry) {
            this.versionId = versionId;
            this.tocEntry = entry;
        }
    }
}

