/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.toc;

import org.faktorips.runtime.internal.toc.TestCaseTocEntry;
import org.w3c.dom.Element;

public class FormulaTestTocEntry
extends TestCaseTocEntry {
    public static final String FORMULA_TEST_XML_TAG = "FormulaTest";
    private final String kindId;
    private final String versionId;

    public static FormulaTestTocEntry createFromXml(Element entryElement) {
        String ipsObjectId = entryElement.getAttribute("ipsObjectId");
        String implementationClassName = entryElement.getAttribute("implementationClass");
        String ipsObjectName = entryElement.getAttribute("ipsObjectQualifiedName");
        String kindId = entryElement.getAttribute("kindId");
        String versionId = entryElement.getAttribute("versionId");
        return new FormulaTestTocEntry(ipsObjectId, ipsObjectName, kindId, versionId, implementationClassName);
    }

    public FormulaTestTocEntry(String ipsObjectId, String ipsObjectQualifiedName, String kindId, String versionId, String implementationClassName) {
        super(ipsObjectId, ipsObjectQualifiedName, "", implementationClassName);
        this.kindId = kindId;
        this.versionId = versionId;
    }

    public String getKindId() {
        return this.kindId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    protected void addToXml(Element entryElement) {
        super.addToXml(entryElement);
        entryElement.setAttribute("kindId", this.kindId);
        entryElement.setAttribute("versionId", this.versionId);
    }

    protected String getXmlElementTag() {
        return FORMULA_TEST_XML_TAG;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.kindId == null ? 0 : this.kindId.hashCode());
        result = 31 * result + (this.versionId == null ? 0 : this.versionId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof FormulaTestTocEntry)) {
            return false;
        }
        FormulaTestTocEntry other = (FormulaTestTocEntry)obj;
        if (this.kindId == null ? other.kindId != null : !this.kindId.equals(other.kindId)) {
            return false;
        }
        if (this.versionId == null ? other.versionId != null : !this.versionId.equals(other.versionId)) {
            return false;
        }
        return super.equals(obj);
    }
}

