/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.faktorips.runtime.IRuntimeObject;
import org.faktorips.runtime.internal.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeObject
implements IRuntimeObject {
    private Map<String, String> extPropertyValues = new HashMap<String, String>();

    protected void initExtensionPropertiesFromXml(Element cmptElement) {
        NodeList nl = cmptElement.getElementsByTagName("ExtensionProperties");
        if (nl == null || nl.getLength() == 0) {
            return;
        }
        nl = ((Element)nl.item(0)).getElementsByTagName("Value");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element childElement = (Element)nl.item(i);
            String id = childElement.getAttribute("id");
            if (Boolean.parseBoolean(childElement.getAttribute("isNull"))) {
                this.extPropertyValues.put(id, null);
                continue;
            }
            String value = XmlUtil.getCDATAorTextContent(childElement);
            this.extPropertyValues.put(id, value);
        }
    }

    @Override
    public Set<String> getExtensionPropertyIds() {
        return this.extPropertyValues.keySet();
    }

    @Override
    public Object getExtensionPropertyValue(String propertyId) {
        return this.extPropertyValues.get(propertyId);
    }
}

