/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;

public class ReadOnlyBinaryRangeTree
implements Serializable {
    private static final long serialVersionUID = -5127537049885131034L;
    public static final KeyType KEY_IS_LOWER_BOUND = KeyType.KEY_IS_LOWER_BOUND;
    public static final KeyType KEY_IS_LOWER_BOUND_EQUAL = KeyType.KEY_IS_LOWER_BOUND_EQUAL;
    public static final KeyType KEY_IS_UPPER_BOUND = KeyType.KEY_IS_UPPER_BOUND;
    public static final KeyType KEY_IS_UPPER_BOUND_EQUAL = KeyType.KEY_IS_UPPER_BOUND_EQUAL;
    public static final KeyType KEY_IS_TWO_COLUMN_KEY = KeyType.KEY_IS_TWO_COLUMN_KEY;
    protected Node root;
    private Object[] values;
    private final KeyType keyType;

    public ReadOnlyBinaryRangeTree(Map map, KeyType keyType) {
        if (map == null) {
            throw new NullPointerException();
        }
        this.keyType = keyType;
        this.buildTree(map);
    }

    private boolean isEven(int value) {
        return value % 2 == 0;
    }

    private int[] createInitialVisitedArray(int size) {
        int[] visited = new int[size];
        for (int i = 0; i < visited.length; ++i) {
            visited[i] = 0;
        }
        return visited;
    }

    private void buildValuesArray(Comparable[] keys, Map map) {
        this.values = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            this.values[i] = map.get(keys[i]);
        }
    }

    private void buildTree(Map map) {
        if (map.isEmpty()) {
            return;
        }
        Object[] keys = new Comparable[map.size()];
        map.keySet().toArray(keys);
        Arrays.sort(keys);
        this.buildValuesArray((Comparable[])keys, map);
        int middlePos = keys.length / 2;
        int[] visited = this.createInitialVisitedArray(keys.length);
        this.root = new Node((Comparable)keys[middlePos], middlePos);
        visited[middlePos] = 1;
        int widthCount = this.isEven(keys.length) ? keys.length - middlePos : keys.length - (1 + middlePos);
        this.buildChildNodes(middlePos, widthCount, (Comparable[])keys, visited, this.root);
    }

    private void buildChildNodes(int middlePos, int widthCount, Comparable[] keys, int[] visited, Node parent) {
        if (parent == null) {
            return;
        }
        int leftPos = this.isEven(widthCount) ? middlePos - widthCount / 2 : middlePos - (widthCount + 1) / 2;
        int rightPos = this.isEven(widthCount) ? middlePos + widthCount / 2 : middlePos + (widthCount + 1) / 2;
        int newWidthCount = widthCount / 2;
        if (rightPos > keys.length - 1) {
            --rightPos;
        }
        if (leftPos < 0) {
            ++leftPos;
        }
        Node leftNode = null;
        Node rightNode = null;
        if (visited[leftPos] == 0) {
            leftNode = parent.newLeft(keys[leftPos], leftPos);
            visited[leftPos] = 1;
        }
        if (visited[rightPos] == 0) {
            rightNode = parent.newRight(keys[rightPos], rightPos);
            visited[rightPos] = 1;
        }
        this.buildChildNodes(leftPos, newWidthCount, keys, visited, leftNode);
        this.buildChildNodes(rightPos, newWidthCount, keys, visited, rightNode);
    }

    public Object getValue(Comparable key) {
        NodeVisitor visitor = this.keyType == KEY_IS_TWO_COLUMN_KEY ? new TwoColumnNodeVisitor() : new OneColumnNodeVisitor(this.keyType);
        visitor.start(this.root, key);
        int foundIndex = visitor.getFoundIndex();
        return foundIndex != -1 ? this.values[foundIndex] : null;
    }

    public static class TwoColumnKey
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = 42L;
        private final Comparable lowerBound;
        private final Comparable upperBound;

        public TwoColumnKey(Comparable lowerBound, Comparable upperBound) {
            if (lowerBound == null) {
                throw new NullPointerException();
            }
            if (upperBound == null) {
                throw new NullPointerException();
            }
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        public int compareTo(Object o) {
            TwoColumnKey other = (TwoColumnKey)o;
            return this.lowerBound.compareTo(other.lowerBound);
        }

        public boolean equals(Object obj) {
            TwoColumnKey other = (TwoColumnKey)obj;
            return this.lowerBound.equals(other.lowerBound) && this.upperBound.equals(other.upperBound);
        }

        public int hashCode() {
            return this.lowerBound.hashCode() + this.upperBound.hashCode();
        }

        public Comparable getLowerBound() {
            return this.lowerBound;
        }

        public Comparable getUpperBound() {
            return this.upperBound;
        }
    }

    public static class Node
    implements Serializable {
        private static final long serialVersionUID = -3023843176585381905L;
        protected Comparable key;
        protected Node left;
        protected Node right;
        private final int fValueIndex;

        private Node(Comparable key, int valueIndex) {
            this.key = key;
            this.fValueIndex = valueIndex;
        }

        private Node newLeft(Comparable key, int valueIndex) {
            this.left = new Node(key, valueIndex);
            return this.left;
        }

        private Node newRight(Comparable key, int valueIndex) {
            this.right = new Node(key, valueIndex);
            return this.right;
        }
    }

    private static class TwoColumnNodeVisitor
    implements NodeVisitor,
    Serializable {
        private static final long serialVersionUID = 42L;
        private int foundIndex = -1;
        private Comparable key;

        private TwoColumnNodeVisitor() {
        }

        public void start(Node startNode, Comparable key) {
            this.key = key;
            this.visit(startNode);
        }

        private void visit(Node node) {
            TwoColumnKey nodeKey = (TwoColumnKey)node.key;
            if (this.key.compareTo(nodeKey.lowerBound) < 0) {
                if (node.left != null) {
                    this.visit(node.left);
                }
            } else if (this.key.compareTo(nodeKey.upperBound) > 0) {
                if (node.right != null) {
                    this.visit(node.right);
                }
            } else {
                this.foundIndex = node.fValueIndex;
            }
        }

        public int getFoundIndex() {
            return this.foundIndex;
        }
    }

    private static class OneColumnNodeVisitor
    implements NodeVisitor,
    Serializable {
        private static final long serialVersionUID = 8409704039187989276L;
        private Comparable key;
        private int keyForSmallestMax = -1;
        private int keyForGreatestMin = -1;
        private int keyForEqual = -1;
        private final KeyType keyType;

        private OneColumnNodeVisitor(KeyType keyType) {
            this.keyType = keyType;
        }

        public void start(Node startNode, Comparable key) {
            this.key = key;
            this.visit(startNode);
        }

        private boolean isSmallestMaxAvailable() {
            return this.keyForSmallestMax != -1;
        }

        private boolean isGreatestMinAvailable() {
            return this.keyForGreatestMin != -1;
        }

        private boolean isEqualAvailable() {
            return this.keyForEqual != -1;
        }

        private void visit(Node node) {
            int comparationResult = this.key.compareTo(node.key);
            if (comparationResult > 0) {
                this.keyForGreatestMin = node.fValueIndex;
                if (node.right != null) {
                    this.visit(node.right);
                }
                return;
            }
            if (comparationResult < 0) {
                this.keyForSmallestMax = node.fValueIndex;
                if (node.left != null) {
                    this.visit(node.left);
                }
                return;
            }
            this.keyForEqual = node.fValueIndex;
        }

        public int getFoundIndex() {
            switch (this.keyType) {
                case KEY_IS_UPPER_BOUND: {
                    return this.keyForSmallestMax;
                }
                case KEY_IS_UPPER_BOUND_EQUAL: {
                    if (this.isEqualAvailable()) {
                        return this.keyForEqual;
                    }
                    if (this.isSmallestMaxAvailable()) {
                        return this.keyForSmallestMax;
                    }
                    return -1;
                }
                case KEY_IS_LOWER_BOUND: {
                    return this.keyForGreatestMin;
                }
                case KEY_IS_LOWER_BOUND_EQUAL: {
                    if (this.isEqualAvailable()) {
                        return this.keyForEqual;
                    }
                    if (this.isGreatestMinAvailable()) {
                        return this.keyForGreatestMin;
                    }
                    return -1;
                }
            }
            throw new RuntimeException("Encountered unexpected tree type: " + (Object)((Object)this.keyType));
        }
    }

    private static interface NodeVisitor {
        public void start(Node var1, Comparable var2);

        public int getFoundIndex();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KeyType {
        KEY_IS_LOWER_BOUND,
        KEY_IS_LOWER_BOUND_EQUAL,
        KEY_IS_UPPER_BOUND,
        KEY_IS_UPPER_BOUND_EQUAL,
        KEY_IS_TWO_COLUMN_KEY;

    }
}

