/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.faktorips.runtime.IConfigurableModelObject;
import org.faktorips.runtime.IObjectReferenceStore;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.internal.AbstractModelObject;
import org.faktorips.runtime.internal.XmlCallback;
import org.faktorips.runtime.jaxb.ProductComponentXmlAdapter;
import org.w3c.dom.Element;

public abstract class AbstractConfigurableModelObject
extends AbstractModelObject
implements IConfigurableModelObject {
    @XmlJavaTypeAdapter(value=ProductComponentXmlAdapter.class)
    @XmlAttribute(name="product-component.id")
    private IProductComponent productCmpt;
    private IProductComponentGeneration productCmptGeneration;

    public AbstractConfigurableModelObject() {
    }

    public AbstractConfigurableModelObject(IProductComponent productCmpt) {
        this.productCmpt = productCmpt;
    }

    @Deprecated
    public void setProductCmpt(IProductComponent productCmpt) {
        this.setProductComponent(productCmpt);
    }

    public void setProductComponent(IProductComponent productCmpt) {
        this.productCmpt = productCmpt;
        this.productCmptGeneration = null;
    }

    public IProductComponent getProductComponent() {
        return this.productCmpt;
    }

    public IProductComponentGeneration getProductCmptGeneration() {
        if (this.productCmptGeneration == null) {
            if (this.productCmpt == null) {
                return null;
            }
            this.productCmptGeneration = this.getProductComponentGenerationFromRepository();
        }
        return this.productCmptGeneration;
    }

    protected IProductComponentGeneration getProductComponentGenerationFromRepository() {
        return this.productCmpt.getGenerationBase(this.getEffectiveFromAsCalendar());
    }

    protected void setProductCmptGeneration(IProductComponentGeneration newGeneration) {
        if (newGeneration != null) {
            this.setProductComponent(newGeneration.getProductComponent());
        } else {
            this.setProductComponent(null);
        }
        this.productCmptGeneration = newGeneration;
    }

    protected final void copyProductCmptAndGenerationInternal(AbstractConfigurableModelObject otherObject) {
        this.productCmpt = otherObject.productCmpt;
        this.productCmptGeneration = otherObject.productCmptGeneration;
    }

    public void effectiveFromHasChanged() {
        this.resetProductCmptGenerationAfterEffectiveFromHasChanged();
    }

    protected void resetProductCmptGenerationAfterEffectiveFromHasChanged() {
        this.productCmptGeneration = null;
    }

    public void initialize() {
    }

    public void initFromXml(Element objectEl, boolean initWithProductDefaultsBeforeReadingXmlData, IRuntimeRepository productRepository, IObjectReferenceStore store) {
        this.initFromXml(objectEl, initWithProductDefaultsBeforeReadingXmlData, productRepository, store, null, null);
    }

    public void initFromXml(Element objectEl, boolean initWithProductDefaultsBeforeReadingXmlData, IRuntimeRepository productRepository, IObjectReferenceStore store, XmlCallback xmlCallback) {
        this.initFromXml(objectEl, initWithProductDefaultsBeforeReadingXmlData, productRepository, store, xmlCallback, "");
    }

    public void initFromXml(Element objectEl, boolean initWithProductDefaultsBeforeReadingXmlData, IRuntimeRepository productRepository, IObjectReferenceStore store, XmlCallback xmlCallback, String currPath) {
        String productCmptId = objectEl.getAttribute("productCmpt");
        if (!"".equals(productCmptId)) {
            IProductComponent productCmpt = productRepository.getExistingProductComponent(productCmptId);
            this.setProductComponent(productCmpt);
        }
        if (initWithProductDefaultsBeforeReadingXmlData) {
            this.initialize();
        }
        super.initFromXml(objectEl, initWithProductDefaultsBeforeReadingXmlData, productRepository, store, xmlCallback, currPath);
    }
}

