/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.faktorips.runtime.ICacheFactory;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.internal.AbstractTocBasedRuntimeRepository;
import org.faktorips.runtime.internal.EnumSaxHandler;
import org.faktorips.runtime.internal.ProductComponent;
import org.faktorips.runtime.internal.ProductComponentGeneration;
import org.faktorips.runtime.internal.Table;
import org.faktorips.runtime.internal.toc.EnumContentTocEntry;
import org.faktorips.runtime.internal.toc.GenerationTocEntry;
import org.faktorips.runtime.internal.toc.ProductCmptTocEntry;
import org.faktorips.runtime.internal.toc.TableContentTocEntry;
import org.faktorips.runtime.internal.toc.TestCaseTocEntry;
import org.faktorips.runtime.test.IpsTestCase2;
import org.faktorips.runtime.test.IpsTestCaseBase;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassLoadingRuntimeRepository
extends AbstractTocBasedRuntimeRepository {
    private final ClassLoader cl;

    public AbstractClassLoadingRuntimeRepository(String name, ICacheFactory cacheFactory, ClassLoader cl) {
        super(name, cacheFactory);
        this.cl = cl;
    }

    @Override
    protected IProductComponent createProductCmpt(ProductCmptTocEntry tocEntry) {
        ProductComponent productCmpt;
        Class<?> implClass = this.getClass(tocEntry.getImplementationClassName(), this.getClassLoader());
        try {
            Constructor<?> constructor = implClass.getConstructor(IRuntimeRepository.class, String.class, String.class, String.class);
            productCmpt = (ProductComponent)constructor.newInstance(this, tocEntry.getIpsObjectId(), tocEntry.getKindId(), tocEntry.getVersionId());
        }
        catch (Exception e) {
            throw new RuntimeException("Can't create product component instance for toc entry " + tocEntry, e);
        }
        Element docElement = this.getDocumentElement(tocEntry);
        productCmpt.initFromXml(docElement);
        return productCmpt;
    }

    @Override
    protected <T> List<T> createEnumValues(EnumContentTocEntry tocEntry, Class<T> clazz) {
        InputStream is = this.getXmlAsStream(tocEntry);
        EnumSaxHandler saxhandler = new EnumSaxHandler();
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(new InputSource(is), (DefaultHandler)saxhandler);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't parse the enumeration content of the resource " + tocEntry.getXmlResourceName());
        }
        Object enumValue = null;
        ArrayList<Object> enumValues = new ArrayList<Object>();
        try {
            Constructor<?>[] constructors = clazz.getDeclaredConstructors();
            Constructor<?> constructor = null;
            for (Constructor<?> currentConstructor : constructors) {
                Constructor<?> castedConstructor;
                Class<?>[] parameterTypes;
                if ((currentConstructor.getModifiers() & 4) <= 0 || (parameterTypes = currentConstructor.getParameterTypes()).length != 2 || parameterTypes[0] != List.class || parameterTypes[1] != IRuntimeRepository.class) continue;
                constructor = castedConstructor = currentConstructor;
            }
            if (constructor == null) {
                throw new RuntimeException("No valid constructor found to create enumerations instances for the toc entry " + tocEntry);
            }
            for (List<String> enumValueAsStrings : saxhandler.getEnumValueList()) {
                constructor.setAccessible(true);
                enumValue = constructor.newInstance(enumValueAsStrings, this);
                enumValues.add(enumValue);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can't create enumeration instance for toc entry " + tocEntry, e);
        }
        return enumValues;
    }

    @Override
    protected IProductComponentGeneration createProductCmptGeneration(GenerationTocEntry tocEntry) {
        ProductComponentGeneration productCmptGen;
        ProductComponent productCmpt = (ProductComponent)this.getProductComponent(tocEntry.getParent().getIpsObjectId());
        if (productCmpt == null) {
            throw new RuntimeException("Can't get product component for toc entry " + tocEntry);
        }
        try {
            Constructor<?> constructor = this.getConstructor(tocEntry);
            productCmptGen = (ProductComponentGeneration)constructor.newInstance(productCmpt);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't create product component instance for toc entry " + tocEntry, e);
        }
        Element genElement = this.getDocumentElement(tocEntry);
        productCmptGen.initFromXml(genElement);
        return productCmptGen;
    }

    private Constructor<?> getConstructor(GenerationTocEntry tocEntry) {
        Class<?> implClass = this.getClass(this.getProductComponentGenerationImplClass(tocEntry), this.cl);
        try {
            String productCmptClassName = tocEntry.getParent().getImplementationClassName();
            Class<?> productCmptClass = this.getClass(productCmptClassName, this.cl);
            return implClass.getConstructor(productCmptClass);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't get constructor for class " + implClass.getName() + " , toc entry " + tocEntry, e);
        }
    }

    @Override
    public void getAllProductComponentsInternal(Class<?> productCmptClass, List<IProductComponent> result) {
        List<ProductCmptTocEntry> entries = this.getTableOfContents().getProductCmptTocEntries();
        for (ProductCmptTocEntry entry : entries) {
            Class<?> clazz = this.getClass(entry.getImplementationClassName(), this.cl);
            if (!productCmptClass.isAssignableFrom(clazz)) continue;
            result.add(this.getProductComponentInternal(entry.getIpsObjectId()));
        }
    }

    @Override
    protected ITable createTable(TableContentTocEntry tocEntry) {
        Table table;
        Class<?> implClass = this.getClass(tocEntry.getImplementationClassName(), this.getClassLoader());
        try {
            Constructor<?> constructor = implClass.getConstructor(new Class[0]);
            table = (Table)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't create table instance for toc entry " + tocEntry, e);
        }
        InputStream is = this.getXmlAsStream(tocEntry);
        try {
            table.initFromXml(is, this);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't parse xml for " + tocEntry.getIpsObjectId(), e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close the input stream for : " + tocEntry.getIpsObjectId(), e);
            }
        }
        return table;
    }

    @Override
    protected IpsTestCaseBase createTestCase(TestCaseTocEntry tocEntry, IRuntimeRepository runtimeRepository) {
        IpsTestCaseBase test;
        Class<?> implClass = this.getClass(tocEntry.getImplementationClassName(), this.getClassLoader());
        try {
            Constructor<?> constructor = implClass.getConstructor(String.class);
            test = (IpsTestCaseBase)constructor.newInstance(tocEntry.getIpsObjectQualifiedName());
        }
        catch (Exception e) {
            throw new RuntimeException("Can't create test case instance for toc entry " + tocEntry, e);
        }
        test.setRepository(runtimeRepository);
        if (test instanceof IpsTestCase2) {
            Element docElement = this.getDocumentElement(tocEntry);
            ((IpsTestCase2)test).initFromXml(docElement);
        }
        test.setFullPath(tocEntry.getIpsObjectId());
        return test;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.cl;
    }

    protected abstract Element getDocumentElement(ProductCmptTocEntry var1);

    protected abstract Element getDocumentElement(GenerationTocEntry var1);

    protected abstract Element getDocumentElement(TestCaseTocEntry var1);

    protected abstract String getProductComponentGenerationImplClass(GenerationTocEntry var1);

    protected abstract InputStream getXmlAsStream(EnumContentTocEntry var1);

    protected abstract InputStream getXmlAsStream(TableContentTocEntry var1);
}

