/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.formula;

import org.faktorips.runtime.FormulaExecutionException;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.formula.IFormulaEvaluator;

public abstract class AbstractFormulaEvaluator
implements IFormulaEvaluator {
    public static final String COMPILED_EXPRESSION_XML_TAG = "compiledExpression";
    private final IProductComponentGeneration productCmptGeneration;

    public AbstractFormulaEvaluator(IProductComponentGeneration gen) {
        if (gen == null) {
            throw new NullPointerException();
        }
        this.productCmptGeneration = gen;
    }

    public IProductComponentGeneration getProductComponentGeneration() {
        return this.productCmptGeneration;
    }

    public Object evaluate(String formularName, Object ... parameters) {
        try {
            return this.evaluateInternal(formularName, parameters);
        }
        catch (Exception e) {
            StringBuffer parameterValues = new StringBuffer();
            parameterValues.append("Parameters: ");
            for (Object param : parameters) {
                parameterValues.append("" + param);
                if (param == parameters[parameters.length - 1]) continue;
                parameterValues.append(", ");
            }
            throw new FormulaExecutionException(this.productCmptGeneration.toString(), formularName, parameterValues.toString(), e);
        }
    }

    protected abstract Object evaluateInternal(String var1, Object ... var2) throws Exception;
}

