/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.io.Serializable;

public class ObjectProperty
implements Serializable {
    private static final long serialVersionUID = -3407760096164658253L;
    private Object object;
    private String property;
    private int index;
    private int hashCode;

    public ObjectProperty(Object object, String property, int index) {
        this.object = object;
        this.property = property;
        this.index = index;
        this.createHashCode();
    }

    private void createHashCode() {
        this.hashCode = this.object.hashCode() + this.index;
        this.hashCode = this.property == null ? this.hashCode : this.hashCode + this.property.hashCode();
    }

    public ObjectProperty(Object object, String property) {
        this(object, property, -1);
    }

    public ObjectProperty(Object object) {
        this(object, null, -1);
    }

    public Object getObject() {
        return this.object;
    }

    public String getProperty() {
        return this.property;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean hasIndex() {
        return this.index >= 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectProperty) {
            ObjectProperty other = (ObjectProperty)obj;
            return this.object.equals(other.object) && this.index == other.index && (this.property == null && other.property == null || this.property != null && other.property != null && this.property.equals(other.property));
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        if (this.object == null) {
            return "null." + this.property;
        }
        return this.object.toString() + "." + this.property;
    }
}

