/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.internal.AbstractRuntimeRepository;
import org.faktorips.runtime.test.IpsTest2;
import org.faktorips.runtime.test.IpsTestCaseBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryRuntimeRepository
extends AbstractRuntimeRepository {
    private HashMap<String, IProductComponent> productCmpts = new HashMap();
    private HashMap<String, SortedSet<IProductComponentGeneration>> productCmptGenLists = new HashMap();
    private List<ITable> tables = new ArrayList<ITable>();
    private Map<String, ITable> multipleContentTables = new HashMap<String, ITable>();
    private HashMap<String, IpsTestCaseBase> testCasesByQName = new HashMap();
    private Map<Class<?>, List<?>> enumValuesMap = new HashMap();
    private List<XmlAdapter<?, ?>> enumXmlAdapters = new LinkedList();

    public InMemoryRuntimeRepository() {
        super("InMemoryRuntimeRepository");
    }

    public InMemoryRuntimeRepository(String name) {
        super(name);
    }

    @Override
    public IProductComponent getProductComponentInternal(String id) {
        return this.productCmpts.get(id);
    }

    @Override
    public IProductComponent getProductComponentInternal(String kindId, String versionId) {
        if (kindId == null) {
            return null;
        }
        if (versionId == null) {
            throw new RuntimeException("Not implemented yet.");
        }
        for (IProductComponent cmpt : this.productCmpts.values()) {
            if (!kindId.equals(cmpt.getKindId()) || !versionId.equals(cmpt.getVersionId())) continue;
            return cmpt;
        }
        return null;
    }

    @Override
    public void getAllProductComponents(String kindId, List<IProductComponent> result) {
        for (IProductComponent cmpt : this.productCmpts.values()) {
            if (!kindId.equals(cmpt.getKindId())) continue;
            result.add(cmpt);
        }
    }

    private SortedSet<IProductComponentGeneration> getLoadedProductCmptGenerations(String productCmptId) {
        return this.productCmptGenLists.get(productCmptId);
    }

    @Override
    public void getProductComponentGenerations(IProductComponent productCmpt, List<IProductComponentGeneration> result) {
        SortedSet<IProductComponentGeneration> genSet = this.getLoadedProductCmptGenerations(productCmpt.getId());
        if (genSet != null) {
            result.addAll(genSet);
        }
    }

    public void initialize() {
    }

    @Override
    protected void getAllTables(List<ITable> result) {
        result.addAll(this.tables);
    }

    @Override
    public ITable getTableInternal(Class<?> tableClass) {
        for (ITable table : this.tables) {
            if (!tableClass.isAssignableFrom(table.getClass())) continue;
            return table;
        }
        return null;
    }

    public void putTable(ITable table) {
        Class<?> tableClass = table.getClass();
        Iterator<ITable> it = this.tables.iterator();
        while (it.hasNext()) {
            ITable each = it.next();
            if (!each.getClass().isAssignableFrom(tableClass)) continue;
            it.remove();
        }
        this.tables.add(table);
    }

    public void putTable(ITable table, String qName) {
        this.multipleContentTables.put(qName, table);
        this.putTable(table);
    }

    public <T> void putEnumValues(Class<T> enumType, List<T> enumValues) {
        ArrayList<T> copy = new ArrayList<T>(enumValues);
        this.enumValuesMap.put(enumType, copy);
    }

    @Override
    public ITable getTableInternal(String qualifiedTableName) {
        return this.multipleContentTables.get(qualifiedTableName);
    }

    @Override
    public void getAllProductComponents(List<IProductComponent> result) {
        result.addAll(this.productCmpts.values());
    }

    @Override
    public void getAllProductComponentIds(List<String> result) {
        result.addAll(this.productCmpts.keySet());
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    public void putProductComponent(IProductComponent productCmpt) {
        if (productCmpt == null) {
            throw new NullPointerException();
        }
        this.productCmpts.put(productCmpt.getId(), productCmpt);
    }

    @Override
    public IProductComponentGeneration getProductComponentGenerationInternal(String productCmptId, Calendar effectiveDate) {
        if (productCmptId == null) {
            return null;
        }
        if (effectiveDate == null) {
            return null;
        }
        SortedSet<IProductComponentGeneration> genSortedSet = this.getGenerationSortedSet(productCmptId);
        IProductComponentGeneration foundGen = null;
        long effectiveTime = effectiveDate.getTimeInMillis();
        long foundGenValidFrom = Long.MIN_VALUE;
        for (IProductComponentGeneration gen : genSortedSet) {
            long genValidFrom = gen.getValidFrom(effectiveDate.getTimeZone()).getTime();
            if (effectiveTime < genValidFrom || genValidFrom <= foundGenValidFrom) continue;
            foundGen = gen;
            foundGenValidFrom = genValidFrom;
        }
        return foundGen;
    }

    public void putProductCmptGeneration(IProductComponentGeneration generation) {
        if (generation == null) {
            throw new NullPointerException();
        }
        this.getGenerationSortedSet(generation.getProductComponent().getId()).add(generation);
        this.putProductComponent(generation.getProductComponent());
    }

    private SortedSet<IProductComponentGeneration> getGenerationSortedSet(String productCmptId) {
        SortedSet<IProductComponentGeneration> genSortedSet = this.productCmptGenLists.get(productCmptId);
        if (genSortedSet == null) {
            genSortedSet = new TreeSet<IProductComponentGeneration>(new ProductCmptGenerationComparator(TimeZone.getDefault()));
            this.productCmptGenLists.put(productCmptId, genSortedSet);
        }
        return genSortedSet;
    }

    @Override
    protected void getAllIpsTestCases(List<IpsTest2> result, IRuntimeRepository runtimeRepository) {
        result.addAll(this.testCasesByQName.values());
    }

    @Override
    protected void getIpsTestCasesStartingWith(String qNamePrefix, List<IpsTest2> result, IRuntimeRepository runtimeRepository) {
        for (String qName : this.testCasesByQName.keySet()) {
            if (!qName.startsWith(qNamePrefix)) continue;
            result.add(this.testCasesByQName.get(qName));
        }
    }

    @Override
    protected IpsTestCaseBase getIpsTestCaseInternal(String qName, IRuntimeRepository runtimeRepository) {
        return this.testCasesByQName.get(qName);
    }

    public void putIpsTestCase(IpsTestCaseBase test) {
        this.testCasesByQName.put(test.getQualifiedName(), test);
    }

    @Override
    protected void getAllModelTypeImplementationClasses(Set<String> result) {
        throw new RuntimeException("Currently not supported by InMemoryRuntimeRepository.");
    }

    @Override
    public IProductComponentGeneration getNextProductComponentGenerationInternal(IProductComponentGeneration generation) {
        SortedSet<IProductComponentGeneration> genSet = this.getLoadedProductCmptGenerations(generation.getProductComponent().getId());
        SortedSet<IProductComponentGeneration> successor = genSet.tailSet(generation);
        if (successor == null) {
            return null;
        }
        for (IProductComponentGeneration next : successor) {
            if (next.equals(generation)) continue;
            return next;
        }
        return null;
    }

    @Override
    protected int getNumberOfProductComponentGenerationsInternal(IProductComponent productCmpt) {
        SortedSet<IProductComponentGeneration> genSet = this.getLoadedProductCmptGenerations(productCmpt.getId());
        return genSet.size();
    }

    @Override
    public IProductComponentGeneration getPreviousProductComponentGenerationInternal(IProductComponentGeneration generation) {
        SortedSet<IProductComponentGeneration> genSet = this.getLoadedProductCmptGenerations(generation.getProductComponent().getId());
        SortedSet<IProductComponentGeneration> predecessors = genSet.headSet(generation);
        if (predecessors.isEmpty()) {
            return null;
        }
        return predecessors.last();
    }

    @Override
    public IProductComponentGeneration getLatestProductComponentGenerationInternal(IProductComponent productCmpt) {
        if (productCmpt == null) {
            throw new NullPointerException("The parameter productCmpt cannot be null.");
        }
        SortedSet<IProductComponentGeneration> genSet = this.getLoadedProductCmptGenerations(productCmpt.getId());
        return genSet.last();
    }

    @Override
    protected <T> List<T> getEnumValuesInternal(Class<T> clazz) {
        List<?> values = this.enumValuesMap.get(clazz);
        if (values == null) {
            return null;
        }
        return Collections.unmodifiableList(values);
    }

    public void addEnumXmlAdapter(XmlAdapter<?, ?> enumXmlAdapter) {
        this.enumXmlAdapters.add(enumXmlAdapter);
    }

    @Override
    protected List<XmlAdapter<?, ?>> getAllInternalEnumXmlAdapters(IRuntimeRepository repository) {
        return this.enumXmlAdapters;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProductCmptGenerationComparator
    implements Comparator<IProductComponentGeneration> {
        private TimeZone timeZone;

        private ProductCmptGenerationComparator(TimeZone timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public int compare(IProductComponentGeneration gen1, IProductComponentGeneration gen2) {
            if (gen1.getValidFrom(this.timeZone).before(gen2.getValidFrom(this.timeZone))) {
                return -1;
            }
            if (gen1.getValidFrom(this.timeZone).after(gen2.getValidFrom(this.timeZone))) {
                return 1;
            }
            return 0;
        }
    }
}

