/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.util.HashMap;
import java.util.Map;
import org.faktorips.runtime.ICacheFactory;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.caching.IComputable;
import org.faktorips.runtime.caching.Memoizer;
import org.faktorips.runtime.internal.AbstractCacheFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCacheFactory
extends AbstractCacheFactory
implements ICacheFactory {
    private Map<Class<?>, Integer> initialSizeMap = new HashMap();
    private int defaultInitialSize = 100;
    private float laodFactor = 0.75f;
    private int concurrencyLevel = 16;

    public DefaultCacheFactory() {
        this.setInitialSize(IProductComponent.class, 500);
        this.setInitialSize(IProductComponentGeneration.class, 5000);
        this.setInitialSize(ITable.class, 100);
    }

    @Deprecated
    public DefaultCacheFactory(int initialCapacityForProductCmpts, int initialCapacityForProductCmptGenerations, int initialCapacityForTablesByClassname, int initialCapacityForTablesByQname, int initialCapacityForEnumContentByClassName) {
        this.setInitialSize(IProductComponent.class, initialCapacityForProductCmpts);
        this.setInitialSize(IProductComponentGeneration.class, initialCapacityForProductCmptGenerations);
        this.setInitialSize(ITable.class, initialCapacityForTablesByClassname);
    }

    public void setInitialSize(Class<?> typeClass, int size) {
        this.initialSizeMap.put(typeClass, size);
    }

    public void setDefaultInitialSize(int defaultInitialSize) {
        this.defaultInitialSize = defaultInitialSize;
    }

    protected int getInitialSize(Class<?> typeClass) {
        Integer initSize = this.initialSizeMap.get(typeClass);
        if (initSize == null) {
            initSize = this.defaultInitialSize;
        }
        return initSize;
    }

    public <K, V> Memoizer<K, V> createCache(IComputable<K, V> computable) {
        Integer initSize = this.initialSizeMap.get(computable.getValueClass());
        if (initSize == null) {
            initSize = this.defaultInitialSize;
        }
        return new Memoizer<K, V>(computable, initSize, this.laodFactor, this.concurrencyLevel);
    }

    public void setConcurrencyLevel(int concurrencyLevel) {
        this.concurrencyLevel = concurrencyLevel;
    }

    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }
}

