/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.ejbd;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.ConnectionFactory;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.Injection;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.client.CallbackMetaData;
import org.apache.openejb.client.ClusterableRequest;
import org.apache.openejb.client.ClusterableResponse;
import org.apache.openejb.client.DataSourceMetaData;
import org.apache.openejb.client.EJBMetaDataImpl;
import org.apache.openejb.client.HandlerChainMetaData;
import org.apache.openejb.client.HandlerMetaData;
import org.apache.openejb.client.InjectionMetaData;
import org.apache.openejb.client.JNDIRequest;
import org.apache.openejb.client.JNDIResponse;
import org.apache.openejb.client.NameClassPairEnumeration;
import org.apache.openejb.client.PortRefMetaData;
import org.apache.openejb.client.ThrowableArtifact;
import org.apache.openejb.client.WsMetaData;
import org.apache.openejb.core.ivm.BaseEjbProxyHandler;
import org.apache.openejb.core.ivm.naming.IvmContext;
import org.apache.openejb.core.webservices.HandlerChainData;
import org.apache.openejb.core.webservices.HandlerData;
import org.apache.openejb.core.webservices.PortAddress;
import org.apache.openejb.core.webservices.PortAddressRegistry;
import org.apache.openejb.core.webservices.PortRefData;
import org.apache.openejb.core.webservices.ServiceRefData;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.ejbd.BasicClusterableRequestHandler;
import org.apache.openejb.server.ejbd.ClientObjectFactory;
import org.apache.openejb.server.ejbd.ClusterableRequestHandler;
import org.apache.openejb.server.ejbd.EjbDaemon;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.proxy.ProxyManager;
import org.omg.CORBA.ORB;

class JndiRequestHandler {
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER_REMOTE.createChild("jndi"), (String)"org.apache.openejb.server.util.resources");
    private final Context ejbJndiTree;
    private Context clientJndiTree;
    private final Context deploymentsJndiTree;
    private final ClusterableRequestHandler clusterableRequestHandler;
    private Context rootContext;

    JndiRequestHandler(EjbDaemon daemon) throws Exception {
        ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        this.ejbJndiTree = (Context)containerSystem.getJNDIContext().lookup("openejb/remote");
        this.deploymentsJndiTree = (Context)containerSystem.getJNDIContext().lookup("openejb/Deployment");
        this.rootContext = containerSystem.getJNDIContext();
        try {
            this.clientJndiTree = (Context)containerSystem.getJNDIContext().lookup("openejb/client");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.clusterableRequestHandler = this.newClusterableRequestHandler();
    }

    protected BasicClusterableRequestHandler newClusterableRequestHandler() {
        return new BasicClusterableRequestHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processRequest(ObjectInputStream in, ObjectOutputStream out) {
        NamingException namingException;
        JNDIResponse res = new JNDIResponse();
        JNDIRequest req = null;
        try {
            req = new JNDIRequest();
            req.readExternal((ObjectInput)in);
        }
        catch (Throwable e) {
            res.setResponseCode(17);
            namingException = new NamingException("Could not read jndi request");
            namingException.setRootCause(e);
            res.setResult((Object)new ThrowableArtifact((Throwable)namingException));
            if (logger.isDebugEnabled()) {
                try {
                    logger.debug("JNDI REQUEST: " + req + " -- RESPONSE: " + res);
                }
                catch (Exception justInCase) {
                    // empty catch block
                }
            }
            try {
                res.writeExternal((ObjectOutput)out);
            }
            catch (IOException ie) {
                logger.fatal("Couldn't write JndiResponse to output stream", (Throwable)ie);
            }
        }
        try {
            if (req.getRequestString().startsWith("/")) {
                req.setRequestString(req.getRequestString().substring(1));
            }
            Context context = this.getContext(req);
            switch (req.getRequestMethod()) {
                case 27: {
                    this.doLookup(req, res, context);
                    return;
                }
                case 28: {
                    this.doList(req, res, context);
                    return;
                }
            }
            return;
        }
        catch (Throwable e) {
            res.setResponseCode(17);
            namingException = new NamingException("Unknown error in container");
            namingException.setRootCause(e);
            res.setResult((Object)new ThrowableArtifact((Throwable)namingException));
            return;
        }
        finally {
            if (logger.isDebugEnabled()) {
                try {
                    logger.debug("JNDI REQUEST: " + req + " -- RESPONSE: " + res);
                }
                catch (Exception justInCase) {}
            }
            try {
                res.writeExternal((ObjectOutput)out);
            }
            catch (Throwable e) {
                logger.fatal("Couldn't write JndiResponse to output stream", e);
            }
        }
    }

    private Context getContext(JNDIRequest req) throws NamingException {
        String name = req.getRequestString();
        Context context = name.startsWith("openejb/Deployment/") ? this.rootContext : (req.getModuleId() != null && req.getModuleId().equals("openejb/Deployment") ? this.deploymentsJndiTree : (req.getModuleId() != null && this.clientJndiTree != null ? (Context)this.clientJndiTree.lookup(req.getModuleId()) : this.ejbJndiTree));
        return context;
    }

    private void doLookup(JNDIRequest req, JNDIResponse res, Context context) {
        BaseEjbProxyHandler handler;
        Object object;
        String name = req.getRequestString();
        try {
            if (name.equals("comp/injections")) {
                List injections = (List)context.lookup(name);
                InjectionMetaData metaData = new InjectionMetaData();
                for (Injection injection : injections) {
                    metaData.addInjection(injection.getTarget().getName(), injection.getName(), injection.getJndiName());
                }
                res.setResponseCode(23);
                res.setResult((Object)metaData);
                return;
            }
            if (name.startsWith("comp/env/")) {
                context = (Context)context.lookup("comp/env/");
                name = name.substring("comp/env/".length());
                object = context.lookup(name);
            } else {
                object = context.lookup(name);
            }
            if (object instanceof Context) {
                res.setResponseCode(14);
                return;
            }
            if (object == null) {
                throw new NullPointerException("lookup of '" + name + "' returned null");
            }
            if (object instanceof DataSource && object.getClass().getName().equals("org.apache.commons.dbcp.BasicDataSource")) {
                try {
                    DbcpDataSource cf = new DbcpDataSource(object);
                    DataSourceMetaData dataSourceMetaData = new DataSourceMetaData(cf.getDriverClassName(), cf.getUrl(), cf.getUsername(), cf.getPassword());
                    res.setResponseCode(22);
                    res.setResult((Object)dataSourceMetaData);
                }
                catch (Exception e) {
                    res.setResponseCode(19);
                    res.setResult((Object)new ThrowableArtifact((Throwable)e));
                }
                return;
            }
            if (object instanceof ConnectionFactory) {
                res.setResponseCode(24);
                res.setResult((Object)ConnectionFactory.class.getName());
                return;
            }
            if (object instanceof ORB) {
                res.setResponseCode(24);
                res.setResult((Object)ORB.class.getName());
                return;
            }
            ServiceRefData serviceRef = object instanceof ServiceRefData ? (ServiceRefData)object : ServiceRefData.getServiceRefData((Object)object);
            if (serviceRef != null) {
                PortRefMetaData portRefMetaData;
                WsMetaData serviceMetaData = new WsMetaData();
                String serviceClassName = null;
                if (serviceRef.getServiceClass() != null) {
                    serviceClassName = serviceRef.getServiceClass().getName();
                }
                serviceMetaData.setServiceClassName(serviceClassName);
                String referenceClassName = null;
                if (serviceRef.getReferenceClass() != null) {
                    referenceClassName = serviceRef.getReferenceClass().getName();
                }
                serviceMetaData.setReferenceClassName(referenceClassName);
                if (serviceRef.getServiceQName() != null) {
                    serviceMetaData.setServiceQName(serviceRef.getServiceQName().toString());
                }
                PortAddressRegistry portAddressRegistry = (PortAddressRegistry)SystemInstance.get().getComponent(PortAddressRegistry.class);
                Set portAddresses = null;
                if (portAddressRegistry != null) {
                    portAddresses = portAddressRegistry.getPorts(serviceRef.getId(), serviceRef.getServiceQName(), referenceClassName);
                }
                if (serviceRef.getWsdlURL() != null) {
                    serviceMetaData.setWsdlUrl(serviceRef.getWsdlURL().toExternalForm());
                }
                if (portAddresses.size() == 1) {
                    PortAddress portAddress = (PortAddress)portAddresses.iterator().next();
                    serviceMetaData.setWsdlUrl(portAddress.getAddress() + "?wsdl");
                }
                for (HandlerChainData handlerChain : serviceRef.getHandlerChains()) {
                    HandlerChainMetaData handlerChainMetaData = new HandlerChainMetaData();
                    handlerChainMetaData.setServiceNamePattern(handlerChain.getServiceNamePattern());
                    handlerChainMetaData.setPortNamePattern(handlerChain.getPortNamePattern());
                    handlerChainMetaData.getProtocolBindings().addAll(handlerChain.getProtocolBindings());
                    for (HandlerData handler2 : handlerChain.getHandlers()) {
                        CallbackMetaData callbackMetaData;
                        HandlerMetaData handlerMetaData = new HandlerMetaData();
                        handlerMetaData.setHandlerClass(handler2.getHandlerClass().getName());
                        for (Method method : handler2.getPostConstruct()) {
                            callbackMetaData = new CallbackMetaData();
                            callbackMetaData.setClassName(method.getDeclaringClass().getName());
                            callbackMetaData.setMethod(method.getName());
                            handlerMetaData.getPostConstruct().add(callbackMetaData);
                        }
                        for (Method method : handler2.getPreDestroy()) {
                            callbackMetaData = new CallbackMetaData();
                            callbackMetaData.setClassName(method.getDeclaringClass().getName());
                            callbackMetaData.setMethod(method.getName());
                            handlerMetaData.getPreDestroy().add(callbackMetaData);
                        }
                        handlerChainMetaData.getHandlers().add(handlerMetaData);
                    }
                    serviceMetaData.getHandlerChains().add(handlerChainMetaData);
                }
                HashMap<QName, PortRefMetaData> portsByQName = new HashMap<QName, PortRefMetaData>();
                for (PortRefData portRef : serviceRef.getPortRefs()) {
                    portRefMetaData = new PortRefMetaData();
                    portRefMetaData.setQName(portRef.getQName());
                    portRefMetaData.setServiceEndpointInterface(portRef.getServiceEndpointInterface());
                    portRefMetaData.setEnableMtom(portRef.isEnableMtom());
                    portRefMetaData.getProperties().putAll((Map<?, ?>)portRef.getProperties());
                    portRefMetaData.getAddresses().addAll(portRef.getAddresses());
                    if (portRef.getQName() != null) {
                        portsByQName.put(portRef.getQName(), portRefMetaData);
                    }
                    serviceMetaData.getPortRefs().add(portRefMetaData);
                }
                for (PortAddress portAddress : portAddresses) {
                    portRefMetaData = (PortRefMetaData)portsByQName.get(portAddress.getPortQName());
                    if (portRefMetaData == null) {
                        portRefMetaData = new PortRefMetaData();
                        portRefMetaData.setQName(portAddress.getPortQName());
                        portRefMetaData.setServiceEndpointInterface(portAddress.getServiceEndpointInterface());
                        portRefMetaData.getAddresses().add(portAddress.getAddress());
                        serviceMetaData.getPortRefs().add(portRefMetaData);
                        continue;
                    }
                    portRefMetaData.getAddresses().add(portAddress.getAddress());
                    if (portRefMetaData.getServiceEndpointInterface() != null) continue;
                    portRefMetaData.setServiceEndpointInterface(portAddress.getServiceEndpointInterface());
                }
                res.setResponseCode(25);
                res.setResult((Object)serviceMetaData);
                return;
            }
        }
        catch (NameNotFoundException e) {
            res.setResponseCode(16);
            return;
        }
        catch (NamingException e) {
            res.setResponseCode(17);
            res.setResult((Object)new ThrowableArtifact((Throwable)e));
            return;
        }
        try {
            handler = (BaseEjbProxyHandler)ProxyManager.getInvocationHandler((Object)object);
        }
        catch (Exception e) {
            if (object instanceof Serializable) {
                res.setResponseCode(12);
                res.setResult(object);
                return;
            }
            res.setResponseCode(17);
            NamingException namingException = new NamingException("Expected an ejb proxy, found unknown object: type=" + object.getClass().getName() + ", toString=" + object);
            res.setResult((Object)new ThrowableArtifact((Throwable)namingException));
            return;
        }
        ProxyInfo proxyInfo = handler.getProxyInfo();
        DeploymentInfo deployment = proxyInfo.getDeploymentInfo();
        String deploymentID = deployment.getDeploymentID().toString();
        this.updateServer(req, res, proxyInfo);
        switch (proxyInfo.getInterfaceType()) {
            case EJB_HOME: {
                res.setResponseCode(13);
                EJBMetaDataImpl metaData = new EJBMetaDataImpl(deployment.getHomeInterface(), deployment.getRemoteInterface(), deployment.getPrimaryKeyClass(), deployment.getComponentType().toString(), deploymentID, -1, ClientObjectFactory.convert(proxyInfo.getInterfaceType()), null);
                res.setResult((Object)metaData);
                break;
            }
            case EJB_LOCAL_HOME: {
                res.setResponseCode(17);
                NamingException namingException = new NamingException("Not remotable: '" + name + "'. EJBLocalHome interfaces are not remotable as per the EJB specification.");
                res.setResult((Object)new ThrowableArtifact((Throwable)namingException));
                break;
            }
            case BUSINESS_REMOTE: {
                res.setResponseCode(21);
                EJBMetaDataImpl metaData = new EJBMetaDataImpl(null, null, deployment.getPrimaryKeyClass(), deployment.getComponentType().toString(), deploymentID, -1, ClientObjectFactory.convert(proxyInfo.getInterfaceType()), proxyInfo.getInterfaces());
                metaData.setPrimaryKey(proxyInfo.getPrimaryKey());
                res.setResult((Object)metaData);
                break;
            }
            case BUSINESS_LOCAL: {
                res.setResponseCode(17);
                NamingException namingException = new NamingException("Not remotable: '" + name + "'. Business Local interfaces are not remotable as per the EJB specification.  To disable this restriction, set the system property 'openejb.remotable.businessLocals=true' in the server.");
                res.setResult((Object)new ThrowableArtifact((Throwable)namingException));
                break;
            }
            default: {
                res.setResponseCode(17);
                NamingException namingException = new NamingException("Not remotable: '" + name + "'.");
                res.setResult((Object)new ThrowableArtifact((Throwable)namingException));
            }
        }
    }

    protected void updateServer(JNDIRequest req, JNDIResponse res, ProxyInfo proxyInfo) {
        this.clusterableRequestHandler.updateServer(proxyInfo.getDeploymentInfo(), (ClusterableRequest)req, (ClusterableResponse)res);
    }

    private void doList(JNDIRequest req, JNDIResponse res, Context context) {
        String name = req.getRequestString();
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = context.list(name);
            if (namingEnumeration == null) {
                res.setResponseCode(12);
                res.setResult(null);
            } else {
                res.setResponseCode(15);
                ArrayList<NameClassPair> list = Collections.list(namingEnumeration);
                for (NameClassPair pair : list) {
                    if (!pair.getClassName().equals(IvmContext.class.getName())) continue;
                    pair.setClassName(Context.class.getName());
                }
                res.setResult((Object)new NameClassPairEnumeration(list));
            }
        }
        catch (NameNotFoundException e) {
            res.setResponseCode(16);
            return;
        }
        catch (NamingException e) {
            res.setResponseCode(17);
            res.setResult((Object)new ThrowableArtifact((Throwable)e));
            return;
        }
    }

    public static class DbcpDataSource {
        private final Object object;
        private final Class clazz;

        public DbcpDataSource(Object object) {
            this.clazz = object.getClass();
            this.object = object;
        }

        public String getDriverClassName() throws Exception {
            return (String)this.clazz.getMethod("getDriverClassName", new Class[0]).invoke(this.object, new Object[0]);
        }

        public String getPassword() throws Exception {
            return (String)this.clazz.getMethod("getPassword", new Class[0]).invoke(this.object, new Object[0]);
        }

        public String getUrl() throws Exception {
            return (String)this.clazz.getMethod("getUrl", new Class[0]).invoke(this.object, new Object[0]);
        }

        public String getUsername() throws Exception {
            return (String)this.clazz.getMethod("getUsername", new Class[0]).invoke(this.object, new Object[0]);
        }
    }
}

