/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.valueset;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.faktorips.valueset.ValueSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedValueSet<E>
implements Serializable,
ValueSet<E> {
    private static final long serialVersionUID = 1735375680693336950L;
    private boolean containsNull;
    private E nullValue;
    private final LinkedHashSet<E> set = new LinkedHashSet();
    private int hashCode;

    public OrderedValueSet(boolean containsNull, E nullValue, E ... values) {
        if (values != null) {
            for (E e : values) {
                if (this.set.contains(e)) {
                    throw new IllegalArgumentException("The provided values array contains duplicate entries.");
                }
                this.set.add(e);
            }
        }
        this.initialize(containsNull, nullValue);
    }

    public OrderedValueSet(Collection<E> values, boolean containsNull, E nullValue) {
        if (values != null) {
            for (E e : values) {
                if (this.set.contains(e)) {
                    throw new IllegalArgumentException("The provided values Collection contains duplicate entries.");
                }
                this.set.add(e);
            }
        }
        this.initialize(containsNull, nullValue);
    }

    private void initialize(boolean containsNull, E nullValue) {
        this.containsNull = containsNull;
        this.nullValue = nullValue;
        if (containsNull && !this.set.contains(nullValue)) {
            this.set.add(nullValue);
        }
        this.calculateHashCode();
    }

    private void calculateHashCode() {
        int result = 17;
        for (Object item : this.set) {
            if (item == null) continue;
            result = result * 37 + item.hashCode();
        }
        this.hashCode = result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private Set<E> getValuesWithoutNull() {
        if (this.containsNull) {
            Set set2 = (Set)this.set.clone();
            set2.remove(this.nullValue);
            return Collections.unmodifiableSet(set2);
        }
        return Collections.unmodifiableSet(this.set);
    }

    @Override
    public Set<E> getValues(boolean excludeNull) {
        return excludeNull ? this.getValuesWithoutNull() : Collections.unmodifiableSet(this.set);
    }

    @Override
    public final boolean isDiscrete() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OrderedValueSet) {
            OrderedValueSet other = (OrderedValueSet)obj;
            return this.set.equals(other.set) && this.containsNull == other.containsNull && (!this.containsNull || null == this.nullValue && null == other.nullValue || this.nullValue.equals(other.nullValue));
        }
        return false;
    }

    @Override
    public boolean containsNull() {
        return this.containsNull;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            buf.append(item);
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    @Override
    public boolean contains(Object value) {
        return this.set.contains(value);
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public int size() {
        return this.set.size();
    }
}

