/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.valueset;

import org.faktorips.values.Decimal;
import org.faktorips.values.Money;
import org.faktorips.valueset.DefaultRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoneyRange
extends DefaultRange<Money> {
    private static final long serialVersionUID = 4750295893441094927L;

    public static final MoneyRange valueOf(String lower, String upper) {
        return new MoneyRange(Money.valueOf(lower), Money.valueOf(upper));
    }

    public static final MoneyRange valueOf(String lower, String upper, String step, boolean containsNull) {
        return new MoneyRange(Money.valueOf(lower), Money.valueOf(upper), Money.valueOf(step), containsNull);
    }

    public static final MoneyRange valueOf(Money lower, Money upper, Money step) {
        return MoneyRange.valueOf(lower, upper, step, false);
    }

    public static final MoneyRange valueOf(Money lower, Money upper, Money step, boolean containsNull) {
        MoneyRange range = new MoneyRange(lower, upper, step, containsNull);
        range.checkIfStepFitsIntoBounds();
        return range;
    }

    public MoneyRange(Money lowerBound, Money upperBound) {
        super(lowerBound, upperBound);
    }

    private MoneyRange(Money lowerBound, Money upperBound, Money step, boolean containsNull) {
        super(lowerBound, upperBound, step, containsNull);
    }

    @Override
    protected boolean checkIfValueCompliesToStepIncrement(Money value, Money bound) {
        Decimal step = ((Money)this.getStep()).getAmount();
        Decimal zero = Decimal.valueOf(0L, step.scale());
        if (zero.equals(step)) {
            throw new IllegalArgumentException("The step size cannot be zero. Use null to indicate a continuous range.");
        }
        Decimal diff = bound.subtract(value).getAmount().abs();
        try {
            diff.divide(((Money)this.getStep()).getAmount(), 0, 7);
        }
        catch (ArithmeticException e) {
            return false;
        }
        return true;
    }

    @Override
    protected Money getNextValue(Money currentValue) {
        return currentValue.add((Money)this.getStep());
    }

    @Override
    public boolean contains(Money value) {
        if (value == null) {
            return false;
        }
        if (value.isNull()) {
            return this.containsNull();
        }
        return super.contains(value);
    }

    @Override
    protected int sizeForDiscreteValuesExcludingNull() {
        Decimal upperAmount = ((Money)this.getUpperBound()).getAmount();
        Decimal lowerAmount = ((Money)this.getLowerBound()).getAmount();
        Decimal stepAmount = ((Money)this.getStep()).getAmount();
        return upperAmount.subtract(lowerAmount).abs().divide(stepAmount, 0, 7).intValue() + 1;
    }

    @Override
    protected Money getNullValue() {
        return Money.NULL;
    }
}

