/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.valueset;

import java.math.BigInteger;
import org.faktorips.valueset.DefaultRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongRange
extends DefaultRange<Long> {
    private static final long serialVersionUID = -785773839824461985L;

    public static LongRange valueOf(String lower, String upper) {
        Long min = lower == null || lower.equals("") ? null : Long.valueOf(lower);
        Long max = upper == null || upper.equals("") ? null : Long.valueOf(upper);
        return new LongRange(min, max);
    }

    public static LongRange valueOf(String lower, String upper, String step, boolean containsNull) {
        Long min = lower == null || lower.equals("") ? null : Long.valueOf(lower);
        Long max = upper == null || upper.equals("") ? null : Long.valueOf(upper);
        Long stepLong = step == null || step.equals("") ? null : Long.valueOf(step);
        return new LongRange(min, max, stepLong, containsNull);
    }

    public static LongRange valueOf(Long lower, Long upper, Long step) {
        return LongRange.valueOf(lower, upper, step, false);
    }

    public static LongRange valueOf(Long lower, Long upper, Long step, boolean containsNull) {
        LongRange range = new LongRange(lower, upper, step, containsNull);
        range.checkIfStepFitsIntoBounds();
        return range;
    }

    public LongRange(Long lower, Long upper) {
        super(lower, upper, new Long(1L));
    }

    private LongRange(Long lower, Long upper, Long step, boolean containsNull) {
        super(lower, upper, step, containsNull);
    }

    @Override
    protected boolean checkIfValueCompliesToStepIncrement(Long value, Long bound) {
        if ((Long)this.getStep() == 0L) {
            throw new IllegalArgumentException("The step size cannot be zero. Use null to indicate a continuous range.");
        }
        BigInteger diff = BigInteger.valueOf(Math.abs((Long)this.getUpperBound() - (Long)this.getLowerBound()));
        BigInteger[] divAndRemainder = diff.divideAndRemainder(BigInteger.valueOf((Long)this.getStep()));
        return divAndRemainder[1].longValue() == 0L;
    }

    @Override
    protected int sizeForDiscreteValuesExcludingNull() {
        BigInteger diff = BigInteger.valueOf(Math.abs((Long)this.getUpperBound() - (Long)this.getLowerBound()));
        BigInteger[] divAndRemainder = diff.divideAndRemainder(BigInteger.valueOf((Long)this.getStep()));
        BigInteger returnValue = divAndRemainder[0].add(BigInteger.valueOf(1L));
        if (returnValue.longValue() > Integer.MAX_VALUE) {
            throw new RuntimeException("The number of values contained within this range are to huge to be supported by this operation.");
        }
        return returnValue.intValue();
    }

    @Override
    protected Long getNextValue(Long currentValue) {
        return currentValue + (Long)this.getStep();
    }

    @Override
    protected Long getNullValue() {
        return null;
    }
}

