/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.valueset;

import org.faktorips.valueset.DefaultRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerRange
extends DefaultRange<Integer> {
    private static final long serialVersionUID = 8454353227761904051L;

    public static IntegerRange valueOf(String lower, String upper) {
        Integer min = lower == null || lower.equals("") ? null : Integer.valueOf(lower);
        Integer max = upper == null || upper.equals("") ? null : Integer.valueOf(upper);
        return new IntegerRange(min, max);
    }

    public static IntegerRange valueOf(String lower, String upper, String step, boolean containsNull) {
        Integer min = lower == null || lower.equals("") ? null : Integer.valueOf(lower);
        Integer max = upper == null || upper.equals("") ? null : Integer.valueOf(upper);
        Integer stepInt = step == null || step.equals("") ? null : Integer.valueOf(step);
        return new IntegerRange(min, max, stepInt, containsNull);
    }

    public static IntegerRange valueOf(Integer lower, Integer upper, Integer step, boolean containsNull) {
        IntegerRange range = new IntegerRange(lower, upper, step, containsNull);
        range.checkIfStepFitsIntoBounds();
        return range;
    }

    public static IntegerRange valueOf(Integer lower, Integer upper, int step) {
        return IntegerRange.valueOf(lower, upper, new Integer(step), false);
    }

    public IntegerRange(Integer lower, Integer upper) {
        super(lower, upper, 1);
    }

    private IntegerRange(Integer lower, Integer upper, Integer step, boolean containsNull) {
        super(lower, upper, step, containsNull);
    }

    @Override
    protected boolean checkIfValueCompliesToStepIncrement(Integer value, Integer bound) {
        if ((Integer)this.getStep() == 0) {
            throw new IllegalArgumentException("The step size cannot be zero. Use null to indicate a continuous range.");
        }
        int diff = Math.abs(bound - value);
        int remaining = diff % (Integer)this.getStep();
        return remaining == 0;
    }

    @Override
    protected int sizeForDiscreteValuesExcludingNull() {
        int lowerInt = (Integer)this.getLowerBound();
        int upperInt = (Integer)this.getUpperBound();
        int diff = Math.abs(upperInt - lowerInt);
        return diff / (Integer)this.getStep() + 1;
    }

    @Override
    protected Integer getNextValue(Integer currentValue) {
        return currentValue + (Integer)this.getStep();
    }

    @Override
    protected Integer getNullValue() {
        return null;
    }
}

