/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.valueset;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.faktorips.values.NullObject;
import org.faktorips.values.NullObjectSupport;
import org.faktorips.valueset.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultRange<T extends Comparable<? super T>>
implements Range<T>,
Serializable {
    private static final long serialVersionUID = -2886828952622682290L;
    private T lowerBound;
    private T upperBound;
    private T step;
    private boolean containsNull = false;

    protected int sizeForDiscreteValuesExcludingNull() {
        throw new RuntimeException("Needs to be implemented if the range supports incremental steps.");
    }

    protected boolean checkIfValueCompliesToStepIncrement(T value, T bound) {
        throw new RuntimeException("Needs to be implemented if the range supports incremental steps.");
    }

    protected T getNextValue(T currentValue) {
        throw new RuntimeException("Needs to be implemented if the range supports incremental steps.");
    }

    protected T getNullValue() {
        throw new RuntimeException("Needs to be implemented if the range supports incremental steps.");
    }

    public DefaultRange(T lower, T upper) {
        this(lower, upper, null, false);
    }

    public DefaultRange(T lower, T upper, boolean containsNull) {
        this(lower, upper, null, containsNull);
    }

    public DefaultRange(T lower, T upper, T step) {
        this(lower, upper, step, false);
    }

    public DefaultRange(T lower, T upper, T step, boolean containsNull) {
        this.lowerBound = lower;
        this.upperBound = upper;
        this.step = step;
        this.containsNull = containsNull;
        this.checkIfStepFitsIntoBounds();
    }

    protected final void checkIfStepFitsIntoBounds() {
        if (this.isStepNull()) {
            return;
        }
        if (this.isLowerBoundNull() || this.isUpperBoundNull()) {
            return;
        }
        if (!this.checkIfValueCompliesToStepIncrement(this.getLowerBound(), this.getUpperBound())) {
            throw new IllegalArgumentException("The step doesn't fit into the specified bounds. The step has to comply to the condition: the value of the expression abs(upperBound - lowerBound) / step needs to be an integer.");
        }
    }

    @Override
    public T getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public T getUpperBound() {
        return this.upperBound;
    }

    @Override
    public T getStep() {
        return this.step;
    }

    @Override
    public boolean isEmpty() {
        if (this.isLowerBoundNull() || this.isUpperBoundNull()) {
            return false;
        }
        return this.lowerBound.compareTo(this.upperBound) > 0;
    }

    @Override
    public int size() {
        if (this.isLowerBoundNull() || this.isUpperBoundNull()) {
            return Integer.MAX_VALUE;
        }
        if (this.isEmpty()) {
            return 0;
        }
        if (this.getLowerBound().equals(this.getUpperBound())) {
            return 1;
        }
        if (this.isDiscrete()) {
            int size = this.sizeForDiscreteValuesExcludingNull();
            if (this.containsNull()) {
                return size + 1;
            }
            return size;
        }
        return Integer.MAX_VALUE;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        Range otherRange = (Range)obj;
        return DefaultRange.equals(this.lowerBound, otherRange.getLowerBound()) && DefaultRange.equals(this.upperBound, otherRange.getUpperBound()) && DefaultRange.equals(this.step, otherRange.getStep());
    }

    private static boolean equals(Object first, Object second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        return first.equals(second);
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + this.lowerBound.hashCode();
        result = result * 37 + this.upperBound.hashCode();
        result = this.step == null ? result : result * 37 + this.step.hashCode();
        return result;
    }

    public String toString() {
        return this.lowerBound + "-" + this.upperBound + (this.step != null && !(this.step instanceof NullObject) ? ", " + this.step : "");
    }

    private boolean isLowerBoundNull() {
        return this.lowerBound == null || this.getLowerBound() instanceof NullObjectSupport && ((NullObjectSupport)this.getLowerBound()).isNull();
    }

    private boolean isUpperBoundNull() {
        return this.upperBound == null || this.getUpperBound() instanceof NullObjectSupport && ((NullObjectSupport)this.getUpperBound()).isNull();
    }

    private boolean isStepNull() {
        return this.step == null || this.step instanceof NullObjectSupport && ((NullObjectSupport)this.step).isNull();
    }

    @Override
    public boolean contains(T value) {
        boolean withinBounds;
        if (value == null) {
            return this.containsNull();
        }
        boolean bl = withinBounds = !(!this.isLowerBoundNull() && value.compareTo(this.lowerBound) < 0 || !this.isUpperBoundNull() && value.compareTo(this.upperBound) > 0);
        if (withinBounds) {
            if (!this.isStepNull()) {
                if (!this.isLowerBoundNull()) {
                    return this.checkIfValueCompliesToStepIncrement(value, this.getLowerBound());
                }
                if (!this.isUpperBoundNull()) {
                    return this.checkIfValueCompliesToStepIncrement(value, this.getUpperBound());
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object value) {
        return this.contains((T)((Comparable)value));
    }

    @Override
    public boolean isDiscrete() {
        return !this.isStepNull();
    }

    @Override
    public boolean containsNull() {
        return this.containsNull;
    }

    @Override
    public Set<T> getValues(boolean excludeNull) {
        if (!this.isDiscrete()) {
            throw new IllegalStateException("This method cannot be called for ranges that are not discrete.");
        }
        if (this.size() == Integer.MAX_VALUE) {
            throw new IllegalStateException("This method cannot be called for unlimited ranges.");
        }
        int numberOfEntries = this.sizeForDiscreteValuesExcludingNull();
        HashSet<T> values = null;
        if (this.containsNull() && !excludeNull) {
            values = new HashSet(numberOfEntries + 1);
            values.add(this.getNullValue());
        } else {
            values = new HashSet<T>(numberOfEntries);
        }
        T nextValue = this.getLowerBound();
        values.add(nextValue);
        for (int i = 1; i < numberOfEntries; ++i) {
            nextValue = this.getNextValue(nextValue);
            values.add(nextValue);
        }
        return values;
    }
}

