/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.valueset;

import org.faktorips.values.Decimal;
import org.faktorips.valueset.DefaultRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecimalRange
extends DefaultRange<Decimal> {
    private static final long serialVersionUID = 5007646029371664759L;

    public static final DecimalRange valueOf(String lower, String upper) {
        return new DecimalRange(Decimal.valueOf(lower), Decimal.valueOf(upper));
    }

    public static final DecimalRange valueOf(String lower, String upper, String step, boolean containsNull) {
        return new DecimalRange(Decimal.valueOf(lower), Decimal.valueOf(upper), Decimal.valueOf(step), containsNull);
    }

    public static final DecimalRange valueOf(Decimal lower, Decimal upper, Decimal step) {
        return DecimalRange.valueOf(lower, upper, step, false);
    }

    public static final DecimalRange valueOf(Decimal lower, Decimal upper, Decimal step, boolean containsNull) {
        DecimalRange range = new DecimalRange(lower, upper, step, containsNull);
        range.checkIfStepFitsIntoBounds();
        return range;
    }

    public DecimalRange(Decimal lowerBound, Decimal upperBound) {
        super(lowerBound, upperBound);
    }

    private DecimalRange(Decimal lowerBound, Decimal upperBound, Decimal step, boolean containsNull) {
        super(lowerBound, upperBound, step, containsNull);
    }

    @Override
    protected boolean checkIfValueCompliesToStepIncrement(Decimal value, Decimal bound) {
        Decimal step = (Decimal)this.getStep();
        Decimal zero = Decimal.valueOf(0L, step.scale());
        if (zero.equals(step)) {
            throw new IllegalArgumentException("The step size cannot be zero. Use null to indicate a continuous range.");
        }
        Decimal diff = bound.subtract(value).abs();
        try {
            diff.divide((Decimal)this.getStep(), 0, 7);
        }
        catch (ArithmeticException e) {
            return false;
        }
        return true;
    }

    @Override
    protected int sizeForDiscreteValuesExcludingNull() {
        return ((Decimal)this.getUpperBound()).subtract((Decimal)this.getLowerBound()).abs().divide((Decimal)this.getStep(), 0, 7).intValue() + 1;
    }

    @Override
    protected Decimal getNextValue(Decimal currentValue) {
        return currentValue.add((Decimal)this.getStep());
    }

    @Override
    protected Decimal getNullValue() {
        return Decimal.NULL;
    }
}

