/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.valueset;

import java.math.BigDecimal;
import org.faktorips.valueset.DefaultRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimalRange
extends DefaultRange<BigDecimal> {
    private static final long serialVersionUID = -9040271817746215911L;

    public static final BigDecimalRange valueOf(String lower, String upper) {
        return new BigDecimalRange(new BigDecimal(lower), new BigDecimal(upper));
    }

    public static final BigDecimalRange valueOf(String lower, String upper, String step, boolean containsNull) {
        return new BigDecimalRange(new BigDecimal(lower), new BigDecimal(upper), new BigDecimal(step), containsNull);
    }

    public static final BigDecimalRange valueOf(BigDecimal lower, BigDecimal upper, BigDecimal step) {
        return BigDecimalRange.valueOf(lower, upper, step, false);
    }

    public static final BigDecimalRange valueOf(BigDecimal lower, BigDecimal upper, BigDecimal step, boolean containsNull) {
        BigDecimalRange range = new BigDecimalRange(lower, upper, step, containsNull);
        range.checkIfStepFitsIntoBounds();
        return range;
    }

    public BigDecimalRange(BigDecimal lowerBound, BigDecimal upperBound) {
        super(lowerBound, upperBound);
    }

    private BigDecimalRange(BigDecimal lowerBound, BigDecimal upperBound, BigDecimal step, boolean containsNull) {
        super(lowerBound, upperBound, step, containsNull);
    }

    @Override
    protected boolean checkIfValueCompliesToStepIncrement(BigDecimal value, BigDecimal bound) {
        BigDecimal step = (BigDecimal)this.getStep();
        BigDecimal zero = BigDecimal.valueOf(0L, step.scale());
        if (zero.equals(step)) {
            throw new IllegalArgumentException("The step size cannot be zero. Use null to indicate a continuous range.");
        }
        BigDecimal diff = bound.subtract(value).abs();
        try {
            diff.divide((BigDecimal)this.getStep(), 0, 7);
        }
        catch (ArithmeticException e) {
            return false;
        }
        return true;
    }

    @Override
    protected int sizeForDiscreteValuesExcludingNull() {
        return ((BigDecimal)this.getUpperBound()).subtract((BigDecimal)this.getLowerBound()).abs().divide((BigDecimal)this.getStep(), 0, 7).intValue() + 1;
    }

    @Override
    protected BigDecimal getNextValue(BigDecimal currentValue) {
        return currentValue.add((BigDecimal)this.getStep());
    }

    @Override
    protected BigDecimal getNullValue() {
        return null;
    }
}

